/*
 * Decompiled with CFR 0.152.
 */
package com.example.consumer1;

import com.google.common.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.somda.sdc.biceps.common.access.MdibAccessObserver;
import org.somda.sdc.biceps.common.event.AbstractMdibAccessMessage;
import org.somda.sdc.biceps.common.event.AlertStateModificationMessage;
import org.somda.sdc.biceps.common.event.ContextStateModificationMessage;
import org.somda.sdc.biceps.common.event.MetricStateModificationMessage;
import org.somda.sdc.biceps.common.event.OperationStateModificationMessage;
import org.somda.sdc.biceps.common.event.WaveformStateModificationMessage;

public class ConsumerReportProcessor
implements MdibAccessObserver {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerReportProcessor.class);
    public int numMetricChanges = 0;
    public int numConditionChanges = 0;

    @Subscribe
    void onUpdate(AbstractMdibAccessMessage updates) {
        LOG.debug("onUpdate: {}", (Object)updates.toString());
    }

    @Subscribe
    void onMetricChange(MetricStateModificationMessage modificationMessage) {
        LOG.info("onMetricChange");
        modificationMessage.getStates().forEach(state -> {
            LOG.info(state.toString());
            if (state.getDescriptorHandle().equals("numeric.ch1.vmd0")) {
                ++this.numMetricChanges;
                LOG.info("{} has changed", (Object)"numeric.ch1.vmd0");
            }
        });
    }

    @Subscribe
    void onWaveformChange(WaveformStateModificationMessage modificationMessage) {
        LOG.info("New waveform");
    }

    @Subscribe
    void onContextChange(ContextStateModificationMessage modificationMessage) {
        LOG.info("Context change");
    }

    @Subscribe
    void onAlertChange(AlertStateModificationMessage modificationMessage) {
        LOG.info("onAlertChange");
        modificationMessage.getStates().forEach(state -> {
            if (state.getDescriptorHandle().equals("ac0.mds0")) {
                ++this.numConditionChanges;
                LOG.info("{} has changed", (Object)"ac0.mds0");
            }
        });
    }

    @Subscribe
    void onOperationChange(OperationStateModificationMessage modificationMessage) {
        LOG.info("onOperationChange");
    }
}

