/*
 * Decompiled with CFR 0.152.
 */
package com.example.provider1;

import com.example.BaseUtil;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.somda.sdc.biceps.guice.DefaultBicepsConfigModule;
import org.somda.sdc.biceps.guice.DefaultBicepsModule;
import org.somda.sdc.biceps.model.participant.AbstractMetricValue;
import org.somda.sdc.biceps.model.participant.GenerationMode;
import org.somda.sdc.biceps.model.participant.MeasurementValidity;
import org.somda.sdc.common.guice.DefaultHelperModule;
import org.somda.sdc.dpws.crypto.CryptoSettings;
import org.somda.sdc.dpws.guice.DefaultDpwsModule;
import org.somda.sdc.glue.guice.DefaultGlueConfigModule;
import org.somda.sdc.glue.guice.DefaultGlueModule;
import org.somda.sdc.glue.guice.GlueDpwsConfigModule;

public class ProviderUtil
extends BaseUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderUtil.class);
    public static final String OPT_REPORT_INTERVAL = "report_interval";
    public static final String OPT_WAVEFORMS_INTERVAL = "waveform_interval";
    private static final String DEFAULT_REPORT_INTERVAL = "5000";
    private static final String DEFAULT_WAVEFORM_INTERVAL = "100";
    private final Injector injector;
    private final Duration reportInterval;
    private final Duration waveformInterval;

    public ProviderUtil(String[] args) {
        super(args);
        Configurator.initialize((Configuration)new DefaultConfiguration());
        Configurator.setRootLevel((Level)Level.INFO);
        this.reportInterval = Duration.ofMillis(Long.parseLong(this.getParsedArgs().getOptionValue(OPT_REPORT_INTERVAL, DEFAULT_REPORT_INTERVAL)));
        this.waveformInterval = Duration.ofMillis(Long.parseLong(this.getParsedArgs().getOptionValue(OPT_WAVEFORMS_INTERVAL, DEFAULT_WAVEFORM_INTERVAL)));
        this.injector = Guice.createInjector((Module[])new Module[]{new DefaultGlueModule(), new DefaultGlueConfigModule(), new DefaultBicepsModule(), new DefaultBicepsConfigModule(), new DefaultHelperModule(), new DefaultDpwsModule(), new GlueDpwsConfigModule(){

            protected void customConfigure() {
                super.customConfigure();
                this.bind("Dpws.Crypto.Settings", CryptoSettings.class, ProviderUtil.this.createCustomCryptoSettings());
                this.bind("Dpws.EnableHttps", Boolean.class, ProviderUtil.this.isUseTls());
                this.bind("Dpws.EnableHttp", Boolean.class, !ProviderUtil.this.isUseTls());
                this.bind("Dpws.Crypto.DeviceHostnameVerifier", HostnameVerifier.class, (hostname, session) -> {
                    try {
                        Certificate[] peerCerts = session.getPeerCertificates();
                        X509Certificate x509 = (X509Certificate)peerCerts[0];
                        List<String> extendedKeyUsage = x509.getExtendedKeyUsage();
                        if (extendedKeyUsage == null || extendedKeyUsage.isEmpty()) {
                            LOG.warn("No EKU in peer certificate");
                            return true;
                        }
                        for (String key : extendedKeyUsage) {
                            try {
                                URI keyUri = URI.create(key);
                                if (!keyUri.equals(URI.create("1.2.840.10004.20701.1.2"))) continue;
                                LOG.debug("SDC Service Consumer PKP found");
                                return true;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                        }
                        return true;
                    }
                    catch (Exception e) {
                        LOG.error("Error while validating client certificate: {}", (Object)e.getMessage());
                        LOG.trace("Error while validating client certificate", (Throwable)e);
                        return false;
                    }
                });
            }
        }});
    }

    public Injector getInjector() {
        return this.injector;
    }

    public static void addMetricQualityDemo(AbstractMetricValue val) {
        if (val.getMetricQuality() == null) {
            AbstractMetricValue.MetricQuality qual = new AbstractMetricValue.MetricQuality();
            qual.setMode(GenerationMode.DEMO);
            qual.setValidity(MeasurementValidity.VLD);
            val.setMetricQuality(qual);
        }
    }

    @Override
    protected Options configureOptions() {
        Options options = super.configureOptions();
        String message = "Interval in ms in which reports are being generated. Default: 5000";
        Option reportIntervalOpt = new Option(null, OPT_REPORT_INTERVAL, true, message);
        reportIntervalOpt.setType(Long.class);
        options.addOption(reportIntervalOpt);
        message = "Interval in ms in which waveforms are being generated. Default: 100";
        Option waveformIntervalOpt = new Option(null, OPT_WAVEFORMS_INTERVAL, true, message);
        waveformIntervalOpt.setType(Long.class);
        options.addOption(waveformIntervalOpt);
        return options;
    }

    public Duration getReportInterval() {
        return this.reportInterval;
    }

    public Duration getWaveformInterval() {
        return this.waveformInterval;
    }
}

