/*
 * Decompiled with CFR 0.152.
 */
package com.example.consumer1;

import com.example.consumer1.Consumer;
import com.example.consumer1.ConsumerReportProcessor;
import com.example.consumer1.ConsumerUtil;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.somda.sdc.biceps.common.access.MdibAccessObserver;
import org.somda.sdc.biceps.model.participant.ContextAssociation;
import org.somda.sdc.biceps.model.participant.InstanceIdentifier;
import org.somda.sdc.biceps.model.participant.LocationContextState;
import org.somda.sdc.biceps.model.participant.LocationDetail;
import org.somda.sdc.biceps.model.participant.PatientContextState;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.client.DiscoveryObserver;
import org.somda.sdc.dpws.client.event.ProbedDeviceFoundMessage;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.wsdiscovery.MatchBy;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryUtil;
import org.somda.sdc.glue.common.FallbackInstanceIdentifier;
import org.somda.sdc.glue.common.uri.LocationDetailQueryMapper;
import org.somda.sdc.glue.consumer.ConnectConfiguration;
import org.somda.sdc.glue.consumer.PrerequisitesException;
import org.somda.sdc.glue.consumer.SdcDiscoveryFilterBuilder;
import org.somda.sdc.glue.consumer.SdcRemoteDevice;
import org.somda.sdc.glue.consumer.SetServiceAccess;

public class ConsumerIT {
    private static final Logger LOG = LogManager.getLogger(ConsumerIT.class);
    private static final Duration MAX_WAIT = Duration.ofSeconds(11L);
    private static String[] args;
    private static Duration reportTimeout;
    private static String targetFacility;
    private static String targetBed;
    private static String targetPoC;
    private ConsumerReportProcessor reportObs;

    @BeforeAll
    static void setUp() {
        targetFacility = System.getenv().getOrDefault("ref_fac", "r_fac");
        targetBed = System.getenv().getOrDefault("ref_bed", "r_bed");
        targetPoC = System.getenv().getOrDefault("ref_poc", "r_poc");
        reportTimeout = Duration.ofSeconds(Long.parseLong(System.getProperty("reportTimeout", "30")));
    }

    @Test
    void runIT() throws Exception {
        ConsumerUtil settings = new ConsumerUtil(args);
        Consumer consumer = new Consumer(settings);
        consumer.startUp();
        String targetEpr = this.discoverDevice(consumer);
        assert (targetEpr != null);
        HostingServiceProxy hostingService = this.connectDevice(consumer, targetEpr);
        SdcRemoteDevice remoteDevice = this.connectMdibAndSubscribe(consumer, hostingService);
        this.verifyContexts(remoteDevice);
        this.verifyReports();
        this.verifyOperationInvocation(remoteDevice);
        remoteDevice.getMdibAccessObservable().unregisterObserver((MdibAccessObserver)this.reportObs);
        remoteDevice.stopAsync().awaitTerminated();
        consumer.shutDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String discoverDevice(Consumer consumer) throws Exception {
        final WsDiscoveryUtil wsdUtil = (WsDiscoveryUtil)consumer.getInjector().getInstance(WsDiscoveryUtil.class);
        LocationDetail location = new LocationDetail();
        location.setFacility(targetFacility);
        location.setBed(targetBed);
        location.setPoC(targetPoC);
        Optional instanceIdentifierOpt = FallbackInstanceIdentifier.create((LocationDetail)location);
        Assertions.assertTrue((boolean)instanceIdentifierOpt.isPresent());
        final String query = LocationDetailQueryMapper.createWithLocationDetailQuery((InstanceIdentifier)((InstanceIdentifier)instanceIdentifierOpt.get()), (LocationDetail)location);
        LOG.info("Starting discovery for location {}", (Object)query);
        final SettableFuture targetEpr = SettableFuture.create();
        DiscoveryObserver obs = new DiscoveryObserver(){

            @Subscribe
            void deviceFound(ProbedDeviceFoundMessage message) {
                DiscoveredDevice payload = (DiscoveredDevice)message.getPayload();
                if (wsdUtil.isScopesMatching(payload.getScopes(), List.of(query), MatchBy.RFC3986)) {
                    LOG.info("Found device with epr {}", (Object)payload.getEprAddress());
                    targetEpr.set((Object)payload.getEprAddress());
                } else {
                    LOG.info("Found non-matching device with epr {}", (Object)payload.getEprAddress());
                }
            }
        };
        consumer.getClient().registerDiscoveryObserver(obs);
        SdcDiscoveryFilterBuilder discoveryFilterBuilder = SdcDiscoveryFilterBuilder.create();
        discoveryFilterBuilder.addScope(query);
        consumer.getClient().probe(discoveryFilterBuilder.get());
        try {
            String string = (String)targetEpr.get(MAX_WAIT.toSeconds(), TimeUnit.SECONDS);
            return string;
        }
        catch (TimeoutException e) {
            targetEpr.cancel(true);
            LOG.error("Couldn't find target with location {} after {}s", (Object)location, (Object)MAX_WAIT.toSeconds(), (Object)e);
            Assertions.fail((String)String.format("Couldn't find target with location %s after %s", location, MAX_WAIT.toSeconds()), (Throwable)e);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Couldn't find target with location {}", (Object)location, (Object)e);
            Assertions.fail((String)("Couldn't find target with location " + location), (Throwable)e);
        }
        finally {
            consumer.getClient().unregisterDiscoveryObserver(obs);
        }
        return null;
    }

    HostingServiceProxy connectDevice(Consumer consumer, String targetEpr) throws InterceptorException {
        LOG.info("Connecting to {}", (Object)targetEpr);
        ListenableFuture hostingServiceFuture = consumer.getClient().connect(targetEpr);
        HostingServiceProxy hostingServiceProxy = null;
        try {
            hostingServiceProxy = (HostingServiceProxy)hostingServiceFuture.get(MAX_WAIT.toSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            LOG.error("Couldn't connect to EPR {} after {}s", (Object)targetEpr, (Object)MAX_WAIT.toSeconds(), (Object)e);
            Assertions.fail((String)String.format("Couldn't connect to EPR %s after %ss", targetEpr, MAX_WAIT.toSeconds()), (Throwable)e);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Couldn't connect to EPR {}", (Object)targetEpr, (Object)e);
            Assertions.fail((String)("Couldn't connect to EPR " + targetEpr), (Throwable)e);
        }
        return hostingServiceProxy;
    }

    SdcRemoteDevice connectMdibAndSubscribe(Consumer consumer, HostingServiceProxy hostingServiceProxy) {
        LOG.info("Attaching to remote mdib and subscriptions");
        ListenableFuture remoteDeviceFuture = null;
        SdcRemoteDevice sdcRemoteDevice = null;
        try {
            remoteDeviceFuture = consumer.getConnector().connect(hostingServiceProxy, ConnectConfiguration.create((Collection)ConnectConfiguration.ALL_EPISODIC_AND_WAVEFORM_REPORTS));
            sdcRemoteDevice = (SdcRemoteDevice)remoteDeviceFuture.get(MAX_WAIT.toSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            remoteDeviceFuture.cancel(true);
            LOG.error("Couldn't attach to remote mdib and subscriptions after {}s", (Object)MAX_WAIT.toSeconds(), (Object)e);
            Assertions.fail((String)String.format("Couldn't attach to remote mdib and subscriptions after %ss", MAX_WAIT.toSeconds()), (Throwable)e);
        }
        catch (InterruptedException | ExecutionException | PrerequisitesException e) {
            LOG.error("Couldn't attach to remote mdib and subscriptions", e);
            Assertions.fail((String)"Couldn't attach to remote mdib and subscriptions", (Throwable)e);
        }
        this.reportObs = new ConsumerReportProcessor();
        sdcRemoteDevice.getMdibAccessObservable().registerObserver((MdibAccessObserver)this.reportObs);
        return sdcRemoteDevice;
    }

    void verifyContexts(SdcRemoteDevice sdcRemoteDevice) {
        List contextStates = sdcRemoteDevice.getMdibAccess().getContextStates();
        long numPatientContexts = contextStates.stream().filter(x -> PatientContextState.class.isAssignableFrom(x.getClass())).filter(x -> ContextAssociation.ASSOC.equals((Object)x.getContextAssociation())).count();
        Assertions.assertTrue((numPatientContexts >= 1L ? 1 : 0) != 0, (String)"No associated patient context found");
        long numLocationContexts = contextStates.stream().filter(x -> LocationContextState.class.isAssignableFrom(x.getClass())).filter(x -> ContextAssociation.ASSOC.equals((Object)x.getContextAssociation())).filter(x -> targetFacility.equals(((LocationContextState)x).getLocationDetail().getFacility())).count();
        Assertions.assertTrue((numLocationContexts >= 1L ? 1 : 0) != 0, (String)"No associated location context matching discovery data found");
    }

    void verifyReports() throws InterruptedException {
        Thread.sleep(reportTimeout.toMillis());
        int minNumberReports = (int)reportTimeout.dividedBy(Duration.ofSeconds(5L)) - 1;
        Assertions.assertTrue((boolean)this.reportObs.getMetricChanges().values().stream().anyMatch(changes -> changes >= (long)minNumberReports), (String)("Did not receive metric reports, expected at least " + minNumberReports + " but received " + this.reportObs.getMetricChanges() + " instead."));
        Assertions.assertTrue((boolean)this.reportObs.getConditionChanges().values().stream().anyMatch(changes -> changes >= (long)minNumberReports), (String)("Did not receive alert condition reports, expected at least " + minNumberReports + " but received " + this.reportObs.getConditionChanges() + " instead."));
    }

    void verifyOperationInvocation(SdcRemoteDevice sdcRemoteDevice) {
        SetServiceAccess setServiceAccess = sdcRemoteDevice.getSetServiceAccess();
        boolean operationFailed = false;
        try {
            Consumer.invokeSetString(setServiceAccess, "string.ch0.vmd1_sco_0", "SDCri was here");
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            operationFailed = true;
            LOG.error("Could not invoke {}", (Object)"string.ch0.vmd1_sco_0", (Object)e);
        }
        try {
            Consumer.invokeSetString(setServiceAccess, "enumstring.ch0.vmd1_sco_0", "OFF");
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            operationFailed = true;
            LOG.error("Could not invoke {}", (Object)"enumstring.ch0.vmd1_sco_0", (Object)e);
        }
        try {
            Consumer.invokeSetValue(setServiceAccess, "numeric.ch0.vmd1_sco_0", BigDecimal.valueOf(20L));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            operationFailed = true;
            LOG.error("Could not invoke {}", (Object)"numeric.ch0.vmd1_sco_0", (Object)e);
        }
        try {
            Consumer.invokeActivate(setServiceAccess, "actop.vmd1_sco_0", Collections.emptyList());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            operationFailed = true;
            LOG.error("Could not invoke {}", (Object)"actop.vmd1_sco_0", (Object)e);
        }
        Assertions.assertFalse((boolean)operationFailed, (String)"Operation invocation failed unexpectedly, check the log");
        LOG.info("Done, quitting");
    }

    public static void main(String[] args) {
        ConsumerIT.args = args;
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(ConsumerIT.class)}).build();
        Launcher launcher = LauncherFactory.create();
        SummaryGeneratingListener listener = new SummaryGeneratingListener();
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
        launcher.execute(request, new TestExecutionListener[0]);
        TestExecutionSummary summary = listener.getSummary();
        List failures = summary.getFailures();
        LOG.info("getTestsSucceededCount() - {}", (Object)summary.getTestsSucceededCount());
        failures.forEach(failure -> LOG.error("failure", failure.getException()));
        System.exit(!failures.isEmpty() ? 1 : 0);
    }
}

