/*
 * Decompiled with CFR 0.152.
 */
package com.example.provider1;

import com.example.provider1.ProviderUtil;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.MdibStateModifications;
import org.somda.sdc.biceps.common.storage.PreprocessingException;
import org.somda.sdc.biceps.model.message.InvocationError;
import org.somda.sdc.biceps.model.message.InvocationState;
import org.somda.sdc.biceps.model.participant.AbstractMetricValue;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.EnumStringMetricDescriptor;
import org.somda.sdc.biceps.model.participant.LocalizedText;
import org.somda.sdc.biceps.model.participant.NumericMetricDescriptor;
import org.somda.sdc.biceps.model.participant.NumericMetricState;
import org.somda.sdc.biceps.model.participant.NumericMetricValue;
import org.somda.sdc.biceps.model.participant.SetStringOperationDescriptor;
import org.somda.sdc.biceps.model.participant.SetValueOperationDescriptor;
import org.somda.sdc.biceps.model.participant.StringMetricState;
import org.somda.sdc.biceps.model.participant.StringMetricValue;
import org.somda.sdc.biceps.provider.access.LocalMdibAccess;
import org.somda.sdc.glue.provider.sco.Context;
import org.somda.sdc.glue.provider.sco.IncomingSetServiceRequest;
import org.somda.sdc.glue.provider.sco.InvocationResponse;
import org.somda.sdc.glue.provider.sco.OperationInvocationReceiver;

public class OperationHandler
implements OperationInvocationReceiver {
    private static final Logger LOG = LogManager.getLogger(OperationHandler.class);
    private final LocalMdibAccess mdibAccess;

    public OperationHandler(LocalMdibAccess mdibAccess) {
        this.mdibAccess = mdibAccess;
    }

    LocalizedText createLocalizedText(String text) {
        return this.createLocalizedText(text, "en");
    }

    LocalizedText createLocalizedText(String text, String lang) {
        LocalizedText localizedText = new LocalizedText();
        localizedText.setValue(text);
        localizedText.setLang(lang);
        return localizedText;
    }

    InvocationResponse genericSetValue(Context context, BigDecimal data) {
        context.sendSuccessfulReport(InvocationState.START);
        String operationHandle = context.getOperationHandle();
        LOG.debug("Received SetValue request for {}: {}", (Object)operationHandle, (Object)data);
        SetValueOperationDescriptor setNumeric = (SetValueOperationDescriptor)this.mdibAccess.getDescriptor(operationHandle, SetValueOperationDescriptor.class).orElseThrow(() -> {
            LocalizedText errorMessage = this.createLocalizedText("Operation target cannot be found");
            context.sendUnsuccessfulReport(InvocationState.FAIL, InvocationError.OTH, List.of(errorMessage));
            throw new RuntimeException(String.format("Operation descriptor %s missing", operationHandle));
        });
        String operationTargetHandle = setNumeric.getOperationTarget();
        NumericMetricDescriptor targetDesc = (NumericMetricDescriptor)this.mdibAccess.getDescriptor(operationTargetHandle, NumericMetricDescriptor.class).orElseThrow(() -> {
            LocalizedText errorMessage = this.createLocalizedText("Operation target cannot be found");
            context.sendUnsuccessfulReport(InvocationState.FAIL, InvocationError.OTH, List.of(errorMessage));
            throw new RuntimeException(String.format("Operation target descriptor %s missing", operationTargetHandle));
        });
        targetDesc.getTechnicalRange().forEach(range -> {
            if (range.getLower() != null && range.getLower().compareTo(data) > 0) {
                LocalizedText errorMessage = this.createLocalizedText("Value too small");
                context.sendUnsuccessfulReport(InvocationState.FAIL, InvocationError.OTH, List.of(errorMessage));
                throw new RuntimeException(String.format("Operation set value below lower limit of %s, was %s", range.getLower(), data));
            }
            if (range.getUpper() != null && range.getUpper().compareTo(data) < 0) {
                LocalizedText errorMessage = this.createLocalizedText("Value too big");
                context.sendUnsuccessfulReport(InvocationState.FAIL, InvocationError.OTH, List.of(errorMessage));
                throw new RuntimeException(String.format("Operation set value below lower limit of %s, was %s", range.getLower(), data));
            }
        });
        NumericMetricState targetState = (NumericMetricState)this.mdibAccess.getState(operationTargetHandle, NumericMetricState.class).orElseThrow(() -> {
            LocalizedText errorMessage = this.createLocalizedText("Operation target state cannot be found");
            context.sendUnsuccessfulReport(InvocationState.FAIL, InvocationError.OTH, List.of(errorMessage));
            throw new RuntimeException(String.format("Operation target descriptor %s missing", operationTargetHandle));
        });
        if (targetState.getMetricValue() == null) {
            targetState.setMetricValue(new NumericMetricValue());
        }
        targetState.getMetricValue().setValue(data);
        targetState.getMetricValue().setDeterminationTime(Instant.now());
        ProviderUtil.addMetricQualityDemo((AbstractMetricValue)targetState.getMetricValue());
        MdibStateModifications mod = MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.METRIC);
        mod.add((AbstractState)targetState);
        try {
            this.mdibAccess.writeStates(mod);
            context.sendSuccessfulReport(InvocationState.FIN);
            return context.createSuccessfulResponse(InvocationState.FIN);
        }
        catch (PreprocessingException e) {
            LOG.error("Error while writing states", (Throwable)e);
            LocalizedText errorMessage = this.createLocalizedText("Error while writing states");
            context.sendUnsuccessfulReport(InvocationState.FAIL, InvocationError.UNSPEC, List.of(errorMessage));
            return context.createUnsuccessfulResponse(InvocationState.FAIL, InvocationError.UNSPEC, List.of(errorMessage));
        }
    }

    InvocationResponse genericSetString(Context context, String data, boolean isEnumString) {
        EnumStringMetricDescriptor targetDesc;
        Optional<EnumStringMetricDescriptor.AllowedValue> first;
        context.sendSuccessfulReport(InvocationState.START);
        String operationHandle = context.getOperationHandle();
        LOG.debug("Received SetString for {}: {}", (Object)operationHandle, (Object)data);
        SetStringOperationDescriptor setString = (SetStringOperationDescriptor)this.mdibAccess.getDescriptor(operationHandle, SetStringOperationDescriptor.class).orElseThrow(() -> {
            LocalizedText errorMessage = this.createLocalizedText("Operation target cannot be found");
            context.sendUnsuccessfulReport(InvocationState.FAIL, InvocationError.OTH, List.of(errorMessage));
            throw new RuntimeException(String.format("Operation descriptor %s missing", operationHandle));
        });
        String operationTargetHandle = setString.getOperationTarget();
        if (isEnumString && (first = (targetDesc = (EnumStringMetricDescriptor)this.mdibAccess.getDescriptor(operationTargetHandle, EnumStringMetricDescriptor.class).orElseThrow(() -> {
            LocalizedText errorMessage = this.createLocalizedText("Operation target descriptor cannot be found");
            context.sendUnsuccessfulReport(InvocationState.FAIL, InvocationError.OTH, List.of(errorMessage));
            throw new RuntimeException(String.format("Operation target descriptor %s missing", operationTargetHandle));
        })).getAllowedValue().stream().filter(x -> x.getValue().equals(data)).findFirst()).isEmpty()) {
            LocalizedText errormessage = this.createLocalizedText("Value is not allowed here");
            return context.createUnsuccessfulResponse(this.mdibAccess.getMdibVersion(), InvocationState.FAIL, InvocationError.UNSPEC, List.of(errormessage));
        }
        StringMetricState targetState = (StringMetricState)this.mdibAccess.getState(operationTargetHandle, StringMetricState.class).orElseThrow(() -> {
            LocalizedText errorMessage = this.createLocalizedText("Operation target state cannot be found");
            context.sendUnsuccessfulReport(InvocationState.FAIL, InvocationError.OTH, List.of(errorMessage));
            throw new RuntimeException(String.format("Operation target descriptor %s missing", operationTargetHandle));
        });
        if (targetState.getMetricValue() == null) {
            targetState.setMetricValue(new StringMetricValue());
        }
        targetState.getMetricValue().setValue(data);
        targetState.getMetricValue().setDeterminationTime(Instant.now());
        ProviderUtil.addMetricQualityDemo((AbstractMetricValue)targetState.getMetricValue());
        MdibStateModifications mod = MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.METRIC);
        mod.add((AbstractState)targetState);
        try {
            this.mdibAccess.writeStates(mod);
            context.sendSuccessfulReport(InvocationState.FIN);
            return context.createSuccessfulResponse(InvocationState.FIN);
        }
        catch (PreprocessingException e) {
            LOG.error("Error while writing states", (Throwable)e);
            LocalizedText errorMessage = this.createLocalizedText("Error while writing states");
            context.sendUnsuccessfulReport(InvocationState.FAIL, InvocationError.UNSPEC, List.of(errorMessage));
            return context.createUnsuccessfulResponse(InvocationState.FAIL, InvocationError.UNSPEC, List.of(errorMessage));
        }
    }

    @IncomingSetServiceRequest(operationHandle="numeric.ch0.vmd1_sco_0")
    InvocationResponse setSettableNumericMetric(Context context, BigDecimal data) {
        return this.genericSetValue(context, data);
    }

    @IncomingSetServiceRequest(operationHandle="string.ch0.vmd1_sco_0")
    InvocationResponse setSettableStringMetric(Context context, String data) {
        return this.genericSetString(context, data, false);
    }

    @IncomingSetServiceRequest(operationHandle="enumstring.ch0.vmd1_sco_0")
    InvocationResponse setSettableEnumMetric(Context context, String data) {
        return this.genericSetString(context, data, true);
    }

    @IncomingSetServiceRequest(operationHandle="actop.vmd1_sco_0", listType=String.class)
    InvocationResponse activateExample(Context context, List<String> args) {
        context.sendSuccessfulReport(InvocationState.START);
        LOG.info("Received Activate for {}", (Object)"actop.vmd1_sco_0");
        context.sendSuccessfulReport(InvocationState.FIN);
        return context.createSuccessfulResponse(this.mdibAccess.getMdibVersion(), InvocationState.FIN);
    }

    @IncomingSetServiceRequest(operationHandle="actop.mds0_sco_0", listType=String.class)
    InvocationResponse activateExample2(Context context, List<String> args) {
        context.sendSuccessfulReport(InvocationState.START);
        LOG.info("Received Activate for {}", (Object)context.getOperationHandle());
        context.sendSuccessfulReport(InvocationState.FIN);
        return context.createSuccessfulResponse(this.mdibAccess.getMdibVersion(), InvocationState.FIN);
    }
}

