/*
 * Decompiled with CFR 0.152.
 */
package com.example.provider1;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.MdibDescriptionModification;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.storage.DescriptionPreprocessingSegment;
import org.somda.sdc.biceps.common.storage.MdibStorage;
import org.somda.sdc.biceps.model.extension.ExtensionType;
import org.somda.sdc.biceps.model.message.Retrievability;
import org.somda.sdc.biceps.model.message.RetrievabilityInfo;
import org.somda.sdc.biceps.model.message.RetrievabilityMethod;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.RealTimeSampleArrayMetricDescriptor;

public class RetrievabilityModification
implements DescriptionPreprocessingSegment {
    private static Logger LOG = LogManager.getLogger(RetrievabilityModification.class);

    public void beforeFirstModification(MdibDescriptionModifications modifications, MdibStorage mdibStorage) {
        super.beforeFirstModification(modifications, mdibStorage);
    }

    public void afterLastModification(MdibDescriptionModifications modifications, MdibStorage mdibStorage) {
        super.afterLastModification(modifications, mdibStorage);
    }

    public void process(MdibDescriptionModifications allModifications, MdibDescriptionModification currentModification, MdibStorage storage) throws Exception {
        if (currentModification.getModificationType() == MdibDescriptionModification.Type.DELETE) {
            return;
        }
        AbstractDescriptor modificationDescriptor = currentModification.getDescriptor();
        ExtensionType extension = modificationDescriptor.getExtension();
        if (extension == null) {
            extension = new ExtensionType();
            modificationDescriptor.setExtension(extension);
        }
        Retrievability retrievability = extension.getAny().stream().filter(it -> it instanceof Retrievability).map(it -> (Retrievability)it).findFirst().orElseGet(() -> {
            Retrievability it = new Retrievability();
            LOG.debug("Creating new retrievability for {}", (Object)modificationDescriptor.getHandle());
            modificationDescriptor.getExtension().getAny().add(it);
            return it;
        });
        RetrievabilityInfo infoGet = new RetrievabilityInfo();
        infoGet.setMethod(RetrievabilityMethod.GET);
        if (modificationDescriptor instanceof RealTimeSampleArrayMetricDescriptor) {
            RetrievabilityInfo infoStrm = new RetrievabilityInfo();
            infoStrm.setMethod(RetrievabilityMethod.STRM);
            retrievability.setBy(List.of(infoGet, infoStrm));
        } else if (modificationDescriptor instanceof AbstractDescriptor) {
            RetrievabilityInfo infoStrm = new RetrievabilityInfo();
            infoStrm.setMethod(RetrievabilityMethod.EP);
            retrievability.setBy(List.of(infoGet, infoStrm));
        }
        LOG.debug("Retrievability for {} set to {}", (Object)modificationDescriptor.getHandle(), (Object)retrievability);
    }
}

