/*
 * Decompiled with CFR 0.152.
 */
package com.example.provider3_localization;

import com.example.BaseUtil;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.math.BigInteger;
import java.net.URI;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.somda.sdc.biceps.guice.DefaultBicepsConfigModule;
import org.somda.sdc.biceps.guice.DefaultBicepsModule;
import org.somda.sdc.biceps.model.participant.LocalizedText;
import org.somda.sdc.common.guice.DefaultCommonConfigModule;
import org.somda.sdc.common.guice.DefaultCommonModule;
import org.somda.sdc.dpws.crypto.CryptoSettings;
import org.somda.sdc.dpws.guice.DefaultDpwsModule;
import org.somda.sdc.glue.guice.DefaultGlueConfigModule;
import org.somda.sdc.glue.guice.DefaultGlueModule;
import org.somda.sdc.glue.guice.GlueDpwsConfigModule;
import org.somda.sdc.glue.provider.localization.LocalizationStorage;
import org.somda.sdc.glue.provider.localization.helper.HeapBasedLocalizationStorage;

class ProviderUtil
extends BaseUtil {
    private static final Logger LOG = LogManager.getLogger(ProviderUtil.class);
    private final Injector injector;

    public ProviderUtil(String[] args) {
        super(args);
        Configurator.reconfigure((Configuration)ProviderUtil.localLoggerConfig(Level.INFO));
        this.injector = Guice.createInjector((Module[])new Module[]{new DefaultCommonConfigModule(), new DefaultGlueModule(), new DefaultGlueConfigModule(), new DefaultBicepsModule(), new DefaultBicepsConfigModule(), new DefaultCommonModule(), new DefaultDpwsModule(), new GlueDpwsConfigModule(){

            protected void customConfigure() {
                super.customConfigure();
                this.bind("Dpws.Crypto.Settings", CryptoSettings.class, ProviderUtil.this.createCustomCryptoSettings());
                this.bind("Dpws.EnableHttps", Boolean.class, ProviderUtil.this.isUseTls());
                this.bind("Dpws.EnableHttp", Boolean.class, !ProviderUtil.this.isUseTls());
                this.bind("Dpws.Crypto.DeviceHostnameVerifier", HostnameVerifier.class, (hostname, session) -> {
                    try {
                        Certificate[] peerCerts = session.getPeerCertificates();
                        X509Certificate x509 = (X509Certificate)peerCerts[0];
                        List<String> extendedKeyUsage = x509.getExtendedKeyUsage();
                        if (extendedKeyUsage == null || extendedKeyUsage.isEmpty()) {
                            LOG.warn("No EKU in peer certificate");
                            return true;
                        }
                        for (String key : extendedKeyUsage) {
                            try {
                                URI keyUri = URI.create(key);
                                if (!keyUri.equals(URI.create("1.2.840.10004.20701.1.2"))) continue;
                                LOG.debug("SDC Service Consumer PKP found");
                                return true;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                        }
                        return true;
                    }
                    catch (Exception e) {
                        LOG.error("Error while validating client certificate: {}", (Object)e.getMessage());
                        LOG.trace("Error while validating client certificate", (Throwable)e);
                        return false;
                    }
                });
            }
        }});
    }

    Injector getInjector() {
        return this.injector;
    }

    LocalizationStorage getLocalizationStorage() {
        HeapBasedLocalizationStorage storage = new HeapBasedLocalizationStorage();
        storage.addAllLocalizedTexts(this.populateLocalizationData());
        return storage;
    }

    private List<LocalizedText> populateLocalizationData() {
        LocalizedText codingSystemNameEn = new LocalizedText();
        codingSystemNameEn.setRef("codingSystemName");
        codingSystemNameEn.setLang("en");
        codingSystemNameEn.setVersion(BigInteger.ONE);
        codingSystemNameEn.setValue("Common Parameter Nomenclature");
        LocalizedText codingSystemNameDe = new LocalizedText();
        codingSystemNameDe.setRef("codingSystemName");
        codingSystemNameDe.setLang("de");
        codingSystemNameDe.setVersion(BigInteger.ONE);
        codingSystemNameDe.setValue("Allgemeine Parameternomenklatur");
        LocalizedText conceptDescriptionEn = new LocalizedText();
        conceptDescriptionEn.setRef("conceptDescription");
        conceptDescriptionEn.setLang("en");
        conceptDescriptionEn.setVersion(BigInteger.ONE);
        conceptDescriptionEn.setValue("Concept Description");
        LocalizedText conceptDescriptionDe = new LocalizedText();
        conceptDescriptionDe.setRef("conceptDescription");
        conceptDescriptionDe.setLang("de");
        conceptDescriptionDe.setVersion(BigInteger.ONE);
        conceptDescriptionDe.setValue("Konzeptbeschreibung");
        return List.of(codingSystemNameEn, codingSystemNameDe, conceptDescriptionEn, conceptDescriptionDe);
    }
}

