/*
 * Decompiled with CFR 0.152.
 */
package com.example.consumer1;

import com.example.Constants;
import com.example.consumer1.ConsumerReportProcessor;
import com.example.consumer1.ConsumerUtil;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Injector;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.CodedValueUtil;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.access.MdibAccess;
import org.somda.sdc.biceps.common.access.MdibAccessObserver;
import org.somda.sdc.biceps.model.message.AbstractSet;
import org.somda.sdc.biceps.model.message.Activate;
import org.somda.sdc.biceps.model.message.ActivateResponse;
import org.somda.sdc.biceps.model.message.InvocationState;
import org.somda.sdc.biceps.model.message.OperationInvokedReport;
import org.somda.sdc.biceps.model.message.SetString;
import org.somda.sdc.biceps.model.message.SetStringResponse;
import org.somda.sdc.biceps.model.message.SetValue;
import org.somda.sdc.biceps.model.message.SetValueResponse;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.ActivateOperationDescriptor;
import org.somda.sdc.biceps.model.participant.CodedValue;
import org.somda.sdc.biceps.model.participant.EnumStringMetricDescriptor;
import org.somda.sdc.biceps.model.participant.LocationContextState;
import org.somda.sdc.biceps.model.participant.PatientContextState;
import org.somda.sdc.biceps.model.participant.SetStringOperationDescriptor;
import org.somda.sdc.biceps.model.participant.SetValueOperationDescriptor;
import org.somda.sdc.dpws.DpwsFramework;
import org.somda.sdc.dpws.client.Client;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.client.DiscoveryObserver;
import org.somda.sdc.dpws.client.event.ProbedDeviceFoundMessage;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.wsdl.WsdlRetriever;
import org.somda.sdc.glue.consumer.ConnectConfiguration;
import org.somda.sdc.glue.consumer.PrerequisitesException;
import org.somda.sdc.glue.consumer.SdcDiscoveryFilterBuilder;
import org.somda.sdc.glue.consumer.SdcRemoteDevice;
import org.somda.sdc.glue.consumer.SdcRemoteDevicesConnector;
import org.somda.sdc.glue.consumer.SetServiceAccess;
import org.somda.sdc.glue.consumer.sco.ScoTransaction;

public class Consumer {
    private static final Logger LOG = LogManager.getLogger(Consumer.class);
    private static final Duration MAX_WAIT = Duration.ofSeconds(11L);
    private static final long MAX_WAIT_SEC = MAX_WAIT.getSeconds();
    private static final long REPORT_TIMEOUT = Duration.ofSeconds(30L).toMillis();
    private final ConsumerUtil consumerUtil;
    private final Client client;
    private final SdcRemoteDevicesConnector connector;
    private DpwsFramework dpwsFramework;
    private final Injector injector;
    private NetworkInterface networkInterface;

    public Consumer(ConsumerUtil consumerUtil) throws SocketException, UnknownHostException {
        this.consumerUtil = consumerUtil;
        this.injector = consumerUtil.getInjector();
        this.client = (Client)this.injector.getInstance(Client.class);
        this.connector = (SdcRemoteDevicesConnector)this.injector.getInstance(SdcRemoteDevicesConnector.class);
        if (consumerUtil.getIface() != null && !consumerUtil.getIface().isBlank()) {
            LOG.info("Starting with interface {}", (Object)consumerUtil.getIface());
            this.networkInterface = NetworkInterface.getByName(consumerUtil.getIface());
        } else if (consumerUtil.getAddress() != null && !consumerUtil.getAddress().isBlank()) {
            LOG.info("Starting with address {}", (Object)consumerUtil.getAddress());
            this.networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(consumerUtil.getAddress()));
        } else {
            this.networkInterface = NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
            LOG.info("Starting with fallback default adapter {}", (Object)this.networkInterface);
        }
    }

    public Client getClient() {
        return this.client;
    }

    public SdcRemoteDevicesConnector getConnector() {
        return this.connector;
    }

    protected void startUp() {
        this.dpwsFramework = (DpwsFramework)this.injector.getInstance(DpwsFramework.class);
        this.dpwsFramework.setNetworkInterface(this.networkInterface);
        this.dpwsFramework.startAsync().awaitRunning();
        this.client.startAsync().awaitRunning();
    }

    protected void shutDown() {
        this.client.stopAsync().awaitTerminated();
        this.dpwsFramework.stopAsync().awaitTerminated();
    }

    static InvocationState invokeActivate(SetServiceAccess setServiceAccess, String handle, List<String> args) throws ExecutionException, InterruptedException, TimeoutException {
        LOG.info("Invoking Activate for handle {} with arguments {}", (Object)handle, args);
        Activate activate = new Activate();
        List argumentList = args.stream().map(x -> {
            Activate.Argument arg = new Activate.Argument();
            arg.setArgValue(x);
            return arg;
        }).collect(Collectors.toList());
        activate.setArgument(argumentList);
        activate.setOperationHandleRef(handle);
        ListenableFuture activateFuture = setServiceAccess.invoke((AbstractSet)activate, ActivateResponse.class);
        ScoTransaction activateResponse = (ScoTransaction)activateFuture.get(MAX_WAIT_SEC, TimeUnit.SECONDS);
        if (InvocationState.FAIL.equals((Object)((ActivateResponse)activateResponse.getResponse()).getInvocationInfo().getInvocationState())) {
            String err = "Activate operation execution invocation state failed";
            throw new ExecutionException(err, new InterruptedException(err));
        }
        List reportParts = activateResponse.waitForFinalReport(Duration.ofSeconds(5L));
        if (!reportParts.isEmpty()) {
            return ((OperationInvokedReport.ReportPart)((Pair)reportParts.get(reportParts.size() - 1)).getLeft()).getInvocationInfo().getInvocationState();
        }
        throw new InterruptedException("No report parts received, help.");
    }

    static InvocationState invokeSetValue(SetServiceAccess setServiceAccess, String handle, BigDecimal value) throws ExecutionException, InterruptedException, TimeoutException {
        LOG.info("Invoking SetValue for handle {} with value {}", (Object)handle, (Object)value);
        SetValue setValue = new SetValue();
        setValue.setOperationHandleRef(handle);
        setValue.setRequestedNumericValue(value);
        ListenableFuture setValueFuture = setServiceAccess.invoke((AbstractSet)setValue, SetValueResponse.class);
        ScoTransaction setValueResponse = (ScoTransaction)setValueFuture.get(MAX_WAIT_SEC, TimeUnit.SECONDS);
        if (InvocationState.FAIL.equals((Object)((SetValueResponse)setValueResponse.getResponse()).getInvocationInfo().getInvocationState())) {
            String err = "SetValue operation execution invocation state failed";
            throw new ExecutionException(err, new InterruptedException(err));
        }
        List reportParts = setValueResponse.waitForFinalReport(Duration.ofSeconds(5L));
        if (!reportParts.isEmpty()) {
            return ((OperationInvokedReport.ReportPart)((Pair)reportParts.get(reportParts.size() - 1)).getLeft()).getInvocationInfo().getInvocationState();
        }
        throw new InterruptedException("No report parts received, help.");
    }

    static InvocationState invokeSetString(SetServiceAccess setServiceAccess, String handle, String value) throws ExecutionException, InterruptedException, TimeoutException {
        LOG.info("Invoking SetString for handle {} with value {}", (Object)handle, (Object)value);
        SetString setString = new SetString();
        setString.setOperationHandleRef(handle);
        setString.setRequestedStringValue(value);
        ListenableFuture setStringFuture = setServiceAccess.invoke((AbstractSet)setString, SetStringResponse.class);
        ScoTransaction setStringResponse = (ScoTransaction)setStringFuture.get(MAX_WAIT_SEC, TimeUnit.SECONDS);
        if (InvocationState.FAIL.equals((Object)((SetStringResponse)setStringResponse.getResponse()).getInvocationInfo().getInvocationState())) {
            String err = "SetString operation execution invocation state failed";
            throw new ExecutionException(err, new InterruptedException(err));
        }
        List reportParts = setStringResponse.waitForFinalReport(Duration.ofSeconds(5L));
        if (!reportParts.isEmpty()) {
            return ((OperationInvokedReport.ReportPart)((Pair)reportParts.get(reportParts.size() - 1)).getLeft()).getInvocationInfo().getInvocationState();
        }
        throw new InterruptedException("No report parts received, help.");
    }

    static List<String> getHandleForCodedValue(MdibAccess mdib, CodedValue value, Class<? extends AbstractDescriptor> type) {
        Collection entities = mdib.findEntitiesByType(type);
        return entities.stream().filter(x -> CodedValueUtil.isEqual((CodedValue)x.getDescriptor().getType(), (CodedValue)value)).map(MdibEntity::getHandle).collect(Collectors.toList());
    }

    static List<List<String>> getPathToCodedValue(MdibAccess mdib, CodedValue value, Class<? extends AbstractDescriptor> type) {
        Collection entities = mdib.findEntitiesByType(type);
        List applicableEntities = entities.stream().filter(x -> CodedValueUtil.isEqual((CodedValue)x.getDescriptor().getType(), (CodedValue)value)).collect(Collectors.toList());
        return applicableEntities.stream().map(entity -> {
            MdibEntity currentEntity = entity;
            ArrayList<String> handles = new ArrayList<String>();
            while (currentEntity != null) {
                String handle = currentEntity.getHandle();
                handles.add(0, handle);
                if (currentEntity.getParent().isPresent()) {
                    currentEntity = mdib.getEntity((String)currentEntity.getParent().get()).orElse(null);
                    continue;
                }
                currentEntity = null;
            }
            return handles;
        }).collect(Collectors.toList());
    }

    public Injector getInjector() {
        return this.injector;
    }

    public static void main(String[] args) throws SocketException, UnknownHostException, InterceptorException, TransportException, InterruptedException {
        ConsumerUtil settings = new ConsumerUtil(args);
        final String targetEpr = settings.getEpr();
        Consumer consumer = new Consumer(settings);
        consumer.startUp();
        HashMap<Integer, Boolean> resultMap = new HashMap<Integer, Boolean>(Map.of(1, false, 2, false, 3, false, 4, false, 5, false, 6, false, 7, false, 8, false, 9, false, 10, false));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            ArrayList keys = new ArrayList(resultMap.keySet());
            Collections.sort(keys);
            keys.forEach(key -> System.out.printf("### Test %s ### %s%n", key, (Boolean)resultMap.get(key) != false ? "passed" : "failed"));
        }));
        LOG.info("Starting discovery for {}", (Object)targetEpr);
        final SettableFuture xAddrs = SettableFuture.create();
        DiscoveryObserver obs = new DiscoveryObserver(){

            @Subscribe
            void deviceFound(ProbedDeviceFoundMessage message) {
                DiscoveredDevice payload = (DiscoveredDevice)message.getPayload();
                if (payload.getEprAddress().equals(targetEpr)) {
                    LOG.info("Found device with epr {}", (Object)payload.getEprAddress());
                    xAddrs.set((Object)payload);
                } else {
                    LOG.info("Found non-matching device with epr {}", (Object)payload.getEprAddress());
                }
            }
        };
        consumer.getClient().registerDiscoveryObserver(obs);
        SdcDiscoveryFilterBuilder discoveryFilterBuilder = SdcDiscoveryFilterBuilder.create();
        consumer.getClient().probe(discoveryFilterBuilder.get());
        DiscoveredDevice d = null;
        try {
            List targetXAddrs = ((DiscoveredDevice)xAddrs.get(MAX_WAIT_SEC, TimeUnit.SECONDS)).getXAddrs();
            d = (DiscoveredDevice)xAddrs.get();
            resultMap.put(1, true);
        }
        catch (TimeoutException e) {
            xAddrs.cancel(true);
            LOG.error("Couldn't find target with EPR {} after {}s", (Object)targetEpr, (Object)MAX_WAIT_SEC, (Object)e);
            System.exit(1);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Couldn't find target with EPR {}", (Object)targetEpr, (Object)e);
            System.exit(1);
        }
        consumer.getClient().unregisterDiscoveryObserver(obs);
        LOG.info("Connecting to {}", (Object)targetEpr);
        ListenableFuture hostingServiceFuture = consumer.getClient().connect(d);
        HostingServiceProxy hostingServiceProxy = null;
        try {
            hostingServiceProxy = (HostingServiceProxy)hostingServiceFuture.get(MAX_WAIT_SEC, TimeUnit.SECONDS);
            resultMap.put(2, true);
        }
        catch (TimeoutException e) {
            xAddrs.cancel(true);
            LOG.error("Couldn't connect to EPR {} after {}s", (Object)targetEpr, (Object)MAX_WAIT_SEC, (Object)e);
            System.exit(1);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Couldn't connect to EPR {}", (Object)targetEpr, (Object)e);
            System.exit(1);
        }
        LOG.info("Retrieving device WSDL");
        WsdlRetriever wsdlRetriever = (WsdlRetriever)consumer.getInjector().getInstance(WsdlRetriever.class);
        try {
            Map wsdls = wsdlRetriever.retrieveWsdls(hostingServiceProxy);
            LOG.debug("Retrieved WSDLs");
            if (LOG.isDebugEnabled()) {
                wsdls.forEach((service, data) -> LOG.debug("WSDLs for service {}: {}", service, data));
            }
        }
        catch (IOException e) {
            LOG.error("Could not retrieve WSDL", (Throwable)e);
        }
        LOG.info("Attaching to remote mdib and subscriptions for {}", (Object)targetEpr);
        ListenableFuture remoteDeviceFuture = null;
        SdcRemoteDevice sdcRemoteDevice = null;
        try {
            remoteDeviceFuture = consumer.getConnector().connect(hostingServiceProxy, ConnectConfiguration.create((Collection)ConnectConfiguration.ALL_EPISODIC_AND_WAVEFORM_REPORTS));
            sdcRemoteDevice = (SdcRemoteDevice)remoteDeviceFuture.get(MAX_WAIT_SEC, TimeUnit.SECONDS);
            resultMap.put(3, true);
            resultMap.put(4, true);
        }
        catch (TimeoutException e) {
            remoteDeviceFuture.cancel(true);
            LOG.error("Couldn't attach to remote mdib and subscriptions for {} after {}s", (Object)targetEpr, (Object)MAX_WAIT_SEC, (Object)e);
            System.exit(1);
        }
        catch (InterruptedException | ExecutionException | PrerequisitesException e) {
            LOG.error("Couldn't attach to remote mdib and subscriptions for {}", (Object)targetEpr, (Object)e);
            System.exit(1);
        }
        ConsumerReportProcessor reportObs = new ConsumerReportProcessor();
        sdcRemoteDevice.getMdibAccessObservable().registerObserver((MdibAccessObserver)reportObs);
        List contextStates = sdcRemoteDevice.getMdibAccess().getContextStates();
        long numPatientContexts = contextStates.stream().filter(x -> PatientContextState.class.isAssignableFrom(x.getClass())).count();
        resultMap.put(5, numPatientContexts >= 1L);
        long numLocationContexts = contextStates.stream().filter(x -> LocationContextState.class.isAssignableFrom(x.getClass())).count();
        resultMap.put(6, numLocationContexts >= 1L);
        Thread.sleep(REPORT_TIMEOUT);
        long minNumberReports = REPORT_TIMEOUT / Duration.ofSeconds(5L).toMillis() - 1L;
        boolean metricChangesOk = reportObs.getMetricChanges().values().stream().anyMatch(changes -> changes >= minNumberReports);
        resultMap.put(7, metricChangesOk);
        if (!metricChangesOk) {
            LOG.info("Did not see enough metric changes, map: {}", reportObs.getMetricChanges());
        }
        boolean conditionChangesOk = reportObs.getConditionChanges().values().stream().anyMatch(changes -> changes >= minNumberReports);
        resultMap.put(8, conditionChangesOk);
        if (!conditionChangesOk) {
            LOG.info("Did not see enough alert changes, map: {}", reportObs.getConditionChanges());
        }
        SetServiceAccess setServiceAccess = sdcRemoteDevice.getSetServiceAccess();
        boolean operationFailed = false;
        List<String> setStringHandles = Consumer.getHandleForCodedValue(sdcRemoteDevice.getMdibAccess(), Constants.HANDLE_SET_STRING_CODE, SetStringOperationDescriptor.class);
        LOG.info("Found {} handles matching code {}", (Object)setStringHandles.size(), (Object)Constants.HANDLE_SET_STRING_CODE);
        boolean setStringAnyPass = false;
        for (String handle : setStringHandles) {
            try {
                LOG.info("Found handle {} and hardcoded handle was {}", (Object)handle, (Object)"string.ch0.vmd1_sco_0");
                Consumer.invokeSetString(setServiceAccess, handle, "SDCri was here");
                setStringAnyPass = true;
            }
            catch (IndexOutOfBoundsException | InterruptedException | ExecutionException | TimeoutException e) {
                LOG.error("Could not invoke {}", (Object)"string.ch0.vmd1_sco_0", (Object)e);
            }
        }
        if (!setStringAnyPass) {
            operationFailed = true;
        }
        List<List<String>> paths = Consumer.getPathToCodedValue(sdcRemoteDevice.getMdibAccess(), Constants.HANDLE_SET_STRING_ENUM_CODE, SetStringOperationDescriptor.class);
        LOG.info("Found {} paths matching code {}", (Object)paths.size(), (Object)Constants.HANDLE_SET_STRING_ENUM_CODE);
        boolean setEnumStringAnyPass = false;
        for (List<String> path : paths) {
            try {
                String handle = path.get(path.size() - 1);
                LOG.info("Found handle {} and hardcoded handle was {}", (Object)handle, (Object)"enumstring.ch0.vmd1_sco_0");
                SetStringOperationDescriptor opDesc = (SetStringOperationDescriptor)sdcRemoteDevice.getMdibAccess().getDescriptor(handle).get();
                EnumStringMetricDescriptor desc = (EnumStringMetricDescriptor)sdcRemoteDevice.getMdibAccess().getDescriptor(opDesc.getOperationTarget()).get();
                String value = ((EnumStringMetricDescriptor.AllowedValue)desc.getAllowedValue().get(0)).getValue();
                Consumer.invokeSetString(setServiceAccess, handle, value);
                setEnumStringAnyPass = true;
            }
            catch (IndexOutOfBoundsException | InterruptedException | ExecutionException | TimeoutException e) {
                operationFailed = true;
                LOG.error("Could not invoke {}", (Object)"enumstring.ch0.vmd1_sco_0", (Object)e);
            }
        }
        if (!setEnumStringAnyPass) {
            operationFailed = true;
        }
        List<String> setValueHandles = Consumer.getHandleForCodedValue(sdcRemoteDevice.getMdibAccess(), Constants.HANDLE_SET_VALUE_CODE, SetValueOperationDescriptor.class);
        LOG.info("Found {} setValueHandles matching code {}", (Object)setValueHandles.size(), (Object)Constants.HANDLE_SET_VALUE_CODE);
        boolean setValueAnyPass = false;
        for (String handle : setValueHandles) {
            try {
                LOG.info("Found handle {} and hardcoded handle was {}", (Object)handle, (Object)"numeric.ch0.vmd1_sco_0");
                Consumer.invokeSetValue(setServiceAccess, handle, BigDecimal.valueOf(20L));
                setValueAnyPass = true;
            }
            catch (IndexOutOfBoundsException | InterruptedException | ExecutionException | TimeoutException e) {
                LOG.error("Could not invoke {}", (Object)"numeric.ch0.vmd1_sco_0", (Object)e);
            }
        }
        if (!setValueAnyPass) {
            operationFailed = true;
        }
        List<List<String>> activatePaths = Consumer.getPathToCodedValue(sdcRemoteDevice.getMdibAccess(), Constants.HANDLE_ACTIVATE_CODE, ActivateOperationDescriptor.class);
        LOG.info("Found {} handles matching code {}", (Object)activatePaths.size(), (Object)Constants.HANDLE_ACTIVATE_CODE);
        boolean activateAnyPass = false;
        for (List<String> path : activatePaths) {
            try {
                String handle = path.get(path.size() - 1);
                LOG.info("Found handle {} and hardcoded handle was {}", (Object)handle, (Object)"actop.vmd1_sco_0");
                Consumer.invokeActivate(setServiceAccess, handle, Collections.emptyList());
                activateAnyPass = true;
            }
            catch (IndexOutOfBoundsException | InterruptedException | ExecutionException | TimeoutException e) {
                LOG.error("Could not invoke {}", (Object)"actop.vmd1_sco_0", (Object)e);
            }
        }
        if (!activateAnyPass) {
            operationFailed = true;
        }
        resultMap.put(9, !operationFailed);
        LOG.info("Done, quitting");
        sdcRemoteDevice.getMdibAccessObservable().unregisterObserver((MdibAccessObserver)reportObs);
        sdcRemoteDevice.stopAsync().awaitTerminated();
        try {
            boolean disconnectDone = consumer.getConnector().disconnect(targetEpr).isDone();
            consumer.shutDown();
            resultMap.put(10, disconnectDone);
        }
        catch (Exception e) {
            LOG.warn("Disconnect failed", (Throwable)e);
        }
    }
}

