/*
 * Decompiled with CFR 0.152.
 */
package com.example.consumer1;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.access.MdibAccessObserver;
import org.somda.sdc.biceps.common.event.AbstractMdibAccessMessage;
import org.somda.sdc.biceps.common.event.AlertStateModificationMessage;
import org.somda.sdc.biceps.common.event.ContextStateModificationMessage;
import org.somda.sdc.biceps.common.event.MetricStateModificationMessage;
import org.somda.sdc.biceps.common.event.OperationStateModificationMessage;
import org.somda.sdc.biceps.common.event.WaveformStateModificationMessage;
import org.somda.sdc.biceps.model.participant.AbstractMetricState;
import org.somda.sdc.biceps.model.participant.AlertConditionState;

public class ConsumerReportProcessor
implements MdibAccessObserver {
    private static final Logger LOG = LogManager.getLogger(ConsumerReportProcessor.class);
    private final HashMap<String, Long> metricChanges = new HashMap();
    private final HashMap<String, Long> conditionChanges = new HashMap();

    @Subscribe
    void onUpdate(AbstractMdibAccessMessage updates) {
        LOG.debug("onUpdate: {}", (Object)updates);
    }

    @Subscribe
    void onMetricChange(MetricStateModificationMessage modificationMessage) {
        LOG.info("onMetricChange");
        modificationMessage.getStates().forEach((mdsHandle, states) -> {
            for (AbstractMetricState state : states) {
                LOG.info(state.toString());
                String stateHandle = state.getDescriptorHandle();
                Long current = this.metricChanges.getOrDefault(stateHandle, 0L);
                current = current + 1L;
                this.metricChanges.put(stateHandle, current);
                LOG.info("{} has changed", (Object)state.getDescriptorHandle());
            }
        });
    }

    @Subscribe
    void onWaveformChange(WaveformStateModificationMessage modificationMessage) {
        LOG.info("New waveform");
    }

    @Subscribe
    void onContextChange(ContextStateModificationMessage modificationMessage) {
        LOG.info("Context change");
    }

    @Subscribe
    void onAlertChange(AlertStateModificationMessage modificationMessage) {
        LOG.info("onAlertChange");
        modificationMessage.getStates().values().stream().flatMap(it -> it.stream()).filter(it -> it instanceof AlertConditionState).forEach(state -> {
            String stateHandle = state.getDescriptorHandle();
            Long current = this.conditionChanges.getOrDefault(stateHandle, 0L);
            current = current + 1L;
            this.conditionChanges.put(stateHandle, current);
            LOG.info("{} has changed", (Object)state.getDescriptorHandle());
        });
    }

    @Subscribe
    void onOperationChange(OperationStateModificationMessage modificationMessage) {
        LOG.info("onOperationChange");
    }

    public HashMap<String, Long> getMetricChanges() {
        return this.metricChanges;
    }

    public HashMap<String, Long> getConditionChanges() {
        return this.conditionChanges;
    }
}

