/*
 * Decompiled with CFR 0.152.
 */
package com.example.consumer2_trackall_extension;

import com.example.consumer2_trackall_extension.ConsumerUtil;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Injector;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.FindExtensions;
import org.somda.sdc.biceps.common.access.MdibAccessObserver;
import org.somda.sdc.biceps.common.event.AbstractMdibAccessMessage;
import org.somda.sdc.biceps.common.event.MetricStateModificationMessage;
import org.somda.sdc.common.util.AutoLock;
import org.somda.sdc.dpws.DpwsFramework;
import org.somda.sdc.dpws.client.Client;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.client.DiscoveryObserver;
import org.somda.sdc.dpws.client.event.DeviceEnteredMessage;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.glue.consumer.ConnectConfiguration;
import org.somda.sdc.glue.consumer.PrerequisitesException;
import org.somda.sdc.glue.consumer.SdcRemoteDevice;
import org.somda.sdc.glue.consumer.SdcRemoteDevicesConnector;
import org.somda.sdc.glue.examples.extension.CompiledExtension;
import org.w3c.dom.Node;

public class Consumer
extends AbstractIdleService {
    private static final Logger LOG = LogManager.getLogger(Consumer.class);
    private static final Duration MAX_WAIT = Duration.ofSeconds(11L);
    private static final long MAX_WAIT_SEC = MAX_WAIT.getSeconds();
    private static final String EXTENSION_NAMESPACE = "http://biceps.extension";
    private static final String EXTENSION_STATE_NAME = "MyStateExtension";
    private final ConsumerUtil consumerUtil;
    private final Client client;
    private final SdcRemoteDevicesConnector connector;
    private final DpwsFramework dpwsFramework;
    private final NetworkInterface networkInterface;
    private HostingServiceProxy hostingServiceProxy;
    private SdcRemoteDevice sdcRemoteDevice;
    private final Thread connectorThread;
    private final Lock connectLock;
    private final Condition connectCondition;
    private int connectCount;

    Consumer(ConsumerUtil consumerUtil) throws SocketException, UnknownHostException {
        this.consumerUtil = consumerUtil;
        this.hostingServiceProxy = null;
        this.sdcRemoteDevice = null;
        this.connectCount = 0;
        this.connectLock = new ReentrantLock();
        this.connectCondition = this.connectLock.newCondition();
        this.connectCount = 0;
        Injector injector = consumerUtil.getInjector();
        this.dpwsFramework = (DpwsFramework)injector.getInstance(DpwsFramework.class);
        this.client = (Client)injector.getInstance(Client.class);
        this.connector = (SdcRemoteDevicesConnector)injector.getInstance(SdcRemoteDevicesConnector.class);
        if (consumerUtil.getIface() != null && !consumerUtil.getIface().isBlank()) {
            LOG.info("Starting with interface {}", (Object)consumerUtil.getIface());
            this.networkInterface = NetworkInterface.getByName(consumerUtil.getIface());
        } else if (consumerUtil.getAddress() != null && !consumerUtil.getAddress().isBlank()) {
            LOG.info("Starting with address {}", (Object)consumerUtil.getAddress());
            this.networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(consumerUtil.getAddress()));
        } else {
            this.networkInterface = NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
            LOG.info("Starting with fallback default adapter {}", (Object)this.networkInterface);
        }
        this.connectorThread = new Thread(new ConnectorThread());
        this.connectorThread.setDaemon(true);
    }

    public static void main(String[] args) throws Exception {
        ConsumerUtil settings = new ConsumerUtil(args);
        String targetEpr = settings.getEpr();
        if (targetEpr == null || targetEpr.isEmpty()) {
            LOG.error("An EPR is required but was not found (see command line argument --epr)");
            System.exit(1);
        }
        Consumer consumer = new Consumer(settings);
        consumer.startAsync().awaitRunning();
        LOG.info("Press any key to exit");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LOG.info("Shutting down");
        consumer.stopAsync().awaitTerminated();
    }

    protected void startUp() {
        this.dpwsFramework.setNetworkInterface(this.networkInterface);
        this.dpwsFramework.startAsync().awaitRunning();
        this.client.startAsync().awaitRunning();
        this.connectorThread.start();
        LOG.info("Starting implicit discovery of hosting service with EPR {}", (Object)this.consumerUtil.getEpr());
        this.client.registerDiscoveryObserver((DiscoveryObserver)new ImplicitDiscovery());
        LOG.info("Starting explicit discovery of hosting service with EPR {}", (Object)this.consumerUtil.getEpr());
        this.triggerConnect();
    }

    protected void shutDown() {
        this.connectorThread.interrupt();
        this.connector.stopAsync().awaitTerminated();
        this.client.stopAsync().awaitTerminated();
        this.dpwsFramework.stopAsync().awaitTerminated();
    }

    private void triggerConnect() {
        try (AutoLock ignored = AutoLock.lock((Lock)this.connectLock);){
            ++this.connectCount;
            this.connectCondition.signalAll();
        }
    }

    class ImplicitDiscovery
    implements DiscoveryObserver {
        ImplicitDiscovery() {
        }

        @Subscribe
        void deviceEntered(DeviceEnteredMessage message) {
            if (!((DiscoveredDevice)message.getPayload()).getEprAddress().equalsIgnoreCase(Consumer.this.consumerUtil.getEpr())) {
                LOG.info("Implicit discovery: EPR mismatch ({})", (Object)((DiscoveredDevice)message.getPayload()).getEprAddress());
                return;
            }
            LOG.info("Device with EPR {} entered the network. Try to connect.", (Object)Consumer.this.consumerUtil.getEpr());
            Consumer.this.triggerConnect();
        }
    }

    class ConnectorThread
    implements Runnable {
        ConnectorThread() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    AutoLock ignored = AutoLock.lock((Lock)Consumer.this.connectLock);
                    try {
                        if (Consumer.this.connectCount == 0) {
                            Consumer.this.connectCondition.await();
                            if (Consumer.this.connectCount == 0) continue;
                        }
                        --Consumer.this.connectCount;
                        this.connect();
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
                catch (InterceptorException e) {
                    LOG.warn((Object)e);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        private void connect() throws InterceptorException {
            if (Consumer.this.hostingServiceProxy != null) {
                LOG.info("Skip connect, SdcDevice with EPR {} already connected", (Object)Consumer.this.consumerUtil.getEpr());
                return;
            }
            LOG.info("Connect to EPR {}", (Object)Consumer.this.consumerUtil.getEpr());
            ListenableFuture hostingServiceFuture = Consumer.this.client.connect(Consumer.this.consumerUtil.getEpr());
            try {
                Consumer.this.hostingServiceProxy = (HostingServiceProxy)hostingServiceFuture.get(MAX_WAIT_SEC, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                LOG.warn("Explicit discovery failed after {}s. Waiting for device to join the network.", (Object)MAX_WAIT_SEC, (Object)e);
                return;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Explicit discovery failed. Waiting for device to join the network.", (Throwable)e);
                return;
            }
            try {
                ListenableFuture remoteDeviceFuture = Consumer.this.connector.connect(Consumer.this.hostingServiceProxy, ConnectConfiguration.create((Collection)ConnectConfiguration.ALL_EPISODIC_AND_WAVEFORM_REPORTS));
                Consumer.this.sdcRemoteDevice = (SdcRemoteDevice)remoteDeviceFuture.get(MAX_WAIT_SEC, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                LOG.error("Couldn't attach to remote MDIB and subscriptions for {} after {}s", (Object)Consumer.this.consumerUtil.getEpr(), (Object)MAX_WAIT_SEC, (Object)e);
                System.exit(1);
            }
            catch (InterruptedException | ExecutionException | PrerequisitesException e) {
                LOG.error("Couldn't attach to remote MDIB and subscriptions for {}", (Object)Consumer.this.consumerUtil.getEpr(), (Object)e);
                System.exit(1);
            }
            Consumer.this.sdcRemoteDevice.getMdibAccessObservable().registerObserver(new MdibAccessObserver(){

                @Subscribe
                void onUpdate(AbstractMdibAccessMessage updates) {
                    LOG.info("Received update: {}", (Object)updates.getClass().getSimpleName());
                    this.lookForExtensionFromProvider2Example(updates);
                }

                private void lookForExtensionFromProvider2Example(AbstractMdibAccessMessage updates) {
                    if (updates instanceof MetricStateModificationMessage) {
                        List<Node> anonymousExtensions = this.extractAnonymousExtensionNodesFromMessage((MetricStateModificationMessage)updates);
                        anonymousExtensions.forEach(extensionNode -> LOG.info("Received anonymous extension [{}]{}: '{}'", (Object)Consumer.EXTENSION_NAMESPACE, (Object)Consumer.EXTENSION_STATE_NAME, (Object)extensionNode.getTextContent()));
                        List<CompiledExtension> compiledExtensions = this.extractCompiledExtensionNodesFromMessage((MetricStateModificationMessage)updates);
                        compiledExtensions.forEach(extension -> LOG.info("Received compiled extension {}: '{}'", extension.getClass(), extension));
                    }
                }

                private List<Node> extractAnonymousExtensionNodesFromMessage(MetricStateModificationMessage message) {
                    return message.getStates().values().stream().flatMap(Collection::stream).flatMap(e -> FindExtensions.forQName((Object)e, (QName)new QName(Consumer.EXTENSION_NAMESPACE, Consumer.EXTENSION_STATE_NAME)).stream()).collect(Collectors.toList());
                }

                private List<CompiledExtension> extractCompiledExtensionNodesFromMessage(MetricStateModificationMessage message) {
                    return message.getStates().values().stream().flatMap(Collection::stream).flatMap(e -> FindExtensions.forClass((Object)e, CompiledExtension.class).stream()).collect(Collectors.toList());
                }
            });
        }
    }
}

