/*
 * Decompiled with CFR 0.152.
 */
package com.example.consumer3_localization;

import com.example.BaseUtil;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.somda.sdc.biceps.guice.DefaultBicepsConfigModule;
import org.somda.sdc.biceps.guice.DefaultBicepsModule;
import org.somda.sdc.common.guice.DefaultCommonConfigModule;
import org.somda.sdc.common.guice.DefaultCommonModule;
import org.somda.sdc.dpws.crypto.CryptoSettings;
import org.somda.sdc.dpws.guice.DefaultDpwsModule;
import org.somda.sdc.glue.guice.DefaultGlueConfigModule;
import org.somda.sdc.glue.guice.DefaultGlueModule;
import org.somda.sdc.glue.guice.GlueDpwsConfigModule;

class ConsumerUtil
extends BaseUtil {
    private static final Logger LOG = LogManager.getLogger(ConsumerUtil.class);
    private final Injector injector;

    ConsumerUtil(String[] args) {
        super(args);
        Configurator.reconfigure((Configuration)ConsumerUtil.localLoggerConfig(Level.INFO));
        this.injector = Guice.createInjector((Module[])new Module[]{new DefaultCommonConfigModule(), new DefaultGlueModule(), new DefaultGlueConfigModule(){

            protected void customConfigure() {
                super.customConfigure();
                this.bind("SdcGlue.Consumer.WatchdogPeriod", Duration.class, Duration.ofMinutes(1L));
            }
        }, new DefaultBicepsModule(), new DefaultBicepsConfigModule(), new DefaultCommonModule(), new DefaultDpwsModule(), new GlueDpwsConfigModule(){

            protected void customConfigure() {
                super.customConfigure();
                this.bind("Dpws.Crypto.Settings", CryptoSettings.class, ConsumerUtil.this.createCustomCryptoSettings());
                this.bind("Dpws.EnableHttps", Boolean.class, ConsumerUtil.this.isUseTls());
                this.bind("Dpws.EnableHttp", Boolean.class, !ConsumerUtil.this.isUseTls());
                this.bind("Dpws.Crypto.ClientHostnameVerifier", HostnameVerifier.class, (hostname, session) -> {
                    try {
                        Certificate[] peerCerts = session.getPeerCertificates();
                        X509Certificate x509 = (X509Certificate)peerCerts[0];
                        List<String> extendedKeyUsage = x509.getExtendedKeyUsage();
                        if (extendedKeyUsage == null || extendedKeyUsage.isEmpty()) {
                            LOG.warn("No EKU in peer certificate");
                            return true;
                        }
                        for (String key : extendedKeyUsage) {
                            try {
                                URI keyUri = URI.create(key);
                                if (!keyUri.equals(URI.create("1.2.840.10004.20701.1.1"))) continue;
                                LOG.debug("SDC Service Provider PKP found");
                                return true;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                        }
                        return true;
                    }
                    catch (Exception e) {
                        LOG.error("Error while validating provider certificate: {}", (Object)e.getMessage());
                        LOG.trace("Error while validating provider certificate", (Throwable)e);
                        return false;
                    }
                });
            }
        }});
    }

    Injector getInjector() {
        return this.injector;
    }
}

