/*
 * Decompiled with CFR 0.152.
 */
package com.example.provider1;

import com.example.provider1.OperationHandler;
import com.example.provider1.ProviderUtil;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.MdibStateModifications;
import org.somda.sdc.biceps.common.access.ReadTransaction;
import org.somda.sdc.biceps.common.storage.PreprocessingException;
import org.somda.sdc.biceps.model.participant.AbstractMetricValue;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.AlertConditionState;
import org.somda.sdc.biceps.model.participant.AlertSignalPresence;
import org.somda.sdc.biceps.model.participant.AlertSignalState;
import org.somda.sdc.biceps.model.participant.ContextAssociation;
import org.somda.sdc.biceps.model.participant.EnumStringMetricDescriptor;
import org.somda.sdc.biceps.model.participant.EnumStringMetricState;
import org.somda.sdc.biceps.model.participant.GenerationMode;
import org.somda.sdc.biceps.model.participant.InstanceIdentifier;
import org.somda.sdc.biceps.model.participant.LocationContextDescriptor;
import org.somda.sdc.biceps.model.participant.LocationContextState;
import org.somda.sdc.biceps.model.participant.LocationDetail;
import org.somda.sdc.biceps.model.participant.Mdib;
import org.somda.sdc.biceps.model.participant.MeasurementValidity;
import org.somda.sdc.biceps.model.participant.NumericMetricState;
import org.somda.sdc.biceps.model.participant.NumericMetricValue;
import org.somda.sdc.biceps.model.participant.RealTimeSampleArrayMetricState;
import org.somda.sdc.biceps.model.participant.SampleArrayValue;
import org.somda.sdc.biceps.model.participant.StringMetricState;
import org.somda.sdc.biceps.model.participant.StringMetricValue;
import org.somda.sdc.biceps.provider.access.LocalMdibAccess;
import org.somda.sdc.biceps.provider.access.factory.LocalMdibAccessFactory;
import org.somda.sdc.dpws.DpwsFramework;
import org.somda.sdc.dpws.DpwsUtil;
import org.somda.sdc.dpws.device.DeviceSettings;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.glue.common.FallbackInstanceIdentifier;
import org.somda.sdc.glue.common.MdibXmlIo;
import org.somda.sdc.glue.common.factory.ModificationsBuilderFactory;
import org.somda.sdc.glue.provider.SdcDevice;
import org.somda.sdc.glue.provider.SdcDevicePlugin;
import org.somda.sdc.glue.provider.factory.SdcDeviceFactory;
import org.somda.sdc.glue.provider.plugin.SdcRequiredTypesAndScopes;

public class Provider
extends AbstractIdleService {
    private static final Logger LOG = LogManager.getLogger(Provider.class);
    private static final int MAX_ENUM_ITERATIONS = 17;
    private final Injector injector;
    private final LocalMdibAccess mdibAccess;
    private final DpwsFramework dpwsFramework;
    private final SdcDevice sdcDevice;
    private InstanceIdentifier instanceIdentifier;
    private LocationDetail currentLocation;

    public Provider(ProviderUtil providerUtil) throws SocketException, UnknownHostException {
        NetworkInterface networkInterface;
        this.injector = providerUtil.getInjector();
        if (providerUtil.getIface() != null && !providerUtil.getIface().isEmpty()) {
            LOG.info("Starting with interface {}", (Object)providerUtil.getIface());
            networkInterface = NetworkInterface.getByName(providerUtil.getIface());
        } else if (providerUtil.getAddress() != null && !providerUtil.getAddress().isBlank()) {
            LOG.info("Starting with address {}", (Object)providerUtil.getAddress());
            networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(providerUtil.getAddress()));
        } else {
            networkInterface = NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
            LOG.info("Starting with fallback default adapter {}", (Object)networkInterface);
        }
        assert (networkInterface != null);
        this.dpwsFramework = (DpwsFramework)this.injector.getInstance(DpwsFramework.class);
        this.dpwsFramework.setNetworkInterface(networkInterface);
        this.mdibAccess = ((LocalMdibAccessFactory)this.injector.getInstance(LocalMdibAccessFactory.class)).createLocalMdibAccess();
        Object epr = providerUtil.getEpr();
        if (epr == null) {
            epr = "urn:uuid:" + UUID.randomUUID();
            LOG.info("No epr address provided, generated random epr {}", epr);
        }
        OperationHandler handler = new OperationHandler(this.mdibAccess);
        Object finalEpr = epr;
        this.sdcDevice = ((SdcDeviceFactory)this.injector.getInstance(SdcDeviceFactory.class)).createSdcDevice(new DeviceSettings((String)finalEpr, networkInterface){
            final /* synthetic */ String val$finalEpr;
            final /* synthetic */ NetworkInterface val$networkInterface;
            {
                this.val$finalEpr = string;
                this.val$networkInterface = networkInterface;
            }

            public EndpointReferenceType getEndpointReference() {
                return ((WsAddressingUtil)Provider.this.injector.getInstance(WsAddressingUtil.class)).createEprWithAddress(this.val$finalEpr);
            }

            public NetworkInterface getNetworkInterface() {
                return this.val$networkInterface;
            }
        }, this.mdibAccess, List.of(handler), Collections.singleton((SdcDevicePlugin)this.injector.getInstance(SdcRequiredTypesAndScopes.class)));
        this.instanceIdentifier = new InstanceIdentifier();
        this.instanceIdentifier.setRootName("AwesomeExampleInstance");
        this.currentLocation = null;
    }

    protected void startUp() throws Exception {
        DpwsUtil dpwsUtil = (DpwsUtil)this.injector.getInstance(DpwsUtil.class);
        this.sdcDevice.getHostingServiceAccess().setThisDevice(dpwsUtil.createDeviceBuilder().setFriendlyName(dpwsUtil.createLocalizedStrings().add("en", "Provider Example Unit").get()).setFirmwareVersion("v1.2.3").setSerialNumber("1234-5678-9101-1121").get());
        this.sdcDevice.getHostingServiceAccess().setThisModel(dpwsUtil.createModelBuilder().setManufacturer(dpwsUtil.createLocalizedStrings().add("en", "Provider Example Inc.").add("de", "Beispiel Provider AG").add("cn", "\u8303\u4f8b\u516c\u53f8").get()).setManufacturerUrl("http://www.example.com").setModelName(dpwsUtil.createLocalizedStrings().add("PEU").get()).setModelNumber("54-32-1").setPresentationUrl("http://www.example.com").get());
        ModificationsBuilderFactory modificationsBuilderFactory = (ModificationsBuilderFactory)this.injector.getInstance(ModificationsBuilderFactory.class);
        MdibXmlIo mdibXmlIo = (MdibXmlIo)this.injector.getInstance(MdibXmlIo.class);
        InputStream mdibAsStream = Provider.class.getClassLoader().getResourceAsStream("provider1/mdib.xml");
        if (mdibAsStream == null) {
            throw new RuntimeException("Could not load mdib.xml as resource");
        }
        Mdib mdib = mdibXmlIo.readMdib(mdibAsStream);
        MdibDescriptionModifications modifications = modificationsBuilderFactory.createModificationsBuilder(mdib).get();
        this.mdibAccess.writeDescription(modifications);
        if (this.currentLocation != null) {
            this.setLocation(this.currentLocation);
        }
        this.dpwsFramework.startAsync().awaitRunning();
        this.sdcDevice.startAsync().awaitRunning();
    }

    protected void shutDown() {
        this.sdcDevice.stopAsync().awaitTerminated();
        this.dpwsFramework.stopAsync().awaitTerminated();
        this.sdcDevice.stopAsync().awaitTerminated();
    }

    public void setLocation(LocationDetail location) throws PreprocessingException {
        Optional newInstanceIdentifier = FallbackInstanceIdentifier.create((LocationDetail)location);
        newInstanceIdentifier.ifPresent(ii -> {
            this.instanceIdentifier = ii;
            LOG.info("Updated instanceIdentifier to {}", (Object)ii.getRootName());
        });
        if (this.isRunning() || this.state() == Service.State.STARTING) {
            LOG.info("Updating location context");
            MdibStateModifications locMod = MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.CONTEXT);
            try (ReadTransaction readTransaction = this.mdibAccess.startTransaction();){
                LocationContextDescriptor locDesc = (LocationContextDescriptor)readTransaction.getDescriptor("LC.mds0", LocationContextDescriptor.class).orElseThrow(() -> new RuntimeException(String.format("Could not find state for handle %s", "LC.mds0")));
                LocationContextState locState = new LocationContextState();
                locState.setLocationDetail(location);
                locState.setDescriptorVersion(locDesc.getDescriptorVersion());
                locState.setDescriptorHandle(locDesc.getHandle());
                locState.setStateVersion(BigInteger.ONE);
                locState.setHandle(locDesc.getHandle() + "State");
                locState.setBindingMdibVersion(this.mdibAccess.getMdibVersion().getVersion());
                locState.setContextAssociation(ContextAssociation.ASSOC);
                locState.getValidator().add(this.instanceIdentifier);
                locState.getIdentification().add(this.instanceIdentifier);
                locMod.add((AbstractState)locState);
            }
            this.mdibAccess.writeStates(locMod);
        }
        this.currentLocation = location.clone();
    }

    public void changeWaveform(String handle) throws PreprocessingException {
        MdibStateModifications modifications = MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.WAVEFORM);
        try (ReadTransaction readTransaction = this.mdibAccess.startTransaction();){
            RealTimeSampleArrayMetricState state = (RealTimeSampleArrayMetricState)readTransaction.getState(handle, RealTimeSampleArrayMetricState.class).orElseThrow(() -> new RuntimeException(String.format("Could not find state for handle %s", handle)));
            AbstractMetricValue.MetricQuality metricQuality = new AbstractMetricValue.MetricQuality();
            metricQuality.setMode(GenerationMode.REAL);
            metricQuality.setValidity(MeasurementValidity.VLD);
            SampleArrayValue sampleArrayValue = new SampleArrayValue();
            sampleArrayValue.setMetricQuality(metricQuality);
            int minValue = 0;
            int maxValue = 50;
            int sampleCapacity = 10;
            LinkedList values = new LinkedList();
            double delta = Math.PI * 2 / (double)sampleCapacity;
            IntStream.range(0, sampleCapacity).forEachOrdered(n -> values.add(BigDecimal.valueOf((Math.sin((double)n * delta) + 1.0) / 2.0 * (double)(maxValue - minValue) + (double)minValue).setScale(15, RoundingMode.DOWN)));
            sampleArrayValue.setSamples(values);
            sampleArrayValue.setDeterminationTime(Instant.now());
            state.setMetricValue(sampleArrayValue);
            modifications.add((AbstractState)state);
        }
        this.mdibAccess.writeStates(modifications);
    }

    public void changeNumericMetric(String handle) throws PreprocessingException {
        Optional stateOpt = this.mdibAccess.getState(handle, NumericMetricState.class);
        NumericMetricState state = (NumericMetricState)stateOpt.get();
        NumericMetricValue val = state.getMetricValue();
        if (val != null && val.getValue() != null) {
            val.setValue(val.getValue().add(BigDecimal.ONE));
        } else {
            val = new NumericMetricValue();
            val.setValue(BigDecimal.ONE);
        }
        val.setDeterminationTime(Instant.now());
        ProviderUtil.addMetricQualityDemo((AbstractMetricValue)val);
        state.setMetricValue(val);
        this.mdibAccess.writeStates(MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.METRIC).add((AbstractState)state));
    }

    public void changeStringMetric(String handle) throws PreprocessingException {
        Optional stateOpt = this.mdibAccess.getState(handle, StringMetricState.class);
        StringMetricState state = (StringMetricState)stateOpt.get();
        StringMetricValue val = state.getMetricValue();
        if (val != null && val.getValue() != null) {
            String actVal = val.getValue();
            if (actVal.equals("UPPERCASE")) {
                val.setValue("lowercase");
            } else {
                val.setValue("UPPERCASE");
            }
        } else {
            val = new StringMetricValue();
            val.setValue("initial VALUE");
        }
        val.setDeterminationTime(Instant.now());
        ProviderUtil.addMetricQualityDemo((AbstractMetricValue)val);
        state.setMetricValue(val);
        this.mdibAccess.writeStates(MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.METRIC).add((AbstractState)state));
    }

    public void changeEnumStringMetric(String handle) throws PreprocessingException {
        Optional entityOpt = this.mdibAccess.getEntity(handle);
        MdibEntity mdibEntity = (MdibEntity)entityOpt.get();
        EnumStringMetricDescriptor descriptor = (EnumStringMetricDescriptor)mdibEntity.getDescriptor();
        List allowedValue = descriptor.getAllowedValue().stream().map(x -> x.getValue()).collect(Collectors.toList());
        EnumStringMetricState state = (EnumStringMetricState)mdibEntity.getStates().get(0);
        StringMetricValue val = state.getMetricValue();
        if (val != null && val.getValue() != null) {
            String actVal = val.getValue();
            Iterator iter = Iterables.cycle(allowedValue).iterator();
            String next = (String)iter.next();
            for (int i = 0; iter.hasNext() && i < 17; ++i) {
                if (next.equals(actVal)) {
                    next = (String)iter.next();
                    break;
                }
                next = (String)iter.next();
            }
            val.setValue(next);
        } else {
            val = new StringMetricValue();
            val.setValue((String)allowedValue.get(0));
        }
        val.setDeterminationTime(Instant.now());
        ProviderUtil.addMetricQualityDemo((AbstractMetricValue)val);
        state.setMetricValue(val);
        this.mdibAccess.writeStates(MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.METRIC).add((AbstractState)state));
    }

    public void changeAlertSignalAndConditionPresence(String signalHandle, String conditionHandle) {
        MdibEntity signalEntity = (MdibEntity)this.mdibAccess.getEntity(signalHandle).get();
        MdibEntity conditionEntity = (MdibEntity)this.mdibAccess.getEntity(conditionHandle).get();
        AlertSignalState signalState = (AlertSignalState)signalEntity.getStates().get(0);
        AlertConditionState conditionState = (AlertConditionState)conditionEntity.getStates().get(0);
        if (signalState.getPresence() == null || signalState.getPresence() == AlertSignalPresence.ON) {
            signalState.setPresence(AlertSignalPresence.OFF);
            conditionState.setPresence(Boolean.valueOf(false));
        } else {
            signalState.setPresence(AlertSignalPresence.ON);
            conditionState.setPresence(Boolean.valueOf(true));
        }
        try {
            this.mdibAccess.writeStates(MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.ALERT).add((AbstractState)conditionState).add((AbstractState)signalState));
        }
        catch (PreprocessingException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public static void main(String[] args) throws IOException, PreprocessingException {
        ProviderUtil util = new ProviderUtil(args);
        String targetFacility = System.getenv().getOrDefault("ref_fac", "r_fac");
        String targetBed = System.getenv().getOrDefault("ref_bed", "r_bed");
        String targetPoC = System.getenv().getOrDefault("ref_poc", "r_poc");
        Provider provider = new Provider(util);
        LocationDetail loc = new LocationDetail();
        loc.setBed(targetBed);
        loc.setPoC(targetPoC);
        loc.setFacility(targetFacility);
        provider.setLocation(loc);
        provider.startAsync().awaitRunning();
        long waveformInterval = util.getWaveformInterval().toMillis();
        LOG.info("Sending waveforms every {}ms", (Object)waveformInterval);
        Thread t1 = new Thread(() -> {
            try {
                while (true) {
                    Thread.sleep(waveformInterval);
                    provider.changeWaveform("rtsa.ch0.vmd0");
                }
            }
            catch (Exception e) {
                LOG.warn("Thread loop stopping", (Throwable)e);
                return;
            }
        });
        t1.setDaemon(true);
        t1.start();
        long reportInterval = util.getReportInterval().toMillis();
        LOG.info("Sending reports every {}ms", (Object)reportInterval);
        Thread t2 = new Thread(() -> {
            try {
                while (true) {
                    Thread.sleep(reportInterval);
                    provider.changeNumericMetric("numeric.ch1.vmd0");
                    provider.changeStringMetric("string2.ch0.vmd1");
                    provider.changeEnumStringMetric("enumstring2.ch0.vmd0");
                    provider.changeAlertSignalAndConditionPresence("as0.mds0", "ac0.mds0");
                }
            }
            catch (InterruptedException | PreprocessingException e) {
                LOG.warn("Thread loop stopping", e);
                return;
            }
        });
        t2.setDaemon(true);
        t2.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            t1.interrupt();
            t2.interrupt();
            provider.stopAsync().awaitTerminated();
        }));
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        t1.interrupt();
        t2.interrupt();
        provider.stopAsync().awaitTerminated();
    }
}

