
package org.somda.sdc.glue.examples.extension;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * <p>Java class for anonymous complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType>
 *   <complexContent>
 *     <extension base="{http://biceps.extension.jaxb}CompiledExtensionType">
 *       <attribute ref="{http://standards.ieee.org/downloads/11073/11073-10207-2017/extension}MustUnderstand"/>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
@XmlRootElement(name = "CompiledExtension", namespace = "http://biceps.extension.jaxb")
public class CompiledExtension
    extends CompiledExtensionType
    implements Cloneable, CopyTo, ToString
{

    /**
     * In cases where an extension modifies the meaning of the element that contains it, a MustUnderstand attribute is senseful. This means that the data cannot safely be processed unless the application knows the meaning of the extension. A MustUnderstand marked extension could be look like this:
     * 
     * tns:Extension xmlns:tns="http://standards.ieee.org/downloads/11073/11073-10207-2017/extension" xmlns:ext="http://concrete-extension-namespace"
     *   ext:AdditionalInfo tns:MustUnderstand="true"
     *     ...
     * 
     * 
     * Extensions are not required to provide a MustUnderstand attribute. If no MustUnderstand attribute is present, false is assumed. The MustUnderstand attribute is conceptually borrowed from SOAP header's "mustUnderstand" attribute.
     * 
     */
    @XmlAttribute(name = "MustUnderstand", namespace = "http://standards.ieee.org/downloads/11073/11073-10207-2017/extension")
    protected Boolean mustUnderstand;

    /**
     * In cases where an extension modifies the meaning of the element that contains it, a MustUnderstand attribute is senseful. This means that the data cannot safely be processed unless the application knows the meaning of the extension. A MustUnderstand marked extension could be look like this:
     * 
     * tns:Extension xmlns:tns="http://standards.ieee.org/downloads/11073/11073-10207-2017/extension" xmlns:ext="http://concrete-extension-namespace"
     *   ext:AdditionalInfo tns:MustUnderstand="true"
     *     ...
     * 
     * 
     * Extensions are not required to provide a MustUnderstand attribute. If no MustUnderstand attribute is present, false is assumed. The MustUnderstand attribute is conceptually borrowed from SOAP header's "mustUnderstand" attribute.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isMustUnderstand() {
        if (mustUnderstand == null) {
            return false;
        } else {
            return mustUnderstand;
        }
    }

    /**
     * Sets the value of the mustUnderstand property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isMustUnderstand()
     */
    public void setMustUnderstand(Boolean value) {
        this.mustUnderstand = value;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final CompiledExtension that = ((CompiledExtension) object);
        {
            boolean leftMustUnderstand;
            leftMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
            boolean rightMustUnderstand;
            rightMustUnderstand = ((that.mustUnderstand!= null)?that.isMustUnderstand():false);
            if (this.mustUnderstand!= null) {
                if (that.mustUnderstand!= null) {
                    if (leftMustUnderstand!= rightMustUnderstand) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.mustUnderstand!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            boolean theMustUnderstand;
            theMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
            if (this.mustUnderstand!= null) {
                currentHashCode += (theMustUnderstand? 1231 : 1237);
            }
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            boolean theMustUnderstand;
            theMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
            strategy.appendField(locator, this, "mustUnderstand", buffer, theMustUnderstand, (this.mustUnderstand!= null));
        }
        return buffer;
    }

    @Override
    public Object clone() {
        return copyTo(createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return copyTo(null, target, strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        super.copyTo(locator, draftCopy, strategy);
        if (draftCopy instanceof CompiledExtension) {
            final CompiledExtension copy = ((CompiledExtension) draftCopy);
            {
                Boolean mustUnderstandShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.mustUnderstand!= null));
                if (mustUnderstandShouldBeCopiedAndSet == Boolean.TRUE) {
                    boolean sourceMustUnderstand;
                    sourceMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
                    boolean copyMustUnderstand = strategy.copy(LocatorUtils.property(locator, "mustUnderstand", sourceMustUnderstand), sourceMustUnderstand, (this.mustUnderstand!= null));
                    copy.setMustUnderstand(copyMustUnderstand);
                } else {
                    if (mustUnderstandShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.mustUnderstand = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new CompiledExtension();
    }

}
