/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.dpws.crypto.CachingCryptoSettings;

public class CustomCryptoSettings
implements CachingCryptoSettings {
    private static final Logger LOG = LogManager.getLogger(CustomCryptoSettings.class);
    private static final String DEFAULT_KEYSTORE = "crypto/sdcparticipant.jks";
    private static final String DEFAULT_TRUSTSTORE = "crypto/root.jks";
    private static final String DEFAULT_KEYSTORE_PASSWORD = "whatever";
    private static final String DEFAULT_TRUSTSTORE_PASSWORD = "whatever";
    private byte[] keyStore = null;
    private byte[] trustStore = null;
    private String keyStorePassword = null;
    private String trustStorePassword = null;
    private @Nullable SSLContext cachedContext = null;

    public CustomCryptoSettings(byte[] keyStore, byte[] trustStore, String keyStorePassword, String trustStorePassword) {
        this.keyStore = keyStore;
        this.trustStore = trustStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStorePassword = trustStorePassword;
    }

    public CustomCryptoSettings() {
    }

    public static CustomCryptoSettings fromKeyStore(String keyStorePath, String trustStorePath, String keyStorePassword, String trustStorePassword) {
        byte[] trustStoreFile;
        byte[] keyStoreFile;
        try {
            keyStoreFile = Files.readAllBytes(Path.of(keyStorePath, new String[0]));
            trustStoreFile = Files.readAllBytes(Path.of(trustStorePath, new String[0]));
        }
        catch (IOException e) {
            LOG.error("Specified store file could not be found", (Throwable)e);
            throw new RuntimeException("Specified store file could not be found", e);
        }
        return new CustomCryptoSettings(keyStoreFile, trustStoreFile, keyStorePassword, trustStorePassword);
    }

    public static CustomCryptoSettings fromKeyFile(String userKeyFilePath, String userCertFilePath, String caCertFilePath, String userKeyPassword) {
        KeyStore trustStore;
        KeyStore keyStore;
        Certificate caCert;
        Certificate userCert;
        PrivateKey userKey;
        byte[] caCertFile;
        byte[] userCertFile;
        byte[] userKeyFile;
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            userKeyFile = Files.readAllBytes(Path.of(userKeyFilePath, new String[0]));
            userCertFile = Files.readAllBytes(Path.of(userCertFilePath, new String[0]));
            caCertFile = Files.readAllBytes(Path.of(caCertFilePath, new String[0]));
        }
        catch (IOException e) {
            LOG.error("Specified certificate file could not be found", (Throwable)e);
            throw new RuntimeException("Specified certificate file could not be found", e);
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            userKey = CustomCryptoSettings.getPrivateKey(userKeyFile, userKeyPassword);
            userCert = cf.generateCertificate(new ByteArrayInputStream(userCertFile));
            caCert = cf.generateCertificate(new ByteArrayInputStream(caCertFile));
        }
        catch (IOException | CertificateException e) {
            LOG.error("Specified certificate file could not be loaded", (Throwable)e);
            throw new RuntimeException("Specified certificate file could not be loaded", e);
        }
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.error("Error creating keystore instance", (Throwable)e);
            throw new RuntimeException("Error creating keystore instance", e);
        }
        try {
            keyStore.setKeyEntry("key", userKey, userKeyPassword.toCharArray(), new Certificate[]{userCert});
            trustStore.setCertificateEntry("ca", caCert);
        }
        catch (KeyStoreException e) {
            LOG.error("Error loading certificate into keystore instance", (Throwable)e);
            throw new RuntimeException("Error loading certificate into keystore instance", e);
        }
        ByteArrayOutputStream keyStoreOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream trustStoreOutputStream = new ByteArrayOutputStream();
        try {
            keyStore.store(keyStoreOutputStream, userKeyPassword.toCharArray());
            trustStore.store(trustStoreOutputStream, userKeyPassword.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.error("Error converting keystore to stream", (Throwable)e);
            throw new RuntimeException("Error converting keystore to stream", e);
        }
        return new CustomCryptoSettings(keyStoreOutputStream.toByteArray(), trustStoreOutputStream.toByteArray(), userKeyPassword, userKeyPassword);
    }

    private static PrivateKey getPrivateKey(byte[] key, String password) throws IOException {
        PrivateKeyInfo decrypted;
        InputDecryptorProvider pkcs8Prov;
        PEMParser pp = new PEMParser((Reader)new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(key), StandardCharsets.UTF_8)));
        PKCS8EncryptedPrivateKeyInfo pemKey = (PKCS8EncryptedPrivateKeyInfo)pp.readObject();
        pp.close();
        try {
            pkcs8Prov = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(password.toCharArray());
        }
        catch (OperatorCreationException e) {
            throw new IOException(e);
        }
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider((Provider)new BouncyCastleProvider());
        try {
            decrypted = pemKey.decryptPrivateKeyInfo(pkcs8Prov);
        }
        catch (PKCSException e) {
            throw new IOException(e);
        }
        return converter.getPrivateKey(decrypted);
    }

    public Optional<InputStream> getKeyStoreStream() {
        if (this.keyStore != null) {
            return Optional.of(new ByteArrayInputStream(this.keyStore));
        }
        return Optional.ofNullable(this.getClass().getClassLoader().getResourceAsStream(DEFAULT_KEYSTORE));
    }

    public String getKeyStorePassword() {
        return Objects.requireNonNullElse(this.keyStorePassword, "whatever");
    }

    public Optional<InputStream> getTrustStoreStream() {
        if (this.trustStore != null) {
            return Optional.of(new ByteArrayInputStream(this.trustStore));
        }
        return Optional.ofNullable(this.getClass().getClassLoader().getResourceAsStream(DEFAULT_TRUSTSTORE));
    }

    public String getTrustStorePassword() {
        return Objects.requireNonNullElse(this.trustStorePassword, "whatever");
    }

    public synchronized Optional<SSLContext> getSslContext() {
        return Optional.ofNullable(this.cachedContext);
    }

    public synchronized void setSslContext(SSLContext sslContext) {
        this.cachedContext = sslContext;
    }
}

