/*
 * Decompiled with CFR 0.152.
 */
package com.example.provider1;

import com.example.BaseUtil;
import com.example.provider1.RetrievabilityModification;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.somda.sdc.biceps.common.preprocessing.DescriptorChildRemover;
import org.somda.sdc.biceps.common.storage.DescriptionPreprocessingSegment;
import org.somda.sdc.biceps.guice.DefaultBicepsConfigModule;
import org.somda.sdc.biceps.guice.DefaultBicepsModule;
import org.somda.sdc.biceps.model.participant.AbstractMetricValue;
import org.somda.sdc.biceps.model.participant.GenerationMode;
import org.somda.sdc.biceps.model.participant.MeasurementValidity;
import org.somda.sdc.biceps.provider.preprocessing.ContextHandleDuplicateChecker;
import org.somda.sdc.biceps.provider.preprocessing.DuplicateChecker;
import org.somda.sdc.biceps.provider.preprocessing.DuplicateDescriptorChecker;
import org.somda.sdc.biceps.provider.preprocessing.EmptyWriteChecker;
import org.somda.sdc.biceps.provider.preprocessing.HandleReferenceChecker;
import org.somda.sdc.biceps.provider.preprocessing.TypeChangeChecker;
import org.somda.sdc.biceps.provider.preprocessing.TypeConsistencyChecker;
import org.somda.sdc.biceps.provider.preprocessing.VersionHandler;
import org.somda.sdc.common.guice.DefaultCommonConfigModule;
import org.somda.sdc.common.guice.DefaultCommonModule;
import org.somda.sdc.dpws.crypto.CryptoSettings;
import org.somda.sdc.dpws.guice.DefaultDpwsModule;
import org.somda.sdc.glue.guice.DefaultGlueConfigModule;
import org.somda.sdc.glue.guice.DefaultGlueModule;
import org.somda.sdc.glue.guice.GlueDpwsConfigModule;

public class ProviderUtil
extends BaseUtil {
    public static final String OPT_REPORT_INTERVAL = "report_interval";
    public static final String OPT_WAVEFORMS_INTERVAL = "waveform_interval";
    private static final Logger LOG = LogManager.getLogger(ProviderUtil.class);
    private static final String DEFAULT_REPORT_INTERVAL = "5000";
    private static final String DEFAULT_WAVEFORM_INTERVAL = "100";
    private final Injector injector;
    private final Duration reportInterval;
    private final Duration waveformInterval;

    public ProviderUtil(String[] args) {
        super(args);
        Configurator.reconfigure((Configuration)ProviderUtil.localLoggerConfig(Level.INFO));
        this.reportInterval = Duration.ofMillis(Long.parseLong(this.getParsedArgs().getOptionValue(OPT_REPORT_INTERVAL, DEFAULT_REPORT_INTERVAL)));
        this.waveformInterval = Duration.ofMillis(Long.parseLong(this.getParsedArgs().getOptionValue(OPT_WAVEFORMS_INTERVAL, DEFAULT_WAVEFORM_INTERVAL)));
        this.injector = Guice.createInjector((Module[])new Module[]{new DefaultCommonConfigModule(), new DefaultGlueModule(), new DefaultGlueConfigModule(), new DefaultBicepsModule(), new DefaultBicepsConfigModule(){

            protected void customConfigure() {
                this.bind("Biceps.Common.ProviderDescriptionPreprocessingSegments", (TypeLiteral)new TypeLiteral<List<Class<? extends DescriptionPreprocessingSegment>>>(){}, List.of(DuplicateChecker.class, TypeConsistencyChecker.class, VersionHandler.class, HandleReferenceChecker.class, DescriptorChildRemover.class, EmptyWriteChecker.class, DuplicateDescriptorChecker.class, TypeChangeChecker.class, RetrievabilityModification.class, ContextHandleDuplicateChecker.class));
            }
        }, new DefaultCommonModule(), new DefaultDpwsModule(), new GlueDpwsConfigModule(){

            protected void customConfigure() {
                super.customConfigure();
                this.bind("Dpws.Crypto.Settings", CryptoSettings.class, ProviderUtil.this.createCustomCryptoSettings());
                this.bind("Dpws.EnableHttps", Boolean.class, ProviderUtil.this.isUseTls());
                this.bind("Dpws.EnableHttp", Boolean.class, !ProviderUtil.this.isUseTls());
                this.bind("Dpws.Crypto.DeviceHostnameVerifier", HostnameVerifier.class, (hostname, session) -> {
                    try {
                        Certificate[] peerCerts = session.getPeerCertificates();
                        X509Certificate x509 = (X509Certificate)peerCerts[0];
                        List<String> extendedKeyUsage = x509.getExtendedKeyUsage();
                        if (extendedKeyUsage == null || extendedKeyUsage.isEmpty()) {
                            LOG.warn("No EKU in peer certificate");
                            return true;
                        }
                        for (String key : extendedKeyUsage) {
                            try {
                                URI keyUri = URI.create(key);
                                if (!keyUri.equals(URI.create("1.2.840.10004.20701.1.2"))) continue;
                                LOG.debug("SDC Service Consumer PKP found");
                                return true;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                        }
                        return true;
                    }
                    catch (Exception e) {
                        LOG.error("Error while validating client certificate: {}", (Object)e.getMessage());
                        LOG.trace("Error while validating client certificate", (Throwable)e);
                        return false;
                    }
                });
            }
        }});
    }

    public Injector getInjector() {
        return this.injector;
    }

    public static void addMetricQualityDemo(AbstractMetricValue val) {
        if (val.getMetricQuality() == null) {
            AbstractMetricValue.MetricQuality qual = new AbstractMetricValue.MetricQuality();
            qual.setMode(GenerationMode.DEMO);
            qual.setValidity(MeasurementValidity.VLD);
            val.setMetricQuality(qual);
        }
    }

    @Override
    protected Options configureOptions() {
        Options options = super.configureOptions();
        Option reportIntervalOpt = Option.builder(null).desc("Interval in ms in which reports are being generated. Default: 5000").longOpt(OPT_REPORT_INTERVAL).hasArg().type(Long.class).build();
        options.addOption(reportIntervalOpt);
        Option waveformIntervalOpt = Option.builder(null).desc("Interval in ms in which waveforms are being generated. Default: 100").longOpt(OPT_WAVEFORMS_INTERVAL).hasArg().type(Long.class).build();
        options.addOption(waveformIntervalOpt);
        return options;
    }

    public Duration getReportInterval() {
        return this.reportInterval;
    }

    public Duration getWaveformInterval() {
        return this.waveformInterval;
    }
}

