/*
 * Decompiled with CFR 0.152.
 */
package com.example.provider1;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.MdibDescriptionModification;
import org.somda.sdc.biceps.common.storage.DescriptionPreprocessingSegment;
import org.somda.sdc.biceps.common.storage.MdibStorageRead;
import org.somda.sdc.biceps.model.extension.ExtensionType;
import org.somda.sdc.biceps.model.message.Retrievability;
import org.somda.sdc.biceps.model.message.RetrievabilityInfo;
import org.somda.sdc.biceps.model.message.RetrievabilityMethod;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.RealTimeSampleArrayMetricDescriptor;

public class RetrievabilityModification
implements DescriptionPreprocessingSegment {
    private static final Logger LOG = LogManager.getLogger(RetrievabilityModification.class);

    public <T extends AbstractDescriptor> void processDescriptor(T modificationDescriptor) {
        ExtensionType extension = modificationDescriptor.getExtension();
        if (extension == null) {
            extension = new ExtensionType();
            modificationDescriptor.setExtension(extension);
        }
        Retrievability retrievability = extension.getAny().stream().filter(it -> it instanceof Retrievability).map(it -> (Retrievability)it).findFirst().orElseGet(() -> {
            Retrievability it = new Retrievability();
            LOG.debug("Creating new retrievability for {}", (Object)modificationDescriptor.getHandle());
            modificationDescriptor.getExtension().getAny().add(it);
            return it;
        });
        RetrievabilityInfo infoGet = new RetrievabilityInfo();
        infoGet.setMethod(RetrievabilityMethod.GET);
        if (modificationDescriptor instanceof RealTimeSampleArrayMetricDescriptor) {
            RetrievabilityInfo infoStrm = new RetrievabilityInfo();
            infoStrm.setMethod(RetrievabilityMethod.STRM);
            retrievability.setBy(List.of(infoGet, infoStrm));
        } else if (modificationDescriptor instanceof AbstractDescriptor) {
            RetrievabilityInfo infoStrm = new RetrievabilityInfo();
            infoStrm.setMethod(RetrievabilityMethod.EP);
            retrievability.setBy(List.of(infoGet, infoStrm));
        }
        LOG.debug("Retrievability for {} set to {}", (Object)modificationDescriptor.getHandle(), (Object)retrievability);
    }

    public List<MdibDescriptionModification> process(List<MdibDescriptionModification> modifications, MdibStorageRead storage) {
        return modifications.stream().map(currentModification -> {
            if (currentModification instanceof MdibDescriptionModification.Delete) {
                return currentModification;
            }
            if (currentModification instanceof MdibDescriptionModification.Insert) {
                MdibDescriptionModification.Insert insert = (MdibDescriptionModification.Insert)currentModification;
                this.processDescriptor(insert.getPair().getDescriptor());
            } else if (currentModification instanceof MdibDescriptionModification.Update) {
                MdibDescriptionModification.Update update = (MdibDescriptionModification.Update)currentModification;
                this.processDescriptor(update.getPair().getDescriptor());
            }
            return currentModification;
        }).collect(Collectors.toList());
    }
}

