/*
 * Decompiled with CFR 0.152.
 */
package com.example.provider2_extension;

import com.example.provider2_extension.ProviderUtil;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Injector;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.MdibStateModifications;
import org.somda.sdc.biceps.common.storage.PreprocessingException;
import org.somda.sdc.biceps.model.extension.ExtensionType;
import org.somda.sdc.biceps.model.participant.AbstractMetricValue;
import org.somda.sdc.biceps.model.participant.GenerationMode;
import org.somda.sdc.biceps.model.participant.Mdib;
import org.somda.sdc.biceps.model.participant.MeasurementValidity;
import org.somda.sdc.biceps.model.participant.NumericMetricState;
import org.somda.sdc.biceps.model.participant.NumericMetricValue;
import org.somda.sdc.biceps.provider.access.LocalMdibAccess;
import org.somda.sdc.biceps.provider.access.factory.LocalMdibAccessFactory;
import org.somda.sdc.dpws.DpwsFramework;
import org.somda.sdc.dpws.DpwsUtil;
import org.somda.sdc.dpws.device.DeviceSettings;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.glue.common.MdibXmlIo;
import org.somda.sdc.glue.common.factory.ModificationsBuilderFactory;
import org.somda.sdc.glue.examples.extension.CompiledExtension;
import org.somda.sdc.glue.provider.SdcDevice;
import org.somda.sdc.glue.provider.SdcDevicePlugin;
import org.somda.sdc.glue.provider.factory.SdcDeviceFactory;
import org.somda.sdc.glue.provider.plugin.SdcRequiredTypesAndScopes;

public class Provider
extends AbstractIdleService {
    private static final Logger LOG = LogManager.getLogger(Provider.class);
    private static final String NUMERIC_METRIC_HANDLE = "numeric.ch0.vmd0";
    private static final String MY_EXTENSION_NAMESPACE = "http://biceps.extension";
    private static final String MY_EXTENSION_STATE_NAME = "MyStateExtension";
    private final DpwsFramework dpwsFramework;
    private final LocalMdibAccess mdibAccess;
    private final SdcDevice sdcDevice;
    private final MdibXmlIo mdibXmlIo;
    private final ModificationsBuilderFactory modificationsBuilderFactory;

    Provider(ProviderUtil providerUtil) throws SocketException, UnknownHostException {
        NetworkInterface networkInterface;
        final Injector injector = providerUtil.getInjector();
        this.mdibXmlIo = (MdibXmlIo)injector.getInstance(MdibXmlIo.class);
        this.modificationsBuilderFactory = (ModificationsBuilderFactory)injector.getInstance(ModificationsBuilderFactory.class);
        this.dpwsFramework = (DpwsFramework)injector.getInstance(DpwsFramework.class);
        this.mdibAccess = ((LocalMdibAccessFactory)injector.getInstance(LocalMdibAccessFactory.class)).createLocalMdibAccess();
        if (providerUtil.getIface() != null && !providerUtil.getIface().isEmpty()) {
            LOG.info("Starting with interface {}", (Object)providerUtil.getIface());
            networkInterface = NetworkInterface.getByName(providerUtil.getIface());
        } else if (providerUtil.getAddress() != null && !providerUtil.getAddress().isBlank()) {
            LOG.info("Starting with address {}", (Object)providerUtil.getAddress());
            networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(providerUtil.getAddress()));
        } else {
            networkInterface = NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
            LOG.info("Starting with fallback default adapter {}", (Object)networkInterface);
        }
        assert (networkInterface != null);
        this.dpwsFramework.setNetworkInterface(networkInterface);
        String epr = providerUtil.getEpr();
        if (epr == null) {
            epr = ((SoapUtil)injector.getInstance(SoapUtil.class)).createRandomUuidUri();
            LOG.info("No epr address provided, generated random epr {}", (Object)epr);
        }
        final String finalEpr = epr;
        this.sdcDevice = ((SdcDeviceFactory)injector.getInstance(SdcDeviceFactory.class)).createSdcDevice(new DeviceSettings(){

            public EndpointReferenceType getEndpointReference() {
                return ((WsAddressingUtil)injector.getInstance(WsAddressingUtil.class)).createEprWithAddress(finalEpr);
            }

            public NetworkInterface getNetworkInterface() {
                return networkInterface;
            }
        }, this.mdibAccess, null, Collections.singleton((SdcDevicePlugin)injector.getInstance(SdcRequiredTypesAndScopes.class)));
        DpwsUtil dpwsUtil = (DpwsUtil)injector.getInstance(DpwsUtil.class);
        this.sdcDevice.getHostingServiceAccess().setThisDevice(dpwsUtil.createDeviceBuilder().setFriendlyName(dpwsUtil.createLocalizedStrings().add("en", "Provider with extensions example").get()).get());
    }

    public static void main(String[] args) throws SocketException, UnknownHostException {
        ProviderUtil providerUtil = new ProviderUtil(args);
        Provider provider = new Provider(providerUtil);
        provider.startAsync().awaitRunning();
        long reportInterval = providerUtil.getReportInterval().toMillis();
        LOG.info("Sending metric state report with extension every {} ms", (Object)reportInterval);
        Thread thread = new Thread(() -> {
            try {
                while (true) {
                    Thread.sleep(reportInterval);
                    provider.changeNumericMetric();
                }
            }
            catch (InterruptedException | PreprocessingException e) {
                LOG.warn("Thread loop stopping", e);
                return;
            }
        });
        thread.setDaemon(true);
        thread.start();
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        thread.interrupt();
        provider.stopAsync().awaitTerminated();
    }

    void changeNumericMetric() throws PreprocessingException {
        Optional stateOpt = this.mdibAccess.getState(NUMERIC_METRIC_HANDLE, NumericMetricState.class);
        assert (stateOpt.isPresent());
        NumericMetricState state = (NumericMetricState)stateOpt.get();
        NumericMetricValue val = state.getMetricValue();
        if (val != null && val.getValue() != null) {
            val.setValue(val.getValue().add(BigDecimal.ONE));
        } else {
            val = new NumericMetricValue();
            val.setValue(BigDecimal.ONE);
        }
        val.setDeterminationTime(Instant.now());
        if (val.getMetricQuality() == null) {
            AbstractMetricValue.MetricQuality qual = new AbstractMetricValue.MetricQuality();
            qual.setMode(GenerationMode.DEMO);
            qual.setValidity(MeasurementValidity.VLD);
            val.setMetricQuality(qual);
        }
        state.setMetricValue(val);
        JAXBElement myExtension = new JAXBElement(new QName(MY_EXTENSION_NAMESPACE, MY_EXTENSION_STATE_NAME), String.class, (Object)"");
        if (state.getExtension() != null) {
            if (!state.getExtension().getAny().isEmpty()) {
                myExtension = (JAXBElement)state.getExtension().getAny().get(0);
            }
        } else {
            state.setExtension(new ExtensionType());
        }
        myExtension.setValue((Object)("Extension value " + val.getValue().toString()));
        state.getExtension().getAny().clear();
        state.getExtension().getAny().add(myExtension);
        CompiledExtension compiledExtension = new CompiledExtension();
        compiledExtension.setField1("Foo");
        compiledExtension.setField2(BigInteger.TEN);
        state.getExtension().getAny().add(compiledExtension);
        this.mdibAccess.writeStates((MdibStateModifications)new MdibStateModifications.Metric(List.of(state)));
        LOG.info("Changed numeric metric value to {}", (Object)val.getValue());
    }

    protected void startUp() throws Exception {
        InputStream mdibAsStream = com.example.provider1.Provider.class.getClassLoader().getResourceAsStream("provider2_extension/Mdib.xml");
        assert (mdibAsStream != null);
        Mdib mdib = this.mdibXmlIo.readMdib(mdibAsStream);
        MdibDescriptionModifications modifications = this.modificationsBuilderFactory.createModificationsBuilder(mdib, Boolean.valueOf(true)).get();
        this.mdibAccess.writeDescription(modifications);
        this.dpwsFramework.startAsync().awaitRunning();
        this.sdcDevice.startAsync().awaitRunning();
    }

    protected void shutDown() {
        this.sdcDevice.stopAsync().awaitTerminated();
        this.dpwsFramework.stopAsync().awaitTerminated();
    }
}

