/*
 * Decompiled with CFR 0.152.
 */
package com.example.provider3_localization;

import com.example.provider3_localization.ProviderUtil;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Injector;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.model.participant.Mdib;
import org.somda.sdc.biceps.provider.access.LocalMdibAccess;
import org.somda.sdc.biceps.provider.access.factory.LocalMdibAccessFactory;
import org.somda.sdc.dpws.DpwsFramework;
import org.somda.sdc.dpws.DpwsUtil;
import org.somda.sdc.dpws.device.DeviceSettings;
import org.somda.sdc.dpws.model.ThisDeviceType;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.glue.common.MdibXmlIo;
import org.somda.sdc.glue.common.factory.ModificationsBuilderFactory;
import org.somda.sdc.glue.provider.SdcDevice;
import org.somda.sdc.glue.provider.factory.SdcDeviceFactory;

public class Provider
extends AbstractIdleService {
    private static final Logger LOG = LogManager.getLogger(Provider.class);
    private final DpwsFramework dpwsFramework;
    private final LocalMdibAccess mdibAccess;
    private final SdcDevice sdcDevice;
    private final MdibXmlIo mdibXmlIo;
    private final ModificationsBuilderFactory modificationsBuilderFactory;

    Provider(ProviderUtil providerUtil) throws SocketException, UnknownHostException {
        NetworkInterface networkInterface;
        final Injector injector = providerUtil.getInjector();
        this.mdibXmlIo = (MdibXmlIo)injector.getInstance(MdibXmlIo.class);
        this.modificationsBuilderFactory = (ModificationsBuilderFactory)injector.getInstance(ModificationsBuilderFactory.class);
        this.dpwsFramework = (DpwsFramework)injector.getInstance(DpwsFramework.class);
        this.mdibAccess = ((LocalMdibAccessFactory)injector.getInstance(LocalMdibAccessFactory.class)).createLocalMdibAccess();
        if (providerUtil.getIface() != null && !providerUtil.getIface().isEmpty()) {
            LOG.info("Starting with interface {}", (Object)providerUtil.getIface());
            networkInterface = NetworkInterface.getByName(providerUtil.getIface());
        } else if (providerUtil.getAddress() != null && !providerUtil.getAddress().isBlank()) {
            LOG.info("Starting with address {}", (Object)providerUtil.getAddress());
            networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(providerUtil.getAddress()));
        } else {
            networkInterface = NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
            LOG.info("Starting with fallback default adapter {}", (Object)networkInterface);
        }
        assert (networkInterface != null);
        this.dpwsFramework.setNetworkInterface(networkInterface);
        String epr = providerUtil.getEpr();
        if (epr == null) {
            epr = ((SoapUtil)injector.getInstance(SoapUtil.class)).createRandomUuidUri();
            LOG.info("No epr address provided, generated random epr {}", (Object)epr);
        }
        final String finalEpr = epr;
        this.sdcDevice = ((SdcDeviceFactory)injector.getInstance(SdcDeviceFactory.class)).createSdcDevice(new DeviceSettings(){

            public EndpointReferenceType getEndpointReference() {
                return ((WsAddressingUtil)injector.getInstance(WsAddressingUtil.class)).createEprWithAddress(finalEpr);
            }

            public NetworkInterface getNetworkInterface() {
                return networkInterface;
            }
        }, this.mdibAccess, null, Collections.emptyList(), providerUtil.getLocalizationStorage(), Collections.emptyList());
        DpwsUtil dpwsUtil = (DpwsUtil)injector.getInstance(DpwsUtil.class);
        ThisDeviceType thisDeviceType = dpwsUtil.createDeviceBuilder().setFriendlyName(dpwsUtil.createLocalizedStrings("en", "Provider with localization service example").get()).get();
        this.sdcDevice.getDevice().getHostingServiceAccess().setThisDevice(thisDeviceType);
    }

    public static void main(String[] args) throws SocketException, UnknownHostException {
        Provider provider = new Provider(new ProviderUtil(args));
        provider.startAsync().awaitRunning();
    }

    protected void startUp() throws Exception {
        InputStream mdibAsStream = com.example.provider1.Provider.class.getClassLoader().getResourceAsStream("provider3_localization/mdib.xml");
        assert (mdibAsStream != null);
        Mdib mdib = this.mdibXmlIo.readMdib(mdibAsStream);
        MdibDescriptionModifications modifications = this.modificationsBuilderFactory.createModificationsBuilder(mdib, Boolean.valueOf(true)).get();
        this.mdibAccess.writeDescription(modifications);
        this.dpwsFramework.startAsync().awaitRunning();
        this.sdcDevice.startAsync().awaitRunning();
    }

    protected void shutDown() {
        this.sdcDevice.stopAsync().awaitTerminated();
        this.dpwsFramework.stopAsync().awaitTerminated();
    }
}

