/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.common;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.access.MdibAccess;
import org.somda.sdc.biceps.model.participant.AbstractComplexDeviceComponentDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractMetricDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractOperationDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.AlertConditionDescriptor;
import org.somda.sdc.biceps.model.participant.AlertSignalDescriptor;
import org.somda.sdc.biceps.model.participant.AlertSystemDescriptor;
import org.somda.sdc.biceps.model.participant.BatteryDescriptor;
import org.somda.sdc.biceps.model.participant.ChannelDescriptor;
import org.somda.sdc.biceps.model.participant.ClockDescriptor;
import org.somda.sdc.biceps.model.participant.EnsembleContextDescriptor;
import org.somda.sdc.biceps.model.participant.LocationContextDescriptor;
import org.somda.sdc.biceps.model.participant.MdDescription;
import org.somda.sdc.biceps.model.participant.MdState;
import org.somda.sdc.biceps.model.participant.Mdib;
import org.somda.sdc.biceps.model.participant.MdibVersion;
import org.somda.sdc.biceps.model.participant.MdsDescriptor;
import org.somda.sdc.biceps.model.participant.MeansContextDescriptor;
import org.somda.sdc.biceps.model.participant.ObjectFactory;
import org.somda.sdc.biceps.model.participant.OperatorContextDescriptor;
import org.somda.sdc.biceps.model.participant.PatientContextDescriptor;
import org.somda.sdc.biceps.model.participant.ScoDescriptor;
import org.somda.sdc.biceps.model.participant.SystemContextDescriptor;
import org.somda.sdc.biceps.model.participant.VmdDescriptor;
import org.somda.sdc.biceps.model.participant.WorkflowContextDescriptor;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.ObjectUtil;

public class MdibMapper {
    private static final Logger LOG = LogManager.getLogger(MdibMapper.class);
    private final MdibAccess mdibAccess;
    private final ObjectFactory participantModelFactory;
    private final ObjectUtil objectUtil;
    private final Logger instanceLogger;

    @AssistedInject
    MdibMapper(@Assisted MdibAccess mdibAccess, ObjectFactory participantModelFactory, ObjectUtil objectUtil, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.mdibAccess = mdibAccess;
        this.participantModelFactory = participantModelFactory;
        this.objectUtil = objectUtil;
    }

    public Mdib mapMdib() {
        Mdib mdib = this.participantModelFactory.createMdib();
        MdibVersion mdibVersion = this.mdibAccess.getMdibVersion();
        mdib.setSequenceId(mdibVersion.getSequenceId());
        mdib.setInstanceId(mdibVersion.getInstanceId());
        mdib.setMdibVersion(mdibVersion.getVersion());
        mdib.setMdDescription(this.mapMdDescription(Collections.emptyList()));
        mdib.setMdState(this.mapMdState(Collections.emptyList()));
        return mdib;
    }

    public MdState mapMdState(List<String> handleFilter) {
        MdState mdState = this.participantModelFactory.createMdState();
        mdState.setStateVersion(this.mdibAccess.getMdStateVersion());
        if (handleFilter.isEmpty()) {
            for (MdibEntity rootEntity : this.mdibAccess.getRootEntities()) {
                this.appendStates(mdState.getState(), rootEntity);
            }
        } else {
            HashSet<String> handleSet = new HashSet<String>(handleFilter);
            for (MdibEntity rootEntity : this.mdibAccess.getRootEntities()) {
                this.appendStatesIfMatch(mdState.getState(), rootEntity, handleSet);
            }
        }
        return mdState;
    }

    public MdDescription mapMdDescription(List<String> handleFilter) {
        List<MdibEntity> rootEntities;
        HashSet<String> handleFilterCopy = new HashSet<String>(handleFilter);
        MdDescription mdDescription = this.participantModelFactory.createMdDescription();
        mdDescription.setDescriptionVersion(this.mdibAccess.getMdDescriptionVersion());
        if (handleFilter.isEmpty()) {
            rootEntities = this.mdibAccess.getRootEntities();
        } else {
            List allRootEntities = this.mdibAccess.getRootEntities();
            rootEntities = allRootEntities.stream().filter(mdibEntity -> handleFilterCopy.stream().anyMatch(handle -> mdibEntity.getHandle().equals(handle))).collect(Collectors.toList());
            rootEntities.forEach(mdibEntity -> {
                handleFilterCopy.remove(mdibEntity.getHandle());
                allRootEntities.remove(mdibEntity);
            });
            block0: for (MdibEntity entity : allRootEntities) {
                for (String handle : handleFilterCopy) {
                    if (!this.findHandleInSubtree(handle, entity)) continue;
                    rootEntities.add(entity);
                    handleFilterCopy.remove(handle);
                    continue block0;
                }
            }
        }
        for (MdibEntity rootEntity : rootEntities) {
            this.mapMds(mdDescription, rootEntity);
        }
        return mdDescription;
    }

    private void appendStates(List<AbstractState> states, MdibEntity entity) {
        states.addAll(entity.getStates());
        for (String childHandle : entity.getChildren()) {
            this.mdibAccess.getEntity(childHandle).ifPresent(childEntity -> this.appendStates(states, (MdibEntity)childEntity));
        }
    }

    private void appendStatesIfMatch(List<AbstractState> states, MdibEntity entity, Set<String> filterSet) {
        if (filterSet.contains(entity.getHandle())) {
            filterSet.remove(entity.getHandle());
            states.addAll(entity.getStates());
            entity.doIfMultiState(multiStates -> multiStates.forEach(state -> filterSet.remove(state.getHandle())));
        }
        entity.doIfMultiState(multiStates -> multiStates.forEach(state -> {
            if (filterSet.contains(state.getHandle())) {
                states.add((AbstractState)state);
                filterSet.remove(state.getHandle());
            }
        }));
        for (String childHandle : entity.getChildren()) {
            this.mdibAccess.getEntity(childHandle).ifPresent(childEntity -> this.appendStatesIfMatch(states, (MdibEntity)childEntity, filterSet));
        }
    }

    private boolean findHandleInSubtree(String handle, MdibEntity mdibEntity) {
        for (String childHandle : mdibEntity.getChildren()) {
            Optional childEntity = this.mdibAccess.getEntity(childHandle);
            if (!childEntity.isPresent()) continue;
            if (((MdibEntity)childEntity.get()).getHandle().equals(handle)) {
                return true;
            }
            if (!this.findHandleInSubtree(handle, (MdibEntity)childEntity.get())) continue;
            return true;
        }
        return false;
    }

    private void mapMds(MdDescription mdDescription, MdibEntity mds) {
        Optional descriptor = mds.getDescriptor(MdsDescriptor.class);
        if (descriptor.isEmpty()) {
            return;
        }
        MdsDescriptor descriptorCopy = (MdsDescriptor)this.objectUtil.deepCopy((Object)((MdsDescriptor)descriptor.get()));
        this.mapZeroOrMoreDescriptors((AbstractDescriptor)descriptorCopy, this.mdibAccess.getChildrenByType(mds.getHandle(), BatteryDescriptor.class), "getBattery");
        this.mapZeroOrOneDescriptor((AbstractDescriptor)descriptorCopy, this.mdibAccess.getChildrenByType(mds.getHandle(), ClockDescriptor.class), "setClock");
        this.mapAlertSystem((AbstractComplexDeviceComponentDescriptor)descriptorCopy, this.mdibAccess.getChildrenByType(mds.getHandle(), AlertSystemDescriptor.class));
        this.mapSco((AbstractComplexDeviceComponentDescriptor)descriptorCopy, this.mdibAccess.getChildrenByType(mds.getHandle(), ScoDescriptor.class));
        this.mapSystemContext(descriptorCopy, this.mdibAccess.getChildrenByType(mds.getHandle(), SystemContextDescriptor.class));
        this.mapVmds(descriptorCopy, this.mdibAccess.getChildrenByType(mds.getHandle(), VmdDescriptor.class));
        mdDescription.getMds().add(descriptorCopy);
    }

    private void mapVmds(MdsDescriptor parent, List<MdibEntity> vmds) {
        for (MdibEntity vmd : vmds) {
            vmd.getDescriptor(VmdDescriptor.class).ifPresent(vmdDescriptor -> {
                VmdDescriptor vmdDescriptorCopy = (VmdDescriptor)this.objectUtil.deepCopy(vmdDescriptor);
                parent.getVmd().add(vmdDescriptorCopy);
                this.mapAlertSystem((AbstractComplexDeviceComponentDescriptor)vmdDescriptorCopy, this.mdibAccess.getChildrenByType(vmdDescriptorCopy.getHandle(), AlertSystemDescriptor.class));
                this.mapSco((AbstractComplexDeviceComponentDescriptor)vmdDescriptorCopy, this.mdibAccess.getChildrenByType(vmdDescriptorCopy.getHandle(), ScoDescriptor.class));
                this.mapChannels(vmdDescriptorCopy, this.mdibAccess.getChildrenByType(vmdDescriptorCopy.getHandle(), ChannelDescriptor.class));
            });
        }
    }

    private void mapChannels(VmdDescriptor parent, List<MdibEntity> channels) {
        for (MdibEntity channel : channels) {
            channel.getDescriptor(ChannelDescriptor.class).ifPresent(channelDescriptor -> {
                ChannelDescriptor channelDescriptorCopy = (ChannelDescriptor)this.objectUtil.deepCopy(channelDescriptor);
                parent.getChannel().add(channelDescriptorCopy);
                this.mapZeroOrMoreDescriptors((AbstractDescriptor)channelDescriptorCopy, this.mdibAccess.getChildrenByType(channelDescriptorCopy.getHandle(), AbstractMetricDescriptor.class), "getMetric");
            });
        }
    }

    private void mapSco(AbstractComplexDeviceComponentDescriptor parent, List<MdibEntity> scos) {
        block0: {
            Iterator<MdibEntity> iterator = scos.iterator();
            if (!iterator.hasNext()) break block0;
            MdibEntity sco = iterator.next();
            sco.getDescriptor(ScoDescriptor.class).ifPresent(scoDescriptor -> {
                ScoDescriptor scoDescriptorCopy = (ScoDescriptor)this.objectUtil.deepCopy(scoDescriptor);
                parent.setSco(scoDescriptorCopy);
                this.mapZeroOrMoreDescriptors((AbstractDescriptor)scoDescriptorCopy, this.mdibAccess.getChildrenByType(sco.getHandle(), AbstractOperationDescriptor.class), "getOperation");
            });
        }
    }

    private void mapSystemContext(MdsDescriptor parent, List<MdibEntity> systemContexts) {
        block0: {
            Iterator<MdibEntity> iterator = systemContexts.iterator();
            if (!iterator.hasNext()) break block0;
            MdibEntity systemContext = iterator.next();
            systemContext.getDescriptor(SystemContextDescriptor.class).ifPresent(systemContextDescriptor -> {
                SystemContextDescriptor systemContextDescriptorCopy = (SystemContextDescriptor)this.objectUtil.deepCopy(systemContextDescriptor);
                parent.setSystemContext(systemContextDescriptorCopy);
                String parentHandle = systemContextDescriptorCopy.getHandle();
                this.mapZeroOrOneDescriptor((AbstractDescriptor)systemContextDescriptorCopy, this.mdibAccess.getChildrenByType(parentHandle, PatientContextDescriptor.class), "setPatientContext");
                this.mapZeroOrOneDescriptor((AbstractDescriptor)systemContextDescriptorCopy, this.mdibAccess.getChildrenByType(parentHandle, LocationContextDescriptor.class), "setLocationContext");
                this.mapZeroOrMoreDescriptors((AbstractDescriptor)systemContextDescriptorCopy, this.mdibAccess.getChildrenByType(parentHandle, EnsembleContextDescriptor.class), "getEnsembleContext");
                this.mapZeroOrMoreDescriptors((AbstractDescriptor)systemContextDescriptorCopy, this.mdibAccess.getChildrenByType(parentHandle, WorkflowContextDescriptor.class), "getWorkflowContext");
                this.mapZeroOrMoreDescriptors((AbstractDescriptor)systemContextDescriptorCopy, this.mdibAccess.getChildrenByType(parentHandle, OperatorContextDescriptor.class), "getOperatorContext");
                this.mapZeroOrMoreDescriptors((AbstractDescriptor)systemContextDescriptorCopy, this.mdibAccess.getChildrenByType(parentHandle, MeansContextDescriptor.class), "getMeansContext");
            });
        }
    }

    private void mapAlertSystem(AbstractComplexDeviceComponentDescriptor parent, List<MdibEntity> alertSystems) {
        if (alertSystems.isEmpty()) {
            return;
        }
        Optional descriptor = alertSystems.get(0).getDescriptor(AlertSystemDescriptor.class);
        if (descriptor.isEmpty()) {
            return;
        }
        AlertSystemDescriptor descriptorCopy = (AlertSystemDescriptor)this.objectUtil.deepCopy((Object)((AlertSystemDescriptor)descriptor.get()));
        parent.setAlertSystem(descriptorCopy);
        this.mapZeroOrMoreDescriptors((AbstractDescriptor)descriptorCopy, this.mdibAccess.getChildrenByType(descriptorCopy.getHandle(), AlertConditionDescriptor.class), "getAlertCondition");
        this.mapZeroOrMoreDescriptors((AbstractDescriptor)descriptorCopy, this.mdibAccess.getChildrenByType(descriptorCopy.getHandle(), AlertSignalDescriptor.class), "getAlertSignal");
    }

    private void mapZeroOrMoreDescriptors(AbstractDescriptor parentDescriptor, List<MdibEntity> entities, String getterFunctionName) {
        for (MdibEntity entity : entities) {
            try {
                AbstractDescriptor childDescriptor = (AbstractDescriptor)this.objectUtil.deepCopy((Object)entity.getDescriptor());
                Method getList = parentDescriptor.getClass().getMethod(getterFunctionName, new Class[0]);
                List listObject = (List)List.class.cast(getList.invoke((Object)parentDescriptor, new Object[0]));
                listObject.add(childDescriptor);
            }
            catch (ClassCastException e) {
                this.instanceLogger.warn("Mapping of zero-or-many failed for descriptor {}, because function does not return a list object", (Object)entity.getDescriptor().getHandle());
            }
            catch (NoSuchMethodException e) {
                this.instanceLogger.warn("Mapping of zero-or-many failed for descriptor {}, because method {} does not exist", (Object)entity.getDescriptor().getHandle(), (Object)getterFunctionName);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.instanceLogger.warn("Mapping of zero-or-many failed for descriptor {}, because method {} could not be invoked on object of type {}", (Object)entity.getDescriptor().getHandle(), (Object)getterFunctionName, entity.getDescriptor().getClass());
            }
        }
    }

    private void mapZeroOrOneDescriptor(AbstractDescriptor parentDescriptor, List<MdibEntity> entities, String setterFunctionName) {
        for (MdibEntity entity : entities) {
            try {
                AbstractDescriptor childDescriptor = (AbstractDescriptor)this.objectUtil.deepCopy((Object)entity.getDescriptor());
                Method setObject = parentDescriptor.getClass().getMethod(setterFunctionName, childDescriptor.getClass());
                setObject.invoke((Object)parentDescriptor, childDescriptor);
                break;
            }
            catch (NoSuchMethodException e) {
                this.instanceLogger.warn("Mapping of zero-or-one failed for descriptor {}, because method {} does not exist", (Object)entity.getDescriptor().getHandle(), (Object)setterFunctionName);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.instanceLogger.warn("Mapping of zero-or-one failed for descriptor {}, because method {} could not be invoked on object of type {}", (Object)entity.getDescriptor().getHandle(), (Object)setterFunctionName, entity.getDescriptor().getClass());
            }
        }
    }
}

