/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.common;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import javax.annotation.Nullable;
import org.somda.sdc.biceps.model.message.AbstractGetResponse;
import org.somda.sdc.biceps.model.message.AbstractReport;
import org.somda.sdc.biceps.model.participant.MdibVersion;

public class MdibVersionUtil {
    @Inject
    MdibVersionUtil() {
    }

    public <T> void setMdibVersion(MdibVersion mdibVersion, T target) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method setSequenceId = target.getClass().getMethod("setSequenceId", String.class);
        Method setInstanceId = target.getClass().getMethod("setInstanceId", BigInteger.class);
        Method setMdibVersion = target.getClass().getMethod("setMdibVersion", BigInteger.class);
        setSequenceId.invoke(target, mdibVersion.getSequenceId());
        setInstanceId.invoke(target, mdibVersion.getInstanceId());
        setMdibVersion.invoke(target, mdibVersion.getVersion());
    }

    public MdibVersion getMdibVersion(AbstractReport msg) {
        return new MdibVersion(msg.getSequenceId(), this.defaultZero(msg.getMdibVersion()), this.defaultZero(msg.getInstanceId()));
    }

    public MdibVersion getMdibVersion(AbstractGetResponse msg) {
        return new MdibVersion(msg.getSequenceId(), this.defaultZero(msg.getMdibVersion()), this.defaultZero(msg.getInstanceId()));
    }

    private BigInteger defaultZero(@Nullable BigInteger instanceId) {
        return instanceId == null ? BigInteger.ZERO : instanceId;
    }
}

