/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.common.uri;

import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jregex.Matcher;
import jregex.Pattern;
import org.somda.sdc.biceps.model.participant.InstanceIdentifier;
import org.somda.sdc.biceps.model.participant.LocationDetail;
import org.somda.sdc.glue.GlueConstants;
import org.somda.sdc.glue.common.helper.UrlUtf8;
import org.somda.sdc.glue.common.uri.ContextIdentificationMapper;
import org.somda.sdc.glue.common.uri.UriMapperGenerationArgumentException;
import org.somda.sdc.glue.common.uri.UriMapperParsingException;

public class LocationDetailQueryMapper {
    private static final Pattern PATTERN = new Pattern(GlueConstants.URI_REGEX);
    private static final Pattern QUERY_VALIDATOR = new Pattern("^(((fac=(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$'()*+,;=:@])+))|(bldng=(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$'()*+,;=:@])+))|(poc=(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$'()*+,;=:@])+))|(flr=(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$'()*+,;=:@])+))|(rm=(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$'()*+,;=:@])+))|(bed=(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$'()*+,;=:@])+)))(&((fac=(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$'()*+,;=:@])+))|(bldng=(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$'()*+,;=:@])+))|(poc=(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$'()*+,;=:@])+))|(flr=(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$'()*+,;=:@])+))|(rm=(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$'()*+,;=:@])+))|(bed=(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$'()*+,;=:@])+))))*)?$");

    public static String createWithLocationDetailQuery(InstanceIdentifier instanceIdentifier, LocationDetail locationDetail) throws UriMapperGenerationArgumentException {
        String uri = ContextIdentificationMapper.fromInstanceIdentifier(instanceIdentifier, ContextIdentificationMapper.ContextSource.Location);
        StringBuilder queryParams = new StringBuilder("?");
        int count = 0;
        for (LocationDetailFields field : LocationDetailFields.values()) {
            try {
                Method getter = field.getGetter();
                String key = field.getQueryKey();
                String value = (String)getter.invoke((Object)locationDetail, new Object[0]);
                if (Strings.isNullOrEmpty((String)value)) continue;
                if (count++ > 0) {
                    queryParams.append('&');
                }
                queryParams.append(key).append('=').append(UrlUtf8.encode(value));
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new UriMapperGenerationArgumentException("Unexpected reflection exception occurred during location detail appending of field " + field.toString());
            }
        }
        String queryParamsString = queryParams.toString();
        String resultingUri = uri + ("?".equals(queryParamsString) ? "" : queryParamsString);
        try {
            LocationDetailQueryMapper.readLocationDetailQuery(resultingUri);
        }
        catch (UriMapperParsingException e) {
            throw new UriMapperGenerationArgumentException("No valid URI could be generated from the given LocationDetail: '" + locationDetail.toString() + "' and InstanceIdentifier: '" + instanceIdentifier.toString() + "'");
        }
        return resultingUri;
    }

    public static LocationDetail readLocationDetailQuery(String uri) throws UriMapperParsingException {
        Matcher uriMatcher = PATTERN.matcher(uri);
        if (uriMatcher.matches()) {
            String queryString = uriMatcher.group("query");
            if (queryString == null) {
                return new LocationDetail();
            }
            Matcher queryMatcher = QUERY_VALIDATOR.matcher(queryString);
            if (queryMatcher.matches()) {
                LocationDetail locationDetail = new LocationDetail();
                Map<String, List<String>> queryItems = LocationDetailQueryMapper.splitQuery(queryString);
                for (LocationDetailFields field : LocationDetailFields.values()) {
                    List<String> values = queryItems.get(field.getQueryKey());
                    if (values == null || values.isEmpty()) continue;
                    try {
                        Method setter = field.getSetter();
                        setter.invoke((Object)locationDetail, UrlUtf8.decode(values.get(0)));
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new UriMapperParsingException("Unexpected reflection exception occurred during location detail reading of field for the mapper " + LocationDetailQueryMapper.class.toString() + " " + e.toString());
                    }
                }
                return locationDetail;
            }
            throw new UriMapperParsingException("Invalid Query in the URI for the mapper " + LocationDetailQueryMapper.class.toString());
        }
        throw new UriMapperParsingException("Invalid URI for the mapper " + LocationDetailQueryMapper.class.toString());
    }

    private static Map<String, List<String>> splitQuery(String query) throws UriMapperParsingException {
        String[] keyValuePair;
        LinkedHashMap<String, List<String>> queryPairs = new LinkedHashMap<String, List<String>>();
        for (String pair : keyValuePair = query.split("&")) {
            String key;
            int equalCharIndex = pair.indexOf("=");
            String string = key = equalCharIndex > 0 ? UrlUtf8.decode(pair.substring(0, equalCharIndex)) : pair;
            if (queryPairs.containsKey(key)) {
                throw new UriMapperParsingException("More than one query segment with the key '" + key + "'");
            }
            queryPairs.put(key, new LinkedList());
            if (equalCharIndex <= 0 || pair.length() <= equalCharIndex + 1) continue;
            ((List)queryPairs.get(key)).add(UrlUtf8.decode(pair.substring(equalCharIndex + 1)));
        }
        return queryPairs;
    }

    private static enum LocationDetailFields {
        FACILITY("fac", "Facility"),
        BUILDING("bldng", "Building"),
        POINT_OF_CARE("poc", "PoC"),
        FLOOR("flr", "Floor"),
        ROOM("rm", "Room"),
        BED("bed", "Bed");

        private final String queryKey;
        private final String name;

        private LocationDetailFields(String queryKey, String name) {
            this.queryKey = queryKey;
            this.name = name;
        }

        String getQueryKey() {
            return this.queryKey;
        }

        Method getSetter() throws NoSuchMethodException {
            return LocationDetail.class.getDeclaredMethod("set" + this.name, String.class);
        }

        Method getGetter() throws NoSuchMethodException {
            return LocationDetail.class.getDeclaredMethod("get" + this.name, new Class[0]);
        }
    }
}

