/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.access.MdibAccessObservable;
import org.somda.sdc.biceps.consumer.access.RemoteMdibAccess;
import org.somda.sdc.biceps.model.message.AbstractSet;
import org.somda.sdc.biceps.model.message.AbstractSetResponse;
import org.somda.sdc.biceps.model.message.OperationInvokedReport;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.glue.consumer.SdcRemoteDevice;
import org.somda.sdc.glue.consumer.SdcRemoteDeviceWatchdog;
import org.somda.sdc.glue.consumer.SetServiceAccess;
import org.somda.sdc.glue.consumer.WatchdogObserver;
import org.somda.sdc.glue.consumer.helper.HostingServiceLogger;
import org.somda.sdc.glue.consumer.report.ReportProcessor;
import org.somda.sdc.glue.consumer.sco.ScoController;
import org.somda.sdc.glue.consumer.sco.ScoTransaction;

public class SdcRemoteDeviceImpl
extends AbstractIdleService
implements SdcRemoteDevice {
    private static final Logger LOG = LogManager.getLogger(SdcRemoteDeviceImpl.class);
    private final RemoteMdibAccess remoteMdibAccess;
    private final ReportProcessor reportProcessor;
    private final ScoController scoController;
    private final HostingServiceProxy hostingServiceProxy;
    private final SdcRemoteDeviceWatchdog watchdog;
    private final Duration maxWait;
    private final Logger instanceLogger;

    @AssistedInject
    SdcRemoteDeviceImpl(@Assisted HostingServiceProxy hostingServiceProxy, @Assisted RemoteMdibAccess remoteMdibAccess, @Assisted ReportProcessor reportProcessor, @Assisted @Nullable ScoController scoController, @Assisted SdcRemoteDeviceWatchdog watchdog, @Named(value="Dpws.MaxWaitForFutures") Duration maxWait, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = HostingServiceLogger.getLogger(LOG, hostingServiceProxy, frameworkIdentifier);
        this.remoteMdibAccess = remoteMdibAccess;
        this.reportProcessor = reportProcessor;
        this.scoController = scoController;
        this.hostingServiceProxy = hostingServiceProxy;
        this.watchdog = watchdog;
        this.maxWait = maxWait;
    }

    @Override
    public HostingServiceProxy getHostingServiceProxy() {
        this.checkRunning();
        return this.hostingServiceProxy;
    }

    public RemoteMdibAccess getMdibAccess() {
        this.checkRunning();
        return this.remoteMdibAccess;
    }

    @Override
    public MdibAccessObservable getMdibAccessObservable() {
        return this.remoteMdibAccess;
    }

    @Override
    public SetServiceAccess getSetServiceAccess() {
        this.checkRunning();
        if (this.scoController == null) {
            String message = "Remote device does not provide a set service. {} refused.";
            return new SetServiceAccess(){

                @Override
                public <T extends AbstractSet, V extends AbstractSetResponse> ListenableFuture<ScoTransaction<V>> invoke(T setRequest, Class<V> responseClass) {
                    SdcRemoteDeviceImpl.this.instanceLogger.warn("Remote device does not provide a set service. {} refused.", (Object)setRequest.getClass().getSimpleName());
                    return Futures.immediateCancelledFuture();
                }

                @Override
                public <T extends AbstractSet, V extends AbstractSetResponse> ListenableFuture<ScoTransaction<V>> invoke(T setRequest, @Nullable Consumer<OperationInvokedReport.ReportPart> reportListener, Class<V> responseClass) {
                    SdcRemoteDeviceImpl.this.instanceLogger.warn("Remote device does not provide a set service. {} refused.", (Object)setRequest.getClass().getSimpleName());
                    return Futures.immediateCancelledFuture();
                }
            };
        }
        return this.scoController;
    }

    @Override
    public void registerWatchdogObserver(WatchdogObserver watchdogObserver) {
        this.checkRunning();
        this.watchdog.registerObserver(watchdogObserver);
    }

    @Override
    public void unregisterWatchdogObserver(WatchdogObserver watchdogObserver) {
        this.checkRunning();
        this.watchdog.unregisterObserver(watchdogObserver);
    }

    protected void startUp() throws TimeoutException {
        if (this.watchdog != null) {
            this.watchdog.startAsync().awaitRunning(this.maxWait.getSeconds(), TimeUnit.SECONDS);
        }
    }

    protected void shutDown() {
        if (this.watchdog != null) {
            try {
                this.watchdog.stopAsync().awaitTerminated(this.maxWait.getSeconds(), TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                this.instanceLogger.error("Could not stop the remote device watchdog", (Throwable)e);
            }
        }
        try {
            this.reportProcessor.stopAsync().awaitTerminated(this.maxWait.getSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.instanceLogger.error("Could not stop the report processor", (Throwable)e);
        }
        ArrayList hostedServices = new ArrayList(this.hostingServiceProxy.getHostedServices().values());
        for (HostedServiceProxy hostedService : hostedServices) {
            hostedService.getEventSinkAccess().unsubscribeAll();
        }
        this.remoteMdibAccess.unregisterAllObservers();
    }

    private void checkRunning() {
        if (!this.isRunning()) {
            throw new RuntimeException(String.format("Tried to access a disconnected SDC remote device instance with EPR address %s", this.hostingServiceProxy.getEndpointReferenceAddress()));
        }
    }
}

