/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer.helper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.service.HostingServiceProxy;

public class HostingServiceLogger {
    public static final String HOSTING_SERVICE_INFO = "hostingServiceInfo";

    public static Logger getLogger(Logger logger, HostingServiceProxy hostingService, String frameworkIdentifier) {
        return (Logger)Proxy.newProxyInstance(InstanceLogger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)new HostingServiceLoggerLoggerInvocationHandler(logger, HostingServiceLogger.generatePrefix(hostingService), frameworkIdentifier));
    }

    private static String generatePrefix(HostingServiceProxy hostingServiceProxy) {
        return hostingServiceProxy.getEndpointReferenceAddress() + "," + hostingServiceProxy.getActiveXAddr();
    }

    private static class HostingServiceLoggerLoggerInvocationHandler
    implements InvocationHandler {
        private final String instanceId;
        private final Logger logger;
        private final String hostingServiceInfo;

        HostingServiceLoggerLoggerInvocationHandler(Logger logger, String hostingServiceInfo, String instanceId) {
            this.instanceId = instanceId;
            this.hostingServiceInfo = hostingServiceInfo;
            this.logger = logger;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"instanceId", (String)this.instanceId).put(HostingServiceLogger.HOSTING_SERVICE_INFO, this.hostingServiceInfo);){
                Object object = method.invoke((Object)this.logger, args);
                return object;
            }
        }
    }
}

