/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer.sco;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Optional;
import org.somda.sdc.biceps.model.message.OperationInvokedReport;

public class ScoUtil {
    @Inject
    ScoUtil() {
    }

    public boolean hasFinalReport(Collection<OperationInvokedReport.ReportPart> reportParts) {
        return this.getFinalReport(reportParts).isPresent();
    }

    public Optional<OperationInvokedReport.ReportPart> getFinalReport(Collection<OperationInvokedReport.ReportPart> reportParts) {
        for (OperationInvokedReport.ReportPart reportPart : reportParts) {
            if (!this.isFinalReport(reportPart)) continue;
            return Optional.of(reportPart);
        }
        return Optional.empty();
    }

    public boolean isFinalReport(OperationInvokedReport.ReportPart reportPart) {
        switch (reportPart.getInvocationInfo().getInvocationState()) {
            case CNCLLD: 
            case CNCLLD_MAN: 
            case FIN: 
            case FIN_MOD: 
            case FAIL: {
                return true;
            }
        }
        return false;
    }
}

