/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.common;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.somda.sdc.biceps.model.message.AbstractAlertReport;
import org.somda.sdc.biceps.model.message.AbstractComponentReport;
import org.somda.sdc.biceps.model.message.AbstractContextReport;
import org.somda.sdc.biceps.model.message.AbstractMetricReport;
import org.somda.sdc.biceps.model.message.AbstractOperationalStateReport;
import org.somda.sdc.biceps.model.message.AbstractReport;
import org.somda.sdc.biceps.model.message.EpisodicAlertReport;
import org.somda.sdc.biceps.model.message.EpisodicComponentReport;
import org.somda.sdc.biceps.model.message.EpisodicContextReport;
import org.somda.sdc.biceps.model.message.EpisodicMetricReport;
import org.somda.sdc.biceps.model.message.EpisodicOperationalStateReport;
import org.somda.sdc.biceps.model.message.PeriodicAlertReport;
import org.somda.sdc.biceps.model.message.PeriodicComponentReport;
import org.somda.sdc.biceps.model.message.PeriodicContextReport;
import org.somda.sdc.biceps.model.message.PeriodicMetricReport;
import org.somda.sdc.biceps.model.message.PeriodicOperationalStateReport;
import org.somda.sdc.biceps.model.participant.AbstractAlertState;
import org.somda.sdc.biceps.model.participant.AbstractContextState;
import org.somda.sdc.biceps.model.participant.AbstractDeviceComponentState;
import org.somda.sdc.biceps.model.participant.AbstractMetricState;
import org.somda.sdc.biceps.model.participant.AbstractOperationState;
import org.somda.sdc.biceps.model.participant.AbstractState;

public class ReportMappings {
    private final Map<Class<? extends AbstractReport>, Class<? extends AbstractState>> reportStateMapping = Map.of(AbstractAlertReport.class, AbstractAlertState.class, AbstractComponentReport.class, AbstractDeviceComponentState.class, AbstractContextReport.class, AbstractContextState.class, AbstractMetricReport.class, AbstractMetricState.class, AbstractOperationalStateReport.class, AbstractOperationState.class);
    private final Map<Class<? extends AbstractState>, Class<? extends AbstractReport>> episodicStateReportMapping;
    private final Map<Class<? extends AbstractState>, Class<? extends AbstractReport>> periodicStateReportMapping;
    private final Map<Class<? extends AbstractReport>, String> episodicReportActionMapping;
    private final Map<Class<? extends AbstractReport>, String> periodicReportActionMapping;
    private final Set<Class<? extends AbstractReport>> reportMessageTypes = Collections.unmodifiableSet(this.reportStateMapping.keySet());
    private final Set<Class<? extends AbstractState>> reportStateTypes;

    @Inject
    ReportMappings() {
        this.episodicStateReportMapping = Map.of(AbstractAlertState.class, EpisodicAlertReport.class, AbstractDeviceComponentState.class, EpisodicComponentReport.class, AbstractContextState.class, EpisodicContextReport.class, AbstractMetricState.class, EpisodicMetricReport.class, AbstractOperationState.class, EpisodicOperationalStateReport.class);
        this.periodicStateReportMapping = Map.of(AbstractAlertState.class, PeriodicAlertReport.class, AbstractDeviceComponentState.class, PeriodicComponentReport.class, AbstractContextState.class, PeriodicContextReport.class, AbstractMetricState.class, PeriodicMetricReport.class, AbstractOperationState.class, PeriodicOperationalStateReport.class);
        this.reportStateTypes = Set.of(AbstractAlertState.class, AbstractDeviceComponentState.class, AbstractContextState.class, AbstractMetricState.class, AbstractOperationState.class);
        this.episodicReportActionMapping = Map.of(EpisodicAlertReport.class, "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/EpisodicAlertReport", EpisodicComponentReport.class, "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/EpisodicComponentReport", EpisodicContextReport.class, "http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/EpisodicContextReport", EpisodicMetricReport.class, "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/EpisodicMetricReport", EpisodicOperationalStateReport.class, "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/EpisodicOperationalStateReport");
        this.periodicReportActionMapping = Map.of(PeriodicAlertReport.class, "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicAlertReport", PeriodicComponentReport.class, "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicComponentReport", PeriodicContextReport.class, "http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/PeriodicContextReport", PeriodicMetricReport.class, "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicMetricReport", PeriodicOperationalStateReport.class, "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicOperationalStateReport");
    }

    public Class<? extends AbstractReport> getEpisodicReportClass(Class<? extends AbstractState> stateClass) {
        return ReportMappings.getReportClass(stateClass, this.episodicStateReportMapping);
    }

    public Class<? extends AbstractReport> getPeriodicReportClass(Class<? extends AbstractState> stateClass) {
        return ReportMappings.getReportClass(stateClass, this.periodicStateReportMapping);
    }

    private static Class<? extends AbstractReport> getReportClass(Class<? extends AbstractState> stateClass, Map<Class<? extends AbstractState>, Class<? extends AbstractReport>> mapping) {
        for (Class<? extends AbstractState> superClass = stateClass; superClass != null; superClass = superClass.getSuperclass()) {
            Class<? extends AbstractReport> reportClass = mapping.get(superClass);
            if (reportClass == null) continue;
            return reportClass;
        }
        throw new RuntimeException(String.format("Unknown state class found: %s", stateClass));
    }

    public String getEpisodicAction(Class<? extends AbstractReport> reportClass) {
        return this.getAction(reportClass, this.episodicReportActionMapping).orElseThrow(() -> new UnknownReportClassFoundException(reportClass));
    }

    public String getPeriodicAction(Class<? extends AbstractReport> reportClass) {
        return this.getAction(reportClass, this.periodicReportActionMapping).orElseThrow(() -> new UnknownReportClassFoundException(reportClass));
    }

    public String getAction(Class<? extends AbstractReport> reportClass) {
        return this.getAction(reportClass, this.episodicReportActionMapping).orElseGet(() -> this.getAction(reportClass, this.periodicReportActionMapping).orElseThrow(() -> new UnknownReportClassFoundException(reportClass)));
    }

    private Optional<String> getAction(Class<? extends AbstractReport> reportClass, Map<Class<? extends AbstractReport>, String> mapping) {
        return Optional.ofNullable(mapping.get(reportClass));
    }

    public static class UnknownReportClassFoundException
    extends RuntimeException {
        public UnknownReportClassFoundException(Class<? extends AbstractReport> reportClass) {
            super(String.format("Unknown report class found: %s", reportClass));
        }
    }
}

