/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.DpwsFramework;
import org.somda.sdc.dpws.client.Client;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.wseventing.SubscribeResult;
import org.somda.sdc.glue.consumer.WatchdogObserver;
import org.somda.sdc.glue.consumer.event.WatchdogMessage;
import org.somda.sdc.glue.consumer.helper.HostingServiceLogger;
import org.somda.sdc.glue.guice.WatchdogScheduledExecutor;

public class SdcRemoteDeviceWatchdog
extends AbstractIdleService {
    private static final Logger LOG = LogManager.getLogger(SdcRemoteDeviceWatchdog.class);
    private final HostingServiceProxy hostingServiceProxy;
    private final Map<String, SubscribeResult> subscriptions;
    private final ExecutorWrapperService<ScheduledExecutorService> watchdogExecutor;
    private final Duration watchdogPeriod;
    private final Duration requestedExpires;
    private final EventBus eventBus;
    private final Client client;
    private final Logger instanceLogger;
    private Future<?> currentJob = null;

    @AssistedInject
    SdcRemoteDeviceWatchdog(@Assisted HostingServiceProxy hostingServiceProxy, @Assisted Map<String, SubscribeResult> subscriptions, @Assisted @Nullable WatchdogObserver initialWatchdogObserver, @WatchdogScheduledExecutor ExecutorWrapperService<ScheduledExecutorService> watchdogExecutor, @Named(value="SdcGlue.Consumer.WatchdogPeriod") Duration watchdogPeriod, DpwsFramework dpwsFramework, Client client, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = HostingServiceLogger.getLogger(LOG, hostingServiceProxy, frameworkIdentifier);
        this.hostingServiceProxy = hostingServiceProxy;
        this.subscriptions = new HashMap<String, SubscribeResult>(subscriptions);
        this.watchdogExecutor = watchdogExecutor;
        this.watchdogPeriod = watchdogPeriod;
        this.requestedExpires = watchdogPeriod.multipliedBy(3L);
        this.eventBus = new AsyncEventBus((Executor)Executors.newSingleThreadExecutor());
        this.client = client;
        dpwsFramework.registerService(List.of(watchdogExecutor));
        if (initialWatchdogObserver != null) {
            this.registerObserver(initialWatchdogObserver);
        }
    }

    public void registerObserver(WatchdogObserver watchdogObserver) {
        this.eventBus.register((Object)watchdogObserver);
    }

    public void unregisterObserver(WatchdogObserver watchdogObserver) {
        this.eventBus.unregister((Object)watchdogObserver);
    }

    protected void startUp() {
        this.currentJob = ((ScheduledExecutorService)this.watchdogExecutor.get()).schedule(new WatchdogJob(), this.watchdogPeriod.toMillis(), TimeUnit.MILLISECONDS);
    }

    protected void shutDown() {
        if (this.currentJob != null && !this.currentJob.isDone()) {
            this.currentJob.cancel(true);
        }
    }

    private class WatchdogJob
    implements Runnable {
        private WatchdogJob() {
        }

        @Override
        public void run() {
            Duration timeout = SdcRemoteDeviceWatchdog.this.watchdogPeriod;
            boolean watchdogRequestSent = false;
            for (Map.Entry<String, SubscribeResult> entry : SdcRemoteDeviceWatchdog.this.subscriptions.entrySet()) {
                String serviceId = entry.getKey();
                SubscribeResult subscribeResult = entry.getValue();
                Instant start = Instant.now();
                HostedServiceProxy hostedServiceProxy = (HostedServiceProxy)SdcRemoteDeviceWatchdog.this.hostingServiceProxy.getHostedServices().get(serviceId);
                if (hostedServiceProxy == null) {
                    SdcRemoteDeviceWatchdog.this.instanceLogger.warn("Could not find expected hosted service with id {}", (Object)serviceId);
                    this.postWatchdogMessage(new Exception(String.format("Could not find expected hosted service with id %s", serviceId)));
                    return;
                }
                ListenableFuture renewFuture = hostedServiceProxy.getEventSinkAccess().renew(subscribeResult.getSubscriptionId(), SdcRemoteDeviceWatchdog.this.requestedExpires);
                try {
                    Duration grantedExpires = (Duration)renewFuture.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
                    if (grantedExpires.compareTo(SdcRemoteDeviceWatchdog.this.watchdogPeriod) < 0) {
                        SdcRemoteDeviceWatchdog.this.instanceLogger.warn("Too little time granted for subscription on service {} (expected at least {}, got {})", (Object)serviceId, (Object)SdcRemoteDeviceWatchdog.this.watchdogPeriod, (Object)grantedExpires);
                        this.postWatchdogMessage(new Exception(String.format("Too little time granted for subscription on service %s (expected at least %s, got %s)", serviceId, SdcRemoteDeviceWatchdog.this.watchdogPeriod, grantedExpires)));
                        return;
                    }
                }
                catch (Exception e) {
                    if (renewFuture != null) {
                        renewFuture.cancel(true);
                    }
                    SdcRemoteDeviceWatchdog.this.instanceLogger.warn("Trying to renew subscription running on service {} failed", (Object)serviceId, (Object)e);
                    this.postWatchdogMessage(new Exception(String.format("Trying to renew subscription running on service %s failed", serviceId), e));
                    return;
                }
                Instant finish = Instant.now();
                timeout = timeout.minus(Duration.between(start, finish));
                if (timeout.toMillis() < 0L) {
                    SdcRemoteDeviceWatchdog.this.instanceLogger.warn("Watchdog timeout exceeded. Could not get watchdog triggers served in time.");
                    this.postWatchdogMessage(new Exception("Watchdog timeout exceeded. Could not get watchdog triggers served in time."));
                    return;
                }
                watchdogRequestSent = true;
            }
            if (!watchdogRequestSent) {
                Instant start = Instant.now();
                ListenableFuture probeFuture = SdcRemoteDeviceWatchdog.this.client.directedProbe(SdcRemoteDeviceWatchdog.this.hostingServiceProxy.getActiveXAddr());
                try {
                    probeFuture.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
                    Instant finish = Instant.now();
                    timeout = timeout.minus(Duration.between(start, finish));
                }
                catch (Exception e) {
                    SdcRemoteDeviceWatchdog.this.instanceLogger.warn("Trying to request a directed probe failed");
                    this.postWatchdogMessage(new Exception("Trying to request a directed probe failed", e));
                    return;
                }
            }
            if (SdcRemoteDeviceWatchdog.this.isRunning() && SdcRemoteDeviceWatchdog.this.watchdogExecutor.isRunning()) {
                SdcRemoteDeviceWatchdog.this.currentJob = ((ScheduledExecutorService)SdcRemoteDeviceWatchdog.this.watchdogExecutor.get()).schedule(new WatchdogJob(), timeout.toMillis(), TimeUnit.MILLISECONDS);
            } else {
                SdcRemoteDeviceWatchdog.this.currentJob = null;
                SdcRemoteDeviceWatchdog.this.instanceLogger.info("WatchdogJob has ended, SdcRemoteDeviceWatchdog ({}) or WatchdogExecutor ({}) have ended", (Object)SdcRemoteDeviceWatchdog.this.state(), (Object)SdcRemoteDeviceWatchdog.this.watchdogExecutor.state());
            }
        }

        private void postWatchdogMessage(Exception reason) {
            if (SdcRemoteDeviceWatchdog.this.isRunning()) {
                SdcRemoteDeviceWatchdog.this.eventBus.post((Object)new WatchdogMessage(SdcRemoteDeviceWatchdog.this.hostingServiceProxy.getEndpointReferenceAddress(), reason));
            }
        }
    }
}

