/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer.sco;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.model.message.AbstractSet;
import org.somda.sdc.biceps.model.message.AbstractSetResponse;
import org.somda.sdc.biceps.model.message.OperationInvokedReport;
import org.somda.sdc.biceps.model.message.SetContextState;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.glue.consumer.SetServiceAccess;
import org.somda.sdc.glue.consumer.helper.HostingServiceLogger;
import org.somda.sdc.glue.consumer.sco.InvocationException;
import org.somda.sdc.glue.consumer.sco.ScoTransaction;
import org.somda.sdc.glue.consumer.sco.ScoTransactionImpl;
import org.somda.sdc.glue.consumer.sco.factory.OperationInvocationDispatcherFactory;
import org.somda.sdc.glue.consumer.sco.factory.ScoTransactionFactory;
import org.somda.sdc.glue.consumer.sco.helper.OperationInvocationDispatcher;

public class ScoController
implements SetServiceAccess {
    private static final Logger LOG = LogManager.getLogger(ScoController.class);
    private final HostedServiceProxy setServiceProxy;
    private final HostedServiceProxy contextServiceProxy;
    private final OperationInvocationDispatcher operationInvocationDispatcher;
    private final ExecutorWrapperService<ListeningExecutorService> executorService;
    private final SoapUtil soapUtil;
    private final ScoTransactionFactory scoTransactionFactory;
    private final Logger instanceLogger;

    @AssistedInject
    ScoController(@Assisted HostingServiceProxy hostingServiceProxy, @Assisted(value="setServiceProxy") @Nullable HostedServiceProxy setServiceProxy, @Assisted(value="contextServiceProxy") @Nullable HostedServiceProxy contextServiceProxy, OperationInvocationDispatcherFactory operationInvocationDispatcherFactory, @org.somda.sdc.glue.guice.Consumer ExecutorWrapperService<ListeningExecutorService> executorService, SoapUtil soapUtil, ScoTransactionFactory scoTransactionFactory, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = HostingServiceLogger.getLogger(LOG, hostingServiceProxy, frameworkIdentifier);
        this.setServiceProxy = setServiceProxy;
        this.contextServiceProxy = contextServiceProxy;
        this.operationInvocationDispatcher = operationInvocationDispatcherFactory.createOperationInvocationDispatcher(hostingServiceProxy);
        this.executorService = executorService;
        this.soapUtil = soapUtil;
        this.scoTransactionFactory = scoTransactionFactory;
    }

    @Override
    public <T extends AbstractSet, V extends AbstractSetResponse> ListenableFuture<ScoTransaction<V>> invoke(T setRequest, Class<V> responseClass) {
        return this.invoke(setRequest, null, responseClass);
    }

    @Override
    public <T extends AbstractSet, V extends AbstractSetResponse> ListenableFuture<ScoTransaction<V>> invoke(T setRequest, @Nullable Consumer<OperationInvokedReport.ReportPart> reportListener, Class<V> responseClass) {
        return ((ListeningExecutorService)this.executorService.get()).submit(() -> {
            this.instanceLogger.debug("Invoke {} operation with payload: {}", (Object)setRequest.getClass().getSimpleName(), (Object)setRequest);
            AbstractSetResponse response = (AbstractSetResponse)responseClass.cast(this.sendMessage(setRequest, responseClass));
            this.instanceLogger.debug("Received {} message with payload: {}", (Object)response.getClass().getSimpleName(), (Object)response);
            ScoTransactionImpl<AbstractSetResponse> transaction = this.scoTransactionFactory.createScoTransaction(response, reportListener);
            this.operationInvocationDispatcher.registerTransaction(transaction);
            return transaction;
        });
    }

    public void processOperationInvokedReport(OperationInvokedReport report) {
        this.operationInvocationDispatcher.dispatchReport(report);
    }

    private <T extends AbstractSet> Object sendMessage(T setRequest, Class<?> expectedResponseClass) throws InvocationException {
        HostedServiceProxy hostedServiceProxy;
        Object action = "http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/" + setRequest.getClass().getSimpleName();
        if (setRequest.getClass().equals(SetContextState.class)) {
            if (this.contextServiceProxy == null) {
                throw new InvocationException("SetContextState request could not be sent: no context service available");
            }
            action = "http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/SetContextState";
            hostedServiceProxy = this.contextServiceProxy;
        } else {
            if (this.setServiceProxy == null) {
                throw new InvocationException("Set request could not be sent: no set service available");
            }
            hostedServiceProxy = this.setServiceProxy;
        }
        SoapMessage request = this.soapUtil.createMessage((String)action, setRequest);
        try {
            SoapMessage response = hostedServiceProxy.getRequestResponseClient().sendRequestResponse(request);
            return this.soapUtil.getBody(response, expectedResponseClass).orElseThrow(() -> new InvocationException("Received unexpected response"));
        }
        catch (MarshallingException | SoapFaultException | TransportException | InterceptorException e) {
            throw new InvocationException(String.format("Request to %s failed: %s", hostedServiceProxy.getActiveEprAddress(), e.getMessage()), e);
        }
    }
}

