/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer.sco;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.somda.sdc.biceps.model.message.AbstractSetResponse;
import org.somda.sdc.biceps.model.message.OperationInvokedReport;
import org.somda.sdc.common.util.AutoLock;
import org.somda.sdc.glue.consumer.sco.ScoTransaction;
import org.somda.sdc.glue.consumer.sco.ScoUtil;

public class ScoTransactionImpl<T extends AbstractSetResponse>
implements ScoTransaction<T> {
    private final T response;
    private final Consumer<OperationInvokedReport.ReportPart> reportListener;
    private final ArrayList<OperationInvokedReport.ReportPart> collectedReports;
    private final ReentrantLock reportsLock;
    private final Condition reportsCondition;
    private final ScoUtil scoUtil;

    public ScoTransactionImpl(T response, @Nullable Consumer<OperationInvokedReport.ReportPart> reportListener, ScoUtil scoUtil) {
        this.response = response;
        this.reportListener = reportListener;
        this.reportsLock = new ReentrantLock();
        this.reportsCondition = this.reportsLock.newCondition();
        this.scoUtil = scoUtil;
        this.collectedReports = new ArrayList(3);
    }

    @Override
    public long getTransactionId() {
        return this.response.getInvocationInfo().getTransactionId();
    }

    @Override
    public List<OperationInvokedReport.ReportPart> getReports() {
        try (AutoLock ignored = AutoLock.lock((Lock)this.reportsLock);){
            List<OperationInvokedReport.ReportPart> list = this.deepCopyCollectedReports();
            return list;
        }
    }

    @Override
    public T getResponse() {
        return (T)this.response.createCopy();
    }

    @Override
    public List<OperationInvokedReport.ReportPart> waitForFinalReport(Duration waitTime) {
        Duration copyWaitTime = waitTime;
        try (AutoLock ignored = AutoLock.lock((Lock)this.reportsLock);){
            Instant finish;
            Instant start;
            if (this.scoUtil.hasFinalReport(this.collectedReports)) {
                List<OperationInvokedReport.ReportPart> list = this.deepCopyCollectedReports();
                return list;
            }
            do {
                List<OperationInvokedReport.ReportPart> list;
                block17: {
                    start = Instant.now();
                    try {
                        if (!this.reportsCondition.await(waitTime.toMillis(), TimeUnit.MILLISECONDS)) break block17;
                        if (this.scoUtil.hasFinalReport(this.collectedReports)) {
                            list = this.deepCopyCollectedReports();
                            return list;
                        }
                        continue;
                    }
                    catch (InterruptedException e) {
                        if (this.scoUtil.hasFinalReport(this.collectedReports)) {
                            List<OperationInvokedReport.ReportPart> list2 = this.deepCopyCollectedReports();
                            return list2;
                        }
                        List<OperationInvokedReport.ReportPart> list3 = Collections.emptyList();
                        return list3;
                    }
                }
                list = Collections.emptyList();
                return list;
            } while ((copyWaitTime = copyWaitTime.minus(Duration.between(start, finish = Instant.now()))).toMillis() > 0L);
        }
        return Collections.emptyList();
    }

    public void receiveIncomingReport(OperationInvokedReport.ReportPart report) {
        try (AutoLock ignored = AutoLock.lock((Lock)this.reportsLock);){
            this.collectedReports.add(report);
            this.reportsCondition.signalAll();
        }
        if (this.reportListener != null) {
            this.reportListener.accept(report);
        }
    }

    private List<OperationInvokedReport.ReportPart> deepCopyCollectedReports() {
        return this.collectedReports.stream().map(OperationInvokedReport.ReportPart::createCopy).collect(Collectors.toList());
    }
}

