/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer.sco.helper;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.model.message.AbstractSetResponse;
import org.somda.sdc.biceps.model.message.OperationInvokedReport;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.glue.consumer.helper.HostingServiceLogger;
import org.somda.sdc.glue.consumer.sco.ScoTransaction;
import org.somda.sdc.glue.consumer.sco.ScoTransactionImpl;
import org.somda.sdc.glue.consumer.sco.ScoUtil;

public class OperationInvocationDispatcher {
    private static final Logger LOG = LogManager.getLogger(OperationInvocationDispatcher.class);
    private final ScoUtil scoUtil;
    private final Duration awaitingTransactionTimeout;
    private final Map<Long, BlockingQueue<OperationInvokedReport.ReportPart>> pendingReports;
    private final Map<Long, ScoTransactionImpl<? extends AbstractSetResponse>> runningTransactions;
    private final Map<Long, Instant> awaitingTransactions;
    private final Logger instanceLogger;

    @Inject
    OperationInvocationDispatcher(@Assisted HostingServiceProxy hostingServiceProxy, ScoUtil scoUtil, @Named(value="SdcGlue.Consumer.AwaitingTransactionTimeout") Duration awaitingTransactionTimeout, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = HostingServiceLogger.getLogger(LOG, hostingServiceProxy, frameworkIdentifier);
        this.scoUtil = scoUtil;
        this.awaitingTransactionTimeout = awaitingTransactionTimeout;
        this.pendingReports = new HashMap<Long, BlockingQueue<OperationInvokedReport.ReportPart>>();
        this.runningTransactions = new HashMap<Long, ScoTransactionImpl<? extends AbstractSetResponse>>();
        this.awaitingTransactions = new HashMap<Long, Instant>();
    }

    public synchronized void dispatchReport(OperationInvokedReport report) {
        report.getReportPart().forEach(this::dispatchReport);
    }

    public synchronized void registerTransaction(ScoTransactionImpl<? extends AbstractSetResponse> transaction) {
        long transactionId = transaction.getTransactionId();
        ScoTransaction runningTransaction = this.runningTransactions.get(transactionId);
        if (runningTransaction != null) {
            this.instanceLogger.warn("Try to add transaction {} twice, which is not permitted", (Object)transactionId);
            return;
        }
        this.awaitingTransactions.remove(transactionId);
        this.runningTransactions.put(transaction.getTransactionId(), transaction);
        BlockingQueue<OperationInvokedReport.ReportPart> reportPartsQueue = this.pendingReports.get(transactionId);
        if (reportPartsQueue != null) {
            this.applyReportsOnTransaction(reportPartsQueue, transaction);
        }
    }

    private void dispatchReport(OperationInvokedReport.ReportPart reportPart) {
        BlockingQueue<OperationInvokedReport.ReportPart> reportPartsQueue;
        long transactionId = reportPart.getInvocationInfo().getTransactionId();
        this.sanitizeAwaitingTransactions();
        BlockingQueue<OperationInvokedReport.ReportPart> guardedQueue = this.pendingReports.get(transactionId);
        if (guardedQueue == null) {
            reportPartsQueue = new LinkedBlockingQueue<OperationInvokedReport.ReportPart>(3);
            this.pendingReports.put(transactionId, reportPartsQueue);
            this.awaitingTransactions.put(transactionId, Instant.now());
        } else {
            reportPartsQueue = guardedQueue;
        }
        ScoTransactionImpl<? extends AbstractSetResponse> transaction = this.runningTransactions.get(transactionId);
        if (this.scoUtil.isFinalReport(reportPart)) {
            this.runningTransactions.remove(transactionId);
        }
        if (!reportPartsQueue.offer(reportPart)) {
            this.instanceLogger.warn("Too many reports received for transaction {}", (Object)transactionId);
            return;
        }
        if (transaction != null) {
            this.applyReportsOnTransaction(reportPartsQueue, transaction);
        }
    }

    private void applyReportsOnTransaction(BlockingQueue<OperationInvokedReport.ReportPart> queue, ScoTransactionImpl<? extends AbstractSetResponse> transaction) {
        while (!queue.isEmpty()) {
            try {
                OperationInvokedReport.ReportPart reportFromQueue = queue.take();
                transaction.receiveIncomingReport(reportFromQueue);
            }
            catch (InterruptedException e) {
                this.instanceLogger.error("Could not take expected report from queue for transaction {}", (Object)transaction.getTransactionId());
                return;
            }
        }
    }

    private void sanitizeAwaitingTransactions() {
        Instant finish = Instant.now();
        List<Long> toRemove = this.awaitingTransactions.entrySet().stream().filter(entry -> Duration.between((Temporal)entry.getValue(), finish).compareTo(this.awaitingTransactionTimeout) > 0).map(Map.Entry::getKey).collect(Collectors.toList());
        toRemove.forEach(this.awaitingTransactions.keySet()::remove);
        toRemove.forEach(this.runningTransactions.keySet()::remove);
    }
}

