/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.provider.plugin;

import com.google.common.base.Joiner;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.access.MdibAccess;
import org.somda.sdc.biceps.common.access.MdibAccessObserver;
import org.somda.sdc.biceps.common.event.ContextStateModificationMessage;
import org.somda.sdc.biceps.common.event.DescriptionModificationMessage;
import org.somda.sdc.biceps.model.participant.AbstractComplexDeviceComponentDescriptor;
import org.somda.sdc.biceps.model.participant.ContextAssociation;
import org.somda.sdc.biceps.model.participant.InstanceIdentifier;
import org.somda.sdc.biceps.model.participant.LocationContextState;
import org.somda.sdc.biceps.model.participant.MdsDescriptor;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.device.Device;
import org.somda.sdc.glue.GlueConstants;
import org.somda.sdc.glue.common.uri.ComplexDeviceComponentMapper;
import org.somda.sdc.glue.common.uri.LocationDetailQueryMapper;
import org.somda.sdc.glue.common.uri.UriMapperGenerationArgumentException;
import org.somda.sdc.glue.provider.SdcDeviceContext;
import org.somda.sdc.glue.provider.SdcDevicePlugin;
import org.somda.sdc.glue.provider.plugin.ScopesDecorator;
import org.somda.sdc.mdpws.common.CommonConstants;

public class SdcRequiredTypesAndScopes
implements SdcDevicePlugin,
MdibAccessObserver,
ScopesDecorator {
    private static final Logger LOG = LogManager.getLogger(SdcRequiredTypesAndScopes.class);
    private final Logger instanceLogger;
    private Device device;
    private MdibAccess mdibAccess;
    private Set<String> allScopes;
    private Set<String> locationContexts;
    private Set<String> mdsTypes;
    private boolean initializing;

    @Inject
    SdcRequiredTypesAndScopes(@Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.allScopes = new HashSet<String>();
        this.locationContexts = new HashSet<String>();
        this.mdsTypes = new HashSet<String>();
        this.initializing = true;
    }

    @Override
    public void beforeStartUp(SdcDeviceContext context) {
        this.instanceLogger.info("Startup of automatic required types and scopes updating for device with EPR address {}", (Object)context.getDevice().getEprAddress());
        this.init(context, Collections.emptySet());
        context.getLocalMdibAccess().registerObserver((MdibAccessObserver)this);
    }

    @Override
    public void afterShutDown(SdcDeviceContext context) {
        this.instanceLogger.info("Automatic required types and scopes updating for device with EPR address {} stopped", (Object)context.getDevice().getEprAddress());
    }

    @Override
    public void init(SdcDeviceContext context, Set<String> scopes) {
        this.device = context.getDevice();
        this.device.getDiscoveryAccess().setTypes(Collections.singletonList(CommonConstants.MEDICAL_DEVICE_TYPE));
        this.device.getDiscoveryAccess().setScopes(Collections.singletonList(GlueConstants.SCOPE_SDC_PROVIDER));
        this.mdibAccess = context.getLocalMdibAccess();
        this.updateScopes();
        this.appendScopesAndSendHello(Collections.emptySet());
    }

    @Override
    public void appendScopesAndSendHello(Set<String> scopes) {
        this.updateScopes();
        HashSet<String> newScopes = new HashSet<String>(this.locationContexts.size() + this.mdsTypes.size() + scopes.size());
        newScopes.add(GlueConstants.SCOPE_SDC_PROVIDER);
        newScopes.addAll(this.locationContexts);
        newScopes.addAll(this.mdsTypes);
        this.instanceLogger.debug("Append scopes [{}] to internal scope set [{}]", new Supplier[]{() -> Joiner.on((String)",").join((Iterable)scopes), () -> Joiner.on((String)",").join((Iterable)newScopes)});
        newScopes.addAll(scopes);
        if (this.allScopes.size() == newScopes.size()) {
            HashSet<String> newScopesCopy = new HashSet<String>(newScopes);
            newScopesCopy.removeAll(this.allScopes);
            if (newScopesCopy.isEmpty()) {
                this.instanceLogger.debug("No scope changes detected");
                return;
            }
        }
        this.allScopes = newScopes;
        this.device.getDiscoveryAccess().setScopes(newScopes);
        if (this.initializing) {
            this.initializing = false;
        } else {
            this.device.getDiscoveryAccess().sendHello();
        }
    }

    @Subscribe
    private void onContextChange(ContextStateModificationMessage message) {
        this.instanceLogger.info("Context modification received");
        this.appendScopesAndSendHello(Collections.emptySet());
    }

    @Subscribe
    private void onDescriptionChange(DescriptionModificationMessage message) {
        this.instanceLogger.info("Description modification received");
        this.appendScopesAndSendHello(Collections.emptySet());
    }

    private void updateScopes() {
        Set<String> locationContextsBefore = this.locationContexts;
        this.locationContexts = this.extractAssociatedLocationContextStateIdentifiers(this.mdibAccess.findContextStatesByType(LocationContextState.class));
        this.instanceLogger.info("Location context scopes updated from [{}] to [{}]", new Supplier[]{() -> Joiner.on((String)",").join((Iterable)locationContextsBefore), () -> Joiner.on((String)",").join(this.locationContexts)});
        Set<String> mdsTypesBefore = this.mdsTypes;
        this.mdsTypes = this.extractMdsTypes(this.mdibAccess.findEntitiesByType(MdsDescriptor.class));
        this.instanceLogger.info("MDS type scopes updated from [{}] to [{}]", new Supplier[]{() -> Joiner.on((String)",").join((Iterable)mdsTypesBefore), () -> Joiner.on((String)",").join(this.mdsTypes)});
    }

    private Set<String> extractMdsTypes(Collection<MdibEntity> entities) {
        List mdsDescriptors = entities.stream().filter(mdibEntity -> mdibEntity.getDescriptor(MdsDescriptor.class).isPresent()).map(mdibEntity -> (MdsDescriptor)mdibEntity.getDescriptor(MdsDescriptor.class).get()).collect(Collectors.toList());
        HashSet<String> uris = new HashSet<String>(mdsDescriptors.size());
        for (MdsDescriptor mdsDescriptor : mdsDescriptors) {
            try {
                uris.add(ComplexDeviceComponentMapper.fromComplexDeviceComponent((AbstractComplexDeviceComponentDescriptor)mdsDescriptor));
            }
            catch (UriMapperGenerationArgumentException e) {
                this.instanceLogger.warn("The URI generation based on the given MdsDescriptor with the handle {} failed", (Object)mdsDescriptor.getHandle(), (Object)e);
            }
        }
        return uris;
    }

    private Set<String> extractAssociatedLocationContextStateIdentifiers(List<LocationContextState> contextStates) {
        Optional<LocationContextState> locationContextState = contextStates.stream().filter(contextState -> ContextAssociation.ASSOC.equals((Object)contextState.getContextAssociation())).findFirst();
        if (locationContextState.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> uris = new HashSet<String>(locationContextState.get().getIdentification().size());
        for (InstanceIdentifier instanceIdentifier : locationContextState.get().getIdentification()) {
            try {
                uris.add(LocationDetailQueryMapper.createWithLocationDetailQuery(instanceIdentifier, locationContextState.get().getLocationDetail()));
            }
            catch (UriMapperGenerationArgumentException e) {
                this.instanceLogger.warn("Unable to encode to an URI", (Throwable)e);
            }
        }
        return uris;
    }
}

