/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.provider.sco;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.model.message.InvocationError;
import org.somda.sdc.biceps.model.message.InvocationInfo;
import org.somda.sdc.biceps.model.message.InvocationState;
import org.somda.sdc.biceps.model.message.ObjectFactory;
import org.somda.sdc.biceps.model.message.OperationInvokedReport;
import org.somda.sdc.biceps.model.participant.InstanceIdentifier;
import org.somda.sdc.biceps.model.participant.LocalizedText;
import org.somda.sdc.biceps.model.participant.MdibVersion;
import org.somda.sdc.biceps.provider.access.LocalMdibAccess;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.ObjectStringifier;
import org.somda.sdc.common.util.Stringified;
import org.somda.sdc.dpws.device.EventSourceAccess;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.glue.provider.sco.InvocationResponse;

public class Context {
    private static final Logger LOG = LogManager.getLogger(Context.class);
    @Stringified
    private final long transactionId;
    @Stringified
    private final String operationHandle;
    @Stringified
    private final InstanceIdentifier invocationSource;
    private final EventSourceAccess eventSource;
    private final LocalMdibAccess mdibAccess;
    private final ObjectFactory messageModelFactory;
    private final Logger instanceLogger;

    @AssistedInject
    Context(@Assisted long transactionId, @Assisted String operationHandle, @Assisted InstanceIdentifier invocationSource, @Assisted EventSourceAccess eventSource, @Assisted LocalMdibAccess mdibAccess, ObjectFactory messageModelFactory, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.transactionId = transactionId;
        this.operationHandle = operationHandle;
        this.invocationSource = invocationSource;
        this.eventSource = eventSource;
        this.mdibAccess = mdibAccess;
        this.messageModelFactory = messageModelFactory;
    }

    public LocalMdibAccess getMdibAccess() {
        return this.mdibAccess;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public String getOperationHandle() {
        return this.operationHandle;
    }

    public InstanceIdentifier getInvocationSource() {
        return this.invocationSource;
    }

    public InvocationResponse createSuccessfulResponse(MdibVersion mdibVersion, InvocationState invocationState) {
        return new InvocationResponse(mdibVersion, this.transactionId, invocationState, null, null);
    }

    public InvocationResponse createSuccessfulResponse(InvocationState invocationState) {
        return new InvocationResponse(this.mdibAccess.getMdibVersion(), this.transactionId, invocationState, null, null);
    }

    public InvocationResponse createUnsuccessfulResponse(MdibVersion mdibVersion, InvocationState invocationState, InvocationError invocationError, List<LocalizedText> invocationErrorMessage) {
        return new InvocationResponse(mdibVersion, this.transactionId, invocationState, invocationError, invocationErrorMessage);
    }

    public InvocationResponse createUnsuccessfulResponse(InvocationState invocationState, InvocationError invocationError, List<LocalizedText> invocationErrorMessage) {
        return new InvocationResponse(this.mdibAccess.getMdibVersion(), this.transactionId, invocationState, invocationError, invocationErrorMessage);
    }

    public void sendSuccessfulReport(MdibVersion mdibVersion, InvocationState invocationState) {
        this.sendReport(mdibVersion, invocationState, null, null, null);
    }

    public void sendSuccessfulReport(MdibVersion mdibVersion, InvocationState invocationState, @Nullable String operationTarget) {
        this.sendReport(mdibVersion, invocationState, null, null, operationTarget);
    }

    public void sendSuccessfulReport(InvocationState invocationState, @Nullable String operationTarget) {
        this.sendReport(this.mdibAccess.getMdibVersion(), invocationState, null, null, operationTarget);
    }

    public void sendSuccessfulReport(InvocationState invocationState) {
        this.sendReport(this.mdibAccess.getMdibVersion(), invocationState, null, null, null);
    }

    public void sendUnsuccessfulReport(MdibVersion mdibVersion, InvocationState invocationState, InvocationError invocationError, List<LocalizedText> invocationErrorMessage) {
        this.sendReport(mdibVersion, invocationState, invocationError, invocationErrorMessage, null);
    }

    public void sendUnsuccessfulReport(InvocationState invocationState, InvocationError invocationError, List<LocalizedText> invocationErrorMessage) {
        this.sendReport(this.mdibAccess.getMdibVersion(), invocationState, invocationError, invocationErrorMessage, null);
    }

    public void sendReport(MdibVersion mdibVersion, InvocationState invocationState, @Nullable InvocationError invocationError, @Nullable List<LocalizedText> invocationErrorMessage, @Nullable String operationTarget) {
        LOG.debug("Sending report for context {} at MDIB version {} with invocation state: {}", (Object)this, (Object)mdibVersion, (Object)invocationState);
        InvocationInfo invocationInfo = this.messageModelFactory.createInvocationInfo();
        invocationInfo.setInvocationState(invocationState);
        invocationInfo.setTransactionId(this.transactionId);
        invocationInfo.setInvocationError(invocationError);
        invocationInfo.setInvocationErrorMessage(invocationErrorMessage);
        OperationInvokedReport.ReportPart reportPart = this.messageModelFactory.createOperationInvokedReportReportPart();
        reportPart.setOperationHandleRef(this.operationHandle);
        reportPart.setOperationTarget(operationTarget);
        reportPart.setInvocationSource(this.invocationSource);
        reportPart.setInvocationInfo(invocationInfo);
        OperationInvokedReport operationInvokedReport = this.messageModelFactory.createOperationInvokedReport();
        operationInvokedReport.setSequenceId(mdibVersion.getSequenceId());
        operationInvokedReport.setInstanceId(mdibVersion.getInstanceId());
        operationInvokedReport.setMdibVersion(mdibVersion.getVersion());
        operationInvokedReport.getReportPart().add(reportPart);
        try {
            this.eventSource.sendNotification("http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/OperationInvokedReport", (Object)operationInvokedReport);
        }
        catch (MarshallingException e) {
            this.instanceLogger.warn("Could not marshal operation invoked report notification of transaction {} with invocation state {}", (Object)this.transactionId, (Object)invocationState);
        }
        catch (TransportException e) {
            this.instanceLogger.warn("Could not deliver operation invoked report notification of transaction {} with invocation state {}", (Object)this.transactionId, (Object)invocationState);
        }
    }

    public String toString() {
        return ObjectStringifier.stringify((Object)this);
    }
}

