/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.common;

import com.google.common.collect.ArrayListMultimap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.MdibTypeValidator;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractMultiState;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.AlertSystemDescriptor;
import org.somda.sdc.biceps.model.participant.ChannelDescriptor;
import org.somda.sdc.biceps.model.participant.Mdib;
import org.somda.sdc.biceps.model.participant.MdsDescriptor;
import org.somda.sdc.biceps.model.participant.ScoDescriptor;
import org.somda.sdc.biceps.model.participant.SystemContextDescriptor;
import org.somda.sdc.biceps.model.participant.VmdDescriptor;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.glue.common.DefaultStateValues;
import org.somda.sdc.glue.common.RequiredDefaultStateValues;
import org.somda.sdc.glue.common.helper.DefaultStateValuesDispatcher;

public class ModificationsBuilder {
    private static final Logger LOG = LogManager.getLogger(ModificationsBuilder.class);
    private final ArrayListMultimap<String, AbstractState> states;
    private final MdibDescriptionModifications modifications;
    private final Boolean createSingleStateIfMissing;
    private final MdibTypeValidator typeValidator;
    private final DefaultStateValuesDispatcher defaultStateValuesDispatcher;
    private final Logger instanceLogger;

    @AssistedInject
    ModificationsBuilder(@Assisted Mdib mdib, MdibTypeValidator typeValidator, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this(mdib, false, null, typeValidator, frameworkIdentifier);
    }

    @AssistedInject
    ModificationsBuilder(@Assisted Mdib mdib, @Assisted Boolean createSingleStateIfMissing, MdibTypeValidator typeValidator, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this(mdib, createSingleStateIfMissing, null, typeValidator, frameworkIdentifier);
    }

    @AssistedInject
    ModificationsBuilder(@Assisted Mdib mdib, @Assisted Boolean createSingleStateIfMissing, @Assisted @Nullable DefaultStateValues defaultStateValues, MdibTypeValidator typeValidator, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.createSingleStateIfMissing = createSingleStateIfMissing;
        this.typeValidator = typeValidator;
        DefaultStateValues copyDefaultStateValues = defaultStateValues;
        if (copyDefaultStateValues == null) {
            copyDefaultStateValues = new RequiredDefaultStateValues();
        }
        this.defaultStateValuesDispatcher = new DefaultStateValuesDispatcher(copyDefaultStateValues);
        if (!createSingleStateIfMissing.booleanValue() && mdib.getMdState() == null) {
            throw new RuntimeException("No states found but required. Try using createSingleStateIfMissing=false to auto-create states");
        }
        this.states = ArrayListMultimap.create();
        if (mdib.getMdState() != null) {
            mdib.getMdState().getState().forEach(state -> this.states.put((Object)state.getDescriptorHandle(), state));
        }
        this.modifications = MdibDescriptionModifications.create();
        mdib.getMdDescription().getMds().forEach(this::build);
    }

    public MdibDescriptionModifications get() {
        return this.modifications;
    }

    private void build(MdsDescriptor mds) {
        this.insert((AbstractDescriptor)mds, null);
        this.build(mds.getAlertSystem(), (AbstractDescriptor)mds);
        mds.setAlertSystem(null);
        this.build(mds.getSco(), (AbstractDescriptor)mds);
        mds.setSco(null);
        this.build(mds.getSystemContext(), (AbstractDescriptor)mds);
        mds.setSystemContext(null);
        this.buildLeaf(mds.getClock(), (AbstractDescriptor)mds);
        mds.setClock(null);
        mds.getBattery().forEach(descr -> this.buildLeaf(descr, (AbstractDescriptor)mds));
        mds.setBattery(null);
        mds.getVmd().forEach(descr -> this.build((VmdDescriptor)descr, (AbstractDescriptor)mds));
        mds.setVmd(null);
    }

    private void build(@Nullable ScoDescriptor sco, AbstractDescriptor parent) {
        if (sco == null) {
            return;
        }
        this.insert((AbstractDescriptor)sco, parent);
        sco.getOperation().forEach(descriptor -> this.buildLeaf(descriptor, (AbstractDescriptor)sco));
        sco.setOperation(null);
    }

    private void build(@Nullable SystemContextDescriptor systemContext, AbstractDescriptor parent) {
        if (systemContext == null) {
            return;
        }
        this.insert((AbstractDescriptor)systemContext, parent);
        this.buildMultiStateLeaf(systemContext.getLocationContext(), (AbstractDescriptor)systemContext);
        systemContext.setLocationContext(null);
        this.buildMultiStateLeaf(systemContext.getPatientContext(), (AbstractDescriptor)systemContext);
        systemContext.setPatientContext(null);
        systemContext.getEnsembleContext().forEach(descr -> this.buildMultiStateLeaf(descr, (AbstractDescriptor)systemContext));
        systemContext.setEnsembleContext(null);
        systemContext.getWorkflowContext().forEach(descr -> this.buildMultiStateLeaf(descr, (AbstractDescriptor)systemContext));
        systemContext.setWorkflowContext(null);
        systemContext.getOperatorContext().forEach(descr -> this.buildMultiStateLeaf(descr, (AbstractDescriptor)systemContext));
        systemContext.setOperatorContext(null);
        systemContext.getMeansContext().forEach(descr -> this.buildMultiStateLeaf(descr, (AbstractDescriptor)systemContext));
        systemContext.setMeansContext(null);
    }

    private void build(@Nullable AlertSystemDescriptor alertSystem, AbstractDescriptor parent) {
        if (alertSystem == null) {
            return;
        }
        this.insert((AbstractDescriptor)alertSystem, parent);
        alertSystem.getAlertCondition().forEach(descr -> this.buildLeaf(descr, (AbstractDescriptor)alertSystem));
        alertSystem.setAlertCondition(null);
        alertSystem.getAlertSignal().forEach(descr -> this.buildLeaf(descr, (AbstractDescriptor)alertSystem));
        alertSystem.setAlertSignal(null);
    }

    private void build(@Nullable VmdDescriptor vmd, AbstractDescriptor parent) {
        if (vmd == null) {
            return;
        }
        this.insert((AbstractDescriptor)vmd, parent);
        this.build(vmd.getSco(), (AbstractDescriptor)vmd);
        vmd.setSco(null);
        this.build(vmd.getAlertSystem(), (AbstractDescriptor)vmd);
        vmd.setAlertSystem(null);
        vmd.getChannel().forEach(descr -> this.build((ChannelDescriptor)descr, (AbstractDescriptor)vmd));
        vmd.setChannel(null);
    }

    private void build(@Nullable ChannelDescriptor channel, AbstractDescriptor parent) {
        if (channel == null) {
            return;
        }
        this.insert((AbstractDescriptor)channel, parent);
        channel.getMetric().forEach(descr -> this.buildLeaf(descr, (AbstractDescriptor)channel));
        channel.setMetric(null);
    }

    private <T extends AbstractDescriptor> void buildLeaf(@Nullable T descriptor, AbstractDescriptor parent) {
        if (descriptor != null) {
            this.modifications.insert(descriptor, this.singleState(descriptor), parent.getHandle());
        }
    }

    private <T extends AbstractDescriptor> void buildMultiStateLeaf(@Nullable T descriptor, AbstractDescriptor parent) {
        if (descriptor != null) {
            this.modifications.insert(descriptor, this.multiStates(descriptor), parent.getHandle());
        }
    }

    private AbstractState singleState(AbstractDescriptor descriptor) {
        List statesCollection = this.states.get((Object)descriptor.getHandle());
        if (statesCollection.isEmpty()) {
            if (this.createSingleStateIfMissing.booleanValue()) {
                try {
                    AbstractState state = (AbstractState)this.typeValidator.resolveStateType(descriptor.getClass()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.defaultStateValuesDispatcher.dispatchDefaultStateValues(state);
                    return state;
                }
                catch (Exception e) {
                    this.instanceLogger.warn("Could not create state for {} with handle {}", (Object)descriptor.getClass().getSimpleName(), (Object)descriptor.getHandle(), (Object)e);
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(String.format("No state found for descriptor handle %s", descriptor.getHandle()));
        }
        return (AbstractState)statesCollection.get(0);
    }

    private List<AbstractMultiState> multiStates(AbstractDescriptor descriptor) {
        List abstractStates = this.states.get((Object)descriptor.getHandle());
        ArrayList<AbstractMultiState> abstractMultiStates = new ArrayList<AbstractMultiState>(abstractStates.size());
        abstractStates.forEach(abstractState -> {
            if (abstractState instanceof AbstractMultiState) {
                abstractMultiStates.add((AbstractMultiState)abstractState);
            }
        });
        return abstractMultiStates;
    }

    private void insert(AbstractDescriptor descriptor, @Nullable AbstractDescriptor parent) {
        String parentHandle = null;
        if (parent != null) {
            parentHandle = parent.getHandle();
        }
        this.modifications.insert(descriptor, this.singleState(descriptor), parentHandle);
    }
}

