/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Provider;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.access.MdibAccessObserver;
import org.somda.sdc.biceps.common.storage.PreprocessingException;
import org.somda.sdc.biceps.consumer.access.RemoteMdibAccess;
import org.somda.sdc.biceps.consumer.access.factory.RemoteMdibAccessFactory;
import org.somda.sdc.biceps.model.message.AbstractGetResponse;
import org.somda.sdc.biceps.model.message.AbstractReport;
import org.somda.sdc.biceps.model.message.GetContextStatesResponse;
import org.somda.sdc.biceps.model.message.GetMdibResponse;
import org.somda.sdc.biceps.model.message.ObjectFactory;
import org.somda.sdc.biceps.model.message.OperationInvokedReport;
import org.somda.sdc.biceps.model.participant.Mdib;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.DpwsFramework;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.NotificationObject;
import org.somda.sdc.dpws.soap.wseventing.SubscribeResult;
import org.somda.sdc.glue.common.MdibVersionUtil;
import org.somda.sdc.glue.common.ModificationsBuilder;
import org.somda.sdc.glue.common.SubscribableActionsMapping;
import org.somda.sdc.glue.common.WsdlConstants;
import org.somda.sdc.glue.common.factory.ModificationsBuilderFactory;
import org.somda.sdc.glue.consumer.ConnectConfiguration;
import org.somda.sdc.glue.consumer.PrerequisitesException;
import org.somda.sdc.glue.consumer.SdcRemoteDevice;
import org.somda.sdc.glue.consumer.SdcRemoteDeviceWatchdog;
import org.somda.sdc.glue.consumer.SdcRemoteDevicesConnector;
import org.somda.sdc.glue.consumer.SdcRemoteDevicesObserver;
import org.somda.sdc.glue.consumer.WatchdogObserver;
import org.somda.sdc.glue.consumer.event.RemoteDeviceConnectedMessage;
import org.somda.sdc.glue.consumer.event.RemoteDeviceDisconnectedMessage;
import org.somda.sdc.glue.consumer.event.WatchdogMessage;
import org.somda.sdc.glue.consumer.factory.SdcRemoteDeviceFactory;
import org.somda.sdc.glue.consumer.factory.SdcRemoteDeviceWatchdogFactory;
import org.somda.sdc.glue.consumer.helper.HostingServiceLogger;
import org.somda.sdc.glue.consumer.localization.LocalizationServiceProxy;
import org.somda.sdc.glue.consumer.localization.factory.LocalizationServiceProxyFactory;
import org.somda.sdc.glue.consumer.report.ReportProcessingException;
import org.somda.sdc.glue.consumer.report.ReportProcessor;
import org.somda.sdc.glue.consumer.sco.ScoController;
import org.somda.sdc.glue.consumer.sco.factory.ScoControllerFactory;
import org.somda.sdc.glue.guice.Consumer;

public class SdcRemoteDevicesConnectorImpl
extends AbstractIdleService
implements SdcRemoteDevicesConnector,
WatchdogObserver {
    private static final Logger LOG = LogManager.getLogger(SdcRemoteDevicesConnectorImpl.class);
    private final ExecutorWrapperService<ListeningExecutorService> executorService;
    private final Map<String, SdcRemoteDevice> sdcRemoteDevices;
    private final EventBus eventBus;
    private final Logger instanceLogger;
    private final Provider<ReportProcessor> reportProcessorProvider;
    private final ScoControllerFactory scoControllerFactory;
    private final LocalizationServiceProxyFactory localizationServiceProxyFactory;
    private final Duration requestedExpires;
    private final Duration responseWaitingTime;
    private final SoapUtil soapUtil;
    private final ModificationsBuilderFactory modificationsBuilderFactory;
    private final RemoteMdibAccessFactory remoteMdibAccessFactory;
    private final ObjectFactory messageModelFactory;
    private final MdibVersionUtil mdibVersionUtil;
    private final SdcRemoteDeviceFactory sdcRemoteDeviceFactory;
    private final SdcRemoteDeviceWatchdogFactory watchdogFactory;
    private final String frameworkIdentifier;

    @Inject
    SdcRemoteDevicesConnectorImpl(@Consumer ExecutorWrapperService<ListeningExecutorService> executorService, ConcurrentHashMap<String, SdcRemoteDevice> sdcRemoteDevices, EventBus eventBus, Provider<ReportProcessor> reportProcessorProvider, ScoControllerFactory scoControllerFactory, LocalizationServiceProxyFactory localizationServiceProxyFactory, @Named(value="SdcGlue.Consumer.RequestedExpires") Duration requestedExpires, @Named(value="Dpws.MaxWaitForFutures") Duration responseWaitingTime, SoapUtil soapUtil, ModificationsBuilderFactory modificationsBuilderFactory, RemoteMdibAccessFactory remoteMdibAccessFactory, ObjectFactory messageModelFactory, MdibVersionUtil mdibVersionUtil, SdcRemoteDeviceFactory sdcRemoteDeviceFactory, SdcRemoteDeviceWatchdogFactory watchdogFactory, DpwsFramework dpwsFramework, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.executorService = executorService;
        this.sdcRemoteDevices = sdcRemoteDevices;
        this.eventBus = eventBus;
        this.reportProcessorProvider = reportProcessorProvider;
        this.scoControllerFactory = scoControllerFactory;
        this.localizationServiceProxyFactory = localizationServiceProxyFactory;
        this.requestedExpires = requestedExpires;
        this.responseWaitingTime = responseWaitingTime;
        this.soapUtil = soapUtil;
        this.modificationsBuilderFactory = modificationsBuilderFactory;
        this.remoteMdibAccessFactory = remoteMdibAccessFactory;
        this.messageModelFactory = messageModelFactory;
        this.mdibVersionUtil = mdibVersionUtil;
        this.sdcRemoteDeviceFactory = sdcRemoteDeviceFactory;
        this.watchdogFactory = watchdogFactory;
        this.frameworkIdentifier = frameworkIdentifier;
        dpwsFramework.registerService(List.of(executorService, this));
    }

    @Override
    public ListenableFuture<SdcRemoteDevice> connect(HostingServiceProxy hostingServiceProxy, ConnectConfiguration connectConfiguration) throws PrerequisitesException {
        return this.connect(hostingServiceProxy, connectConfiguration, null);
    }

    @Override
    public ListenableFuture<SdcRemoteDevice> connect(HostingServiceProxy hostingServiceProxy, ConnectConfiguration connectConfiguration, @Nullable MdibAccessObserver mdibAccessObserver) throws PrerequisitesException {
        this.checkExistingConnection(hostingServiceProxy);
        this.checkRequiredServices(hostingServiceProxy, connectConfiguration.getRequiredPortTypes());
        return ((ListeningExecutorService)this.executorService.get()).submit(() -> {
            try {
                Logger tempLog = HostingServiceLogger.getLogger(LOG, hostingServiceProxy, this.frameworkIdentifier);
                tempLog.info("Start connecting");
                ReportProcessor reportProcessor = this.createReportProcessor();
                Optional<ScoController> scoController = this.createScoController(hostingServiceProxy);
                LocalizationServiceProxy localizationServiceProxy = this.createLocalizationServiceProxy(hostingServiceProxy);
                Map<String, SubscribeResult> subscribeResults = this.subscribeServices(hostingServiceProxy, connectConfiguration.getActions(), reportProcessor, scoController.orElse(null));
                RemoteMdibAccess mdibAccess = this.createRemoteMdibAccess(hostingServiceProxy, mdibAccessObserver);
                GetContextStatesResponse getContextStatesResponse = null;
                if (mdibAccess.getContextStates().isEmpty()) {
                    tempLog.info("No context states found, try to request separately");
                    getContextStatesResponse = this.requestContextStates(hostingServiceProxy);
                }
                try {
                    tempLog.info("Start applying reports");
                    reportProcessor.startApplyingReportsOnMdib(mdibAccess, getContextStatesResponse);
                }
                catch (PreprocessingException | ReportProcessingException e) {
                    throw new PrerequisitesException("Could not start applying reports on remote MDIB access", e);
                }
                tempLog.info("Start watchdog");
                SdcRemoteDeviceWatchdog watchdog = this.watchdogFactory.createSdcRemoteDeviceWatchdog(hostingServiceProxy, subscribeResults, this);
                tempLog.info("Create and run remote device structure");
                SdcRemoteDevice sdcRemoteDevice = this.sdcRemoteDeviceFactory.createSdcRemoteDevice(hostingServiceProxy, mdibAccess, reportProcessor, scoController.orElse(null), watchdog, localizationServiceProxy);
                sdcRemoteDevice.startAsync().awaitRunning();
                tempLog.info("Remote device is running");
                if (this.sdcRemoteDevices.putIfAbsent(hostingServiceProxy.getEndpointReferenceAddress(), sdcRemoteDevice) != null) {
                    throw new PrerequisitesException(String.format("A remote device with EPR address %s was already connected", hostingServiceProxy.getEndpointReferenceAddress()));
                }
                this.eventBus.post((Object)new RemoteDeviceConnectedMessage(sdcRemoteDevice));
                return sdcRemoteDevice;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void checkExistingConnection(HostingServiceProxy hostingServiceProxy) throws PrerequisitesException {
        if (this.sdcRemoteDevices.get(hostingServiceProxy.getEndpointReferenceAddress()) != null) {
            throw new PrerequisitesException(String.format("A remote device with EPR address %s was already connected", hostingServiceProxy.getEndpointReferenceAddress()));
        }
    }

    private ReportProcessor createReportProcessor() {
        return (ReportProcessor)((Object)this.reportProcessorProvider.get());
    }

    private Optional<ScoController> createScoController(HostingServiceProxy hostingServiceProxy) {
        HostedServiceProxy contextServiceProxy = null;
        try {
            contextServiceProxy = this.findHostedServiceProxy(hostingServiceProxy, WsdlConstants.PORT_TYPE_CONTEXT_QNAME);
        }
        catch (PrerequisitesException prerequisitesException) {
            // empty catch block
        }
        HostedServiceProxy setServiceProxy = null;
        try {
            setServiceProxy = this.findHostedServiceProxy(hostingServiceProxy, WsdlConstants.PORT_TYPE_SET_QNAME);
        }
        catch (PrerequisitesException prerequisitesException) {
            // empty catch block
        }
        if (contextServiceProxy == null && setServiceProxy == null) {
            return Optional.empty();
        }
        return Optional.of(this.scoControllerFactory.createScoController(hostingServiceProxy, setServiceProxy, contextServiceProxy));
    }

    private LocalizationServiceProxy createLocalizationServiceProxy(HostingServiceProxy hostingServiceProxy) {
        HostedServiceProxy localizationServiceProxy = null;
        try {
            localizationServiceProxy = this.findHostedServiceProxy(hostingServiceProxy, WsdlConstants.PORT_TYPE_LOCALIZATION_QNAME);
        }
        catch (PrerequisitesException prerequisitesException) {
            // empty catch block
        }
        return this.localizationServiceProxyFactory.createLocalizationServiceProxy(hostingServiceProxy, localizationServiceProxy);
    }

    @Override
    public ListenableFuture<?> disconnect(String eprAddress) {
        SdcRemoteDevice sdcRemoteDevice = this.sdcRemoteDevices.remove(eprAddress);
        if (sdcRemoteDevice != null) {
            if (sdcRemoteDevice.isRunning()) {
                return ((ListeningExecutorService)this.executorService.get()).submit(() -> {
                    sdcRemoteDevice.stopAsync().awaitTerminated();
                    this.eventBus.post((Object)new RemoteDeviceDisconnectedMessage(URI.create(eprAddress)));
                });
            }
        } else {
            this.instanceLogger.info("disconnect() called for unknown epr address {}, device already disconnected?", (Object)eprAddress);
        }
        return Futures.immediateCancelledFuture();
    }

    @Override
    public Collection<SdcRemoteDevice> getConnectedDevices() {
        return new ArrayList<SdcRemoteDevice>(this.sdcRemoteDevices.values());
    }

    @Override
    public Optional<SdcRemoteDevice> getConnectedDevice(String eprAddress) {
        return Optional.ofNullable(this.sdcRemoteDevices.get(eprAddress));
    }

    @Override
    public void registerObserver(SdcRemoteDevicesObserver observer) {
        this.eventBus.register((Object)observer);
    }

    @Override
    public void unregisterObserver(SdcRemoteDevicesObserver observer) {
        this.eventBus.unregister((Object)observer);
    }

    private void checkRequiredServices(HostingServiceProxy hostingServiceProxy, Collection<QName> requiredPortTypes) throws PrerequisitesException {
        LinkedList<QName> nonFoundPortTypes = new LinkedList<QName>(requiredPortTypes);
        hostingServiceProxy.getHostedServices().values().forEach(hostedServiceProxy -> nonFoundPortTypes.removeAll(hostedServiceProxy.getType().getTypes()));
        if (!nonFoundPortTypes.isEmpty()) {
            throw new PrerequisitesException(String.format("Required port types not found: %s", nonFoundPortTypes));
        }
    }

    private Map<String, SubscribeResult> subscribeServices(HostingServiceProxy hostingServiceProxy, Collection<String> actionsToSubscribe, final ReportProcessor reportProcessor, final @Nullable ScoController scoController) throws PrerequisitesException {
        Multimap<String, String> subscriptions = this.getServiceIdWithActionsToSubscribe(hostingServiceProxy, actionsToSubscribe);
        HashMap<String, SubscribeResult> subscribeResults = new HashMap<String, SubscribeResult>(subscriptions.size());
        for (final String serviceId : subscriptions.keySet()) {
            Collection actions = subscriptions.get((Object)serviceId);
            if (actions.isEmpty()) {
                this.instanceLogger.warn("Expect to find at least one action to subscribe for service id {}, but none found", (Object)serviceId);
                continue;
            }
            HostedServiceProxy hostedServiceProxy = (HostedServiceProxy)hostingServiceProxy.getHostedServices().get(serviceId);
            if (hostedServiceProxy == null) {
                this.instanceLogger.warn("Expect to found a hosted service proxy to access for service id {}, but none found", (Object)serviceId);
                continue;
            }
            ListenableFuture subscribeResult = hostedServiceProxy.getEventSinkAccess().subscribe(new ArrayList(actions), this.requestedExpires, new Interceptor(){

                @MessageInterceptor
                void onNotification(NotificationObject notificationObject) {
                    AbstractReport report = (AbstractReport)SdcRemoteDevicesConnectorImpl.this.soapUtil.getBody(notificationObject.getNotification(), AbstractReport.class).orElseThrow(() -> new RuntimeException(String.format("Received unexpected report message from service %s", serviceId)));
                    SdcRemoteDevicesConnectorImpl.this.instanceLogger.debug("Incoming SOAP/HTTP notification: {}", (Object)report);
                    if (report instanceof OperationInvokedReport) {
                        if (scoController != null) {
                            scoController.processOperationInvokedReport((OperationInvokedReport)report);
                        }
                    } else {
                        reportProcessor.processReport(report);
                    }
                }
            });
            try {
                subscribeResults.put(serviceId, (SubscribeResult)subscribeResult.get(this.responseWaitingTime.toSeconds(), TimeUnit.SECONDS));
            }
            catch (TimeoutException e) {
                subscribeResult.cancel(true);
                throw new PrerequisitesException(String.format("Subscribe request towards service with service id %s failed after %ss. Physical target address: %s", serviceId, this.responseWaitingTime.toSeconds(), hostedServiceProxy.getActiveEprAddress()), e);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PrerequisitesException(String.format("Subscribe request towards service with service id %s failed. Physical target address: %s", serviceId, hostedServiceProxy.getActiveEprAddress()), e);
            }
        }
        return subscribeResults;
    }

    private Multimap<String, String> getServiceIdWithActionsToSubscribe(HostingServiceProxy hostingServiceProxy, Collection<String> actionsToSubscribe) {
        ArrayListMultimap subscriptions = ArrayListMultimap.create();
        for (String action : actionsToSubscribe) {
            QName targetPortType = SubscribableActionsMapping.TARGET_QNAMES.get(action);
            if (targetPortType == null) {
                this.instanceLogger.warn("Found an action that could not be mapped to a target port type: {}", (Object)action);
                continue;
            }
            for (HostedServiceProxy hostedServiceProxy : hostingServiceProxy.getHostedServices().values()) {
                if (!hostedServiceProxy.getType().getTypes().contains(targetPortType)) continue;
                subscriptions.put((Object)hostedServiceProxy.getType().getServiceId(), (Object)action);
            }
        }
        return subscriptions;
    }

    private RemoteMdibAccess createRemoteMdibAccess(HostingServiceProxy hostingServiceProxy, @Nullable MdibAccessObserver mdibAccessObserver) throws PrerequisitesException {
        HostedServiceProxy getServiceProxy = this.findHostedServiceProxy(hostingServiceProxy, WsdlConstants.PORT_TYPE_GET_QNAME);
        RemoteMdibAccess mdibAccess = this.remoteMdibAccessFactory.createRemoteMdibAccess();
        if (mdibAccessObserver != null) {
            mdibAccess.registerObserver(mdibAccessObserver);
        }
        try {
            SoapMessage getMdibResponseMessage = getServiceProxy.getRequestResponseClient().sendRequestResponse(this.soapUtil.createMessage("http://standards.ieee.org/downloads/11073/11073-20701-2018/GetService/GetMdib", (Object)this.messageModelFactory.createGetMdib()));
            GetMdibResponse getMdibResponse = (GetMdibResponse)this.soapUtil.getBody(getMdibResponseMessage, GetMdibResponse.class).orElseThrow(() -> new PrerequisitesException("Remote endpoint did not send a GetMdibResponse message in response to " + String.format("a GetMdib to service %s with physical address %s", getServiceProxy.getType().getServiceId(), getServiceProxy.getActiveEprAddress())));
            Mdib mdib = getMdibResponse.getMdib();
            ModificationsBuilder modBuilder = this.modificationsBuilderFactory.createModificationsBuilder(mdib);
            mdibAccess.writeDescription(this.mdibVersionUtil.getMdibVersion((AbstractGetResponse)getMdibResponse), mdib.getMdDescription().getDescriptionVersion(), mdib.getMdState().getStateVersion(), modBuilder.get());
        }
        catch (MarshallingException | SoapFaultException | TransportException | InterceptorException e) {
            throw new PrerequisitesException(String.format("Could not send a GetMdib request to service %s with physical address %s", getServiceProxy.getType().getServiceId(), getServiceProxy.getActiveEprAddress()), e);
        }
        catch (PreprocessingException e) {
            throw new PrerequisitesException("Could not write initial MDIB to remote MDIB access", e);
        }
        return mdibAccess;
    }

    private HostedServiceProxy findHostedServiceProxy(HostingServiceProxy hostingServiceProxy, QName portType) throws PrerequisitesException {
        HostedServiceProxy foundProxy = null;
        for (HostedServiceProxy hostedServiceProxy : hostingServiceProxy.getHostedServices().values()) {
            if (!hostedServiceProxy.getType().getTypes().contains(portType)) continue;
            foundProxy = hostedServiceProxy;
            break;
        }
        if (foundProxy == null) {
            throw new PrerequisitesException(String.format("Service port type %s not found for remote device with UUID %s and physical target address %s", portType, hostingServiceProxy.getEndpointReferenceAddress(), hostingServiceProxy.getActiveXAddr()));
        }
        return foundProxy;
    }

    private GetContextStatesResponse requestContextStates(HostingServiceProxy hostingServiceProxy) throws PrerequisitesException {
        HostedServiceProxy contextServiceProxy = this.findHostedServiceProxy(hostingServiceProxy, WsdlConstants.PORT_TYPE_CONTEXT_QNAME);
        try {
            SoapMessage getContextStatesResponseMessage = contextServiceProxy.getRequestResponseClient().sendRequestResponse(this.soapUtil.createMessage("http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/GetContextStates", (Object)this.messageModelFactory.createGetContextStates()));
            return (GetContextStatesResponse)this.soapUtil.getBody(getContextStatesResponseMessage, GetContextStatesResponse.class).orElseThrow(() -> new PrerequisitesException("Remote endpoint did not send a GetContextStatesResponse message in response to " + String.format("a GetContextStates to service %s with physical address %s", contextServiceProxy.getType().getServiceId(), contextServiceProxy.getActiveEprAddress())));
        }
        catch (MarshallingException | SoapFaultException | TransportException | InterceptorException e) {
            throw new PrerequisitesException(String.format("Could not send a GetContextStates request to service %s with physical address %s", contextServiceProxy.getType().getServiceId(), contextServiceProxy.getActiveEprAddress()), e);
        }
    }

    @Subscribe
    void onConnectionLoss(WatchdogMessage watchdogMessage) {
        this.instanceLogger.info("Lost connection to device {}. Reason: {}", watchdogMessage.getPayload(), (Object)watchdogMessage.getReason().getMessage());
        this.disconnect((String)watchdogMessage.getPayload());
    }

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
        this.instanceLogger.info("Shutting down, disconnecting all devices");
        List.copyOf(this.sdcRemoteDevices.keySet()).forEach(this::disconnect);
    }
}

