/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer.report.helper;

import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.somda.sdc.biceps.common.MdibDescriptionModification;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.MdibStateModifications;
import org.somda.sdc.biceps.common.MdibTypeValidator;
import org.somda.sdc.biceps.common.storage.PreprocessingException;
import org.somda.sdc.biceps.consumer.access.RemoteMdibAccess;
import org.somda.sdc.biceps.model.message.AbstractAlertReport;
import org.somda.sdc.biceps.model.message.AbstractComponentReport;
import org.somda.sdc.biceps.model.message.AbstractContextReport;
import org.somda.sdc.biceps.model.message.AbstractMetricReport;
import org.somda.sdc.biceps.model.message.AbstractOperationalStateReport;
import org.somda.sdc.biceps.model.message.AbstractReport;
import org.somda.sdc.biceps.model.message.DescriptionModificationReport;
import org.somda.sdc.biceps.model.message.DescriptionModificationType;
import org.somda.sdc.biceps.model.message.WaveformStream;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractMultiState;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.glue.common.MdibVersionUtil;
import org.somda.sdc.glue.consumer.report.ReportProcessingException;

public class ReportWriter {
    private final MdibTypeValidator typeValidator;
    private final MdibVersionUtil mdibVersionUtil;

    @Inject
    ReportWriter(MdibTypeValidator typeValidator, MdibVersionUtil mdibVersionUtil) {
        this.typeValidator = typeValidator;
        this.mdibVersionUtil = mdibVersionUtil;
    }

    public void write(AbstractReport report, RemoteMdibAccess mdibAccess) throws ReportProcessingException, PreprocessingException {
        if (report instanceof WaveformStream) {
            this.write(report, this.makeModifications((WaveformStream)report), mdibAccess);
        } else if (report instanceof AbstractMetricReport) {
            this.write(report, this.makeModifications((AbstractMetricReport)report), mdibAccess);
        } else if (report instanceof AbstractAlertReport) {
            this.write(report, this.makeModifications((AbstractAlertReport)report), mdibAccess);
        } else if (report instanceof AbstractOperationalStateReport) {
            this.write(report, this.makeModifications((AbstractOperationalStateReport)report), mdibAccess);
        } else if (report instanceof AbstractComponentReport) {
            this.write(report, this.makeModifications((AbstractComponentReport)report), mdibAccess);
        } else if (report instanceof AbstractContextReport) {
            this.write(report, this.makeModifications((AbstractContextReport)report), mdibAccess);
        } else if (report instanceof DescriptionModificationReport) {
            this.write((DescriptionModificationReport)report, mdibAccess);
        } else {
            throw new ReportProcessingException(String.format("Unexpected report type: %s", report.getClass().getSimpleName()));
        }
    }

    private void write(AbstractReport report, MdibStateModifications modifications, RemoteMdibAccess mdibAccess) throws PreprocessingException {
        mdibAccess.writeStates(this.mdibVersionUtil.getMdibVersion(report), modifications);
    }

    private void write(DescriptionModificationReport report, RemoteMdibAccess mdibAccess) throws ReportProcessingException, PreprocessingException {
        mdibAccess.writeDescription(this.mdibVersionUtil.getMdibVersion((AbstractReport)report), null, null, this.mdibDescriptionModifications(report));
    }

    private MdibDescriptionModifications mdibDescriptionModifications(DescriptionModificationReport report) throws ReportProcessingException {
        MdibDescriptionModifications modifications = MdibDescriptionModifications.create();
        for (DescriptionModificationReport.ReportPart reportPart : report.getReportPart()) {
            MdibDescriptionModification.Type modType = ReportWriter.mapModType(reportPart.getModificationType());
            ArrayListMultimap stateMap = ArrayListMultimap.create((int)reportPart.getState().size(), (int)1);
            reportPart.getState().forEach(state -> stateMap.put((Object)state.getDescriptorHandle(), state));
            Set stateHandles = reportPart.getState().stream().map(AbstractState::getDescriptorHandle).collect(Collectors.toSet());
            Set descriptorHandles = reportPart.getDescriptor().stream().map(AbstractDescriptor::getHandle).collect(Collectors.toSet());
            for (String handle : stateHandles) {
                if (descriptorHandles.contains(handle)) continue;
                throw new ReportProcessingException(String.format("The state %s belongs to an unknown descriptor", handle));
            }
            for (AbstractDescriptor descriptor : reportPart.getDescriptor()) {
                List stateList = stateMap.get((Object)descriptor.getHandle());
                if (modType != MdibDescriptionModification.Type.DELETE) {
                    if (this.typeValidator.isSingleStateDescriptor(descriptor)) {
                        if (stateList.size() != 1) {
                            throw new ReportProcessingException(String.format("Change of single state descriptor %s comes with unexpected number of states: %s", descriptor.getHandle(), stateList.size()));
                        }
                        modifications.add(modType, descriptor, (AbstractState)stateList.get(0), reportPart.getParentDescriptor());
                        continue;
                    }
                    try {
                        ArrayList multiStates = new ArrayList(stateList.size());
                        stateList.forEach(state -> {
                            if (!(state instanceof AbstractMultiState)) {
                                throw new RuntimeException(String.format("Data type mismatch. Expected an AbstractMultiState, got %s", state.getClass().getName()));
                            }
                            multiStates.add((AbstractMultiState)state);
                        });
                        modifications.add(modType, descriptor, multiStates, reportPart.getParentDescriptor());
                        continue;
                    }
                    catch (Exception e) {
                        throw new ReportProcessingException(String.format("Type mismatch between descriptor %s and state", descriptor.getHandle()));
                    }
                }
                modifications.add(modType, descriptor, reportPart.getParentDescriptor());
            }
        }
        return modifications;
    }

    private MdibStateModifications makeModifications(WaveformStream report) {
        return MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.WAVEFORM, (int)report.getState().size()).addAll((Collection)report.getState());
    }

    private MdibStateModifications makeModifications(AbstractMetricReport report) {
        int capacity = report.getReportPart().stream().mapToInt(rp -> rp.getMetricState().size()).sum();
        MdibStateModifications modifications = MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.METRIC, (int)capacity);
        for (AbstractMetricReport.ReportPart reportPart : report.getReportPart()) {
            modifications.addAll((Collection)reportPart.getMetricState());
        }
        return modifications;
    }

    private MdibStateModifications makeModifications(AbstractAlertReport report) {
        int capacity = report.getReportPart().stream().mapToInt(rp -> rp.getAlertState().size()).sum();
        MdibStateModifications modifications = MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.ALERT, (int)capacity);
        for (AbstractAlertReport.ReportPart reportPart : report.getReportPart()) {
            modifications.addAll((Collection)reportPart.getAlertState());
        }
        return modifications;
    }

    private MdibStateModifications makeModifications(AbstractComponentReport report) {
        int capacity = report.getReportPart().stream().mapToInt(rp -> rp.getComponentState().size()).sum();
        MdibStateModifications modifications = MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.COMPONENT, (int)capacity);
        for (AbstractComponentReport.ReportPart reportPart : report.getReportPart()) {
            modifications.addAll((Collection)reportPart.getComponentState());
        }
        return modifications;
    }

    private MdibStateModifications makeModifications(AbstractContextReport report) {
        int capacity = report.getReportPart().stream().mapToInt(rp -> rp.getContextState().size()).sum();
        MdibStateModifications modifications = MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.CONTEXT, (int)capacity);
        for (AbstractContextReport.ReportPart reportPart : report.getReportPart()) {
            modifications.addAll((Collection)reportPart.getContextState());
        }
        return modifications;
    }

    private MdibStateModifications makeModifications(AbstractOperationalStateReport report) {
        int capacity = report.getReportPart().stream().mapToInt(rp -> rp.getOperationState().size()).sum();
        MdibStateModifications modifications = MdibStateModifications.create((MdibStateModifications.Type)MdibStateModifications.Type.OPERATION, (int)capacity);
        for (AbstractOperationalStateReport.ReportPart reportPart : report.getReportPart()) {
            modifications.addAll((Collection)reportPart.getOperationState());
        }
        return modifications;
    }

    private static MdibDescriptionModification.Type mapModType(@Nullable DescriptionModificationType modificationType) {
        if (modificationType == null) {
            return MdibDescriptionModification.Type.UPDATE;
        }
        switch (modificationType) {
            case CRT: {
                return MdibDescriptionModification.Type.INSERT;
            }
            case UPT: {
                return MdibDescriptionModification.Type.UPDATE;
            }
            case DEL: {
                return MdibDescriptionModification.Type.DELETE;
            }
        }
        throw new RuntimeException(String.format("Unexpected description modification type detected. Processing branch is missing: %s", modificationType));
    }
}

