/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.provider;

import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.MdibVersion;
import org.somda.sdc.biceps.provider.access.LocalMdibAccess;
import org.somda.sdc.dpws.DpwsConstants;
import org.somda.sdc.dpws.device.Device;
import org.somda.sdc.dpws.device.DeviceSettings;
import org.somda.sdc.dpws.device.DiscoveryAccess;
import org.somda.sdc.dpws.device.EventSourceAccess;
import org.somda.sdc.dpws.device.HostingServiceAccess;
import org.somda.sdc.dpws.device.WebService;
import org.somda.sdc.dpws.device.factory.DeviceFactory;
import org.somda.sdc.dpws.service.factory.HostedServiceFactory;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.wseventing.SubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.model.WsEventingStatus;
import org.somda.sdc.glue.GlueConstants;
import org.somda.sdc.glue.provider.SdcDeviceContext;
import org.somda.sdc.glue.provider.SdcDevicePlugin;
import org.somda.sdc.glue.provider.helper.SdcDevicePluginProcessor;
import org.somda.sdc.glue.provider.localization.LocalizationStorage;
import org.somda.sdc.glue.provider.plugin.SdcRequiredTypesAndScopes;
import org.somda.sdc.glue.provider.sco.OperationInvocationReceiver;
import org.somda.sdc.glue.provider.services.HighPriorityServices;
import org.somda.sdc.glue.provider.services.LowPriorityServices;
import org.somda.sdc.glue.provider.services.factory.ServicesFactory;
import org.somda.sdc.mdpws.common.CommonConstants;

public class SdcDevice
extends AbstractIdleService
implements Device,
EventSourceAccess,
SdcDeviceContext {
    private final Device dpwsDevice;
    private final HostedServiceFactory hostedServiceFactory;
    private final HighPriorityServices highPriorityServices;
    private final Collection<OperationInvocationReceiver> operationInvocationReceivers;
    private final LocalMdibAccess mdibAccess;
    private final SdcDevicePluginProcessor pluginProcessor;
    private final LowPriorityServices lowPriorityServices;
    private final LocalizationStorage localizationStorage;

    @AssistedInject
    SdcDevice(@Assisted DeviceSettings deviceSettings, @Assisted LocalMdibAccess mdibAccess, @Assisted(value="operationInvocationReceivers") Collection<OperationInvocationReceiver> operationInvocationReceivers, @Assisted(value="plugins") Collection<SdcDevicePlugin> plugins, Provider<SdcRequiredTypesAndScopes> sdcRequiredTypesAndScopesProvider, DeviceFactory deviceFactory, ServicesFactory servicesFactory, HostedServiceFactory hostedServiceFactory) {
        this(deviceSettings, mdibAccess, operationInvocationReceivers, plugins, null, sdcRequiredTypesAndScopesProvider, deviceFactory, servicesFactory, hostedServiceFactory);
    }

    @AssistedInject
    SdcDevice(@Assisted DeviceSettings deviceSettings, @Assisted LocalMdibAccess mdibAccess, @Assisted(value="operationInvocationReceivers") Collection<OperationInvocationReceiver> operationInvocationReceivers, @Assisted(value="plugins") Collection<SdcDevicePlugin> plugins, @Assisted @Nullable LocalizationStorage localizationStorage, Provider<SdcRequiredTypesAndScopes> sdcRequiredTypesAndScopesProvider, DeviceFactory deviceFactory, ServicesFactory servicesFactory, HostedServiceFactory hostedServiceFactory) {
        Collection<SdcDevicePlugin> copyPlugins = plugins;
        if (copyPlugins.isEmpty()) {
            copyPlugins = Collections.singleton((SdcDevicePlugin)sdcRequiredTypesAndScopesProvider.get());
        }
        this.mdibAccess = mdibAccess;
        this.dpwsDevice = deviceFactory.createDevice(deviceSettings);
        this.highPriorityServices = servicesFactory.createHighPriorityServices(mdibAccess);
        this.lowPriorityServices = servicesFactory.createLowPriorityServices(mdibAccess, localizationStorage);
        this.hostedServiceFactory = hostedServiceFactory;
        this.operationInvocationReceivers = operationInvocationReceivers;
        this.pluginProcessor = new SdcDevicePluginProcessor(copyPlugins, this);
        this.localizationStorage = localizationStorage;
    }

    public LocalMdibAccess getMdibAccess() {
        return this.mdibAccess;
    }

    public String getEprAddress() {
        return this.dpwsDevice.getEprAddress();
    }

    public Map<String, SubscriptionManager> getActiveSubscriptions() {
        return this.dpwsDevice.getActiveSubscriptions();
    }

    @Override
    public Device getDevice() {
        return this.dpwsDevice;
    }

    @Override
    public LocalMdibAccess getLocalMdibAccess() {
        return this.mdibAccess;
    }

    @Override
    public Collection<OperationInvocationReceiver> getOperationInvocationReceivers() {
        return this.operationInvocationReceivers;
    }

    @Override
    public Service.State getServiceState() {
        return this.state();
    }

    @Override
    public <T extends AbstractState> void sendPeriodicStateReport(Map<String, List<T>> states, MdibVersion mdibVersion) {
        this.highPriorityServices.sendPeriodicStateReport(states, mdibVersion);
    }

    public DiscoveryAccess getDiscoveryAccess() {
        return new DiscoveryAccess(){

            public void setTypes(Collection<QName> types) {
                ArrayList<QName> tmpTypes = new ArrayList<QName>();
                if (types.stream().filter(qName -> qName.equals(CommonConstants.MEDICAL_DEVICE_TYPE)).findAny().isEmpty()) {
                    tmpTypes.add(DpwsConstants.DEVICE_TYPE);
                }
                tmpTypes.addAll(types);
                SdcDevice.this.dpwsDevice.getDiscoveryAccess().setTypes(tmpTypes);
            }

            public void setScopes(Collection<String> scopes) {
                ArrayList<String> tmpScopes = new ArrayList<String>();
                if (scopes.stream().filter(scope -> scope.equals(GlueConstants.SCOPE_SDC_PROVIDER)).findAny().isEmpty()) {
                    tmpScopes.add(GlueConstants.SCOPE_SDC_PROVIDER);
                }
                tmpScopes.addAll(scopes);
                SdcDevice.this.dpwsDevice.getDiscoveryAccess().setScopes(tmpScopes);
            }

            public void sendHello() {
                SdcDevice.this.dpwsDevice.getDiscoveryAccess().sendHello();
            }
        };
    }

    public HostingServiceAccess getHostingServiceAccess() {
        return this.dpwsDevice.getHostingServiceAccess();
    }

    protected void startUp() throws Exception {
        this.setupInvocationReceivers();
        this.setupHostedServices();
        this.pluginProcessor.beforeStartUp();
        this.dpwsDevice.startAsync().awaitRunning();
        this.pluginProcessor.afterStartUp();
    }

    protected void shutDown() {
        this.pluginProcessor.beforeShutDown();
        this.mdibAccess.unregisterAllObservers();
        this.dpwsDevice.stopAsync().awaitTerminated();
        this.pluginProcessor.afterShutDown();
    }

    private void setupHostedServices() throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream highPrioWsdlStream = classLoader.getResourceAsStream("wsdl/IEEE11073-20701-HighPriority-Services.wsdl");
        assert (highPrioWsdlStream != null);
        this.dpwsDevice.getHostingServiceAccess().addHostedService(this.hostedServiceFactory.createHostedService("HighPriorityServices", Arrays.asList(new QName("http://standards.ieee.org/downloads/11073/11073-20701-2018", "GetService"), new QName("http://standards.ieee.org/downloads/11073/11073-20701-2018", "SetService"), new QName("http://standards.ieee.org/downloads/11073/11073-20701-2018", "ContainmentTreeService"), new QName("http://standards.ieee.org/downloads/11073/11073-20701-2018", "ContextService"), new QName("http://standards.ieee.org/downloads/11073/11073-20701-2018", "DescriptionEventService"), new QName("http://standards.ieee.org/downloads/11073/11073-20701-2018", "StateEventService"), new QName("http://standards.ieee.org/downloads/11073/11073-20701-2018", "WaveformService")), (WebService)this.highPriorityServices, ByteStreams.toByteArray((InputStream)highPrioWsdlStream)));
        InputStream lowPrioWsdlStream = classLoader.getResourceAsStream("wsdl/IEEE11073-20701-LowPriority-Services.wsdl");
        if (lowPrioWsdlStream != null) {
            this.dpwsDevice.getHostingServiceAccess().addHostedService(this.hostedServiceFactory.createHostedService("LowPriorityServices", this.getQNames(), (WebService)this.lowPriorityServices, ByteStreams.toByteArray((InputStream)lowPrioWsdlStream)));
        }
    }

    private void addOperationInvocationReceiver(OperationInvocationReceiver receiver) {
        this.highPriorityServices.addOperationInvocationReceiver(receiver);
    }

    private void setupInvocationReceivers() {
        this.operationInvocationReceivers.forEach(this::addOperationInvocationReceiver);
    }

    private List<QName> getQNames() {
        ArrayList<QName> qNames = new ArrayList<QName>();
        if (this.localizationStorage != null) {
            qNames.add(new QName("http://standards.ieee.org/downloads/11073/11073-20701-2018", "LocalizationService"));
        }
        return qNames;
    }

    public void sendNotification(String action, Object payload) throws MarshallingException, TransportException {
        this.highPriorityServices.sendNotification(action, payload);
    }

    public void subscriptionEndToAll(WsEventingStatus status) throws TransportException {
        this.highPriorityServices.subscriptionEndToAll(status);
    }
}

