/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.provider.sco;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.model.message.InvocationError;
import org.somda.sdc.biceps.model.message.InvocationState;
import org.somda.sdc.biceps.model.participant.InstanceIdentifier;
import org.somda.sdc.biceps.model.participant.LocalizedText;
import org.somda.sdc.biceps.model.participant.ObjectFactory;
import org.somda.sdc.biceps.provider.access.LocalMdibAccess;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.device.EventSourceAccess;
import org.somda.sdc.glue.provider.sco.Context;
import org.somda.sdc.glue.provider.sco.IncomingSetServiceRequest;
import org.somda.sdc.glue.provider.sco.InvocationResponse;
import org.somda.sdc.glue.provider.sco.OperationInvocationReceiver;
import org.somda.sdc.glue.provider.sco.factory.ContextFactory;

public class ScoController {
    private static final Logger LOG = LogManager.getLogger(ScoController.class);
    private final Map<String, ReflectionInfo> invocationReceivers;
    private final List<ReflectionInfo> defaultInvocationReceivers;
    private final EventSourceAccess eventSourceAccess;
    private final LocalMdibAccess mdibAccess;
    private final ContextFactory contextFactory;
    private final ObjectFactory participantModelFactory;
    private final Logger instanceLogger;
    private long transactionCounter;

    @AssistedInject
    ScoController(@Assisted EventSourceAccess eventSourceAccess, @Assisted LocalMdibAccess mdibAccess, ContextFactory contextFactory, ObjectFactory participantModelFactory, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.eventSourceAccess = eventSourceAccess;
        this.mdibAccess = mdibAccess;
        this.contextFactory = contextFactory;
        this.participantModelFactory = participantModelFactory;
        this.invocationReceivers = new HashMap<String, ReflectionInfo>();
        this.defaultInvocationReceivers = new ArrayList<ReflectionInfo>();
        this.transactionCounter = 0L;
    }

    public <T> InvocationResponse processIncomingSetOperation(String handle, InstanceIdentifier source, T payload) {
        Context context = this.contextFactory.createContext(this.transactionCounter++, handle, source, this.eventSourceAccess, this.mdibAccess);
        try {
            ArrayList<ReflectionInfo> thisCallReceivers = new ArrayList<ReflectionInfo>(this.defaultInvocationReceivers.size() + 1);
            thisCallReceivers.add(this.invocationReceivers.get(handle));
            thisCallReceivers.addAll(this.defaultInvocationReceivers);
            for (ReflectionInfo receiver : thisCallReceivers) {
                if (receiver == null || !receiver.getCallbackMethod().getParameters()[1].getType().isAssignableFrom(payload.getClass())) continue;
                return (InvocationResponse)receiver.getCallbackMethod().invoke((Object)receiver.getReceiver(), context, payload);
            }
        }
        catch (Exception e) {
            String errorMessage = String.format("Invocation of operation with handle '%s' failed: %s", handle, e.getMessage());
            this.instanceLogger.warn(errorMessage);
            this.instanceLogger.trace(errorMessage, (Throwable)e);
            return this.additionallySendResponseAsReport(context, context.createUnsuccessfulResponse(this.mdibAccess.getMdibVersion(), InvocationState.FAIL, InvocationError.UNSPEC, Collections.singletonList(this.createLocalizedText(errorMessage))));
        }
        return this.additionallySendResponseAsReport(context, context.createUnsuccessfulResponse(this.mdibAccess.getMdibVersion(), InvocationState.FAIL, InvocationError.UNSPEC, Collections.singletonList(this.createLocalizedText(String.format("A handler for the operation with handle '%s' could not be found", handle)))));
    }

    private LocalizedText createLocalizedText(String text) {
        LocalizedText localizedText = this.participantModelFactory.createLocalizedText();
        localizedText.setLang("en");
        localizedText.setValue(text);
        return localizedText;
    }

    private InvocationResponse additionallySendResponseAsReport(Context context, InvocationResponse response) {
        context.sendReport(response.getMdibVersion(), response.getInvocationState(), response.getInvocationError(), response.getInvocationErrorMessage(), null);
        return response;
    }

    public void addOperationInvocationReceiver(OperationInvocationReceiver receiver) {
        boolean annotationFound = false;
        for (Method method : receiver.getClass().getDeclaredMethods()) {
            Parameter[] parameters;
            IncomingSetServiceRequest annotation = method.getDeclaredAnnotation(IncomingSetServiceRequest.class);
            if (annotation == null || method.getReturnType() == null || !method.getReturnType().equals(InvocationResponse.class) || method.getParameterCount() != 2 || !(parameters = method.getParameters())[0].getType().equals(Context.class)) continue;
            String key = annotation.operationHandle();
            if (!key.isEmpty() && this.invocationReceivers.containsKey(key)) {
                this.instanceLogger.warn("Ignore callback registration for key {} as there is a receiver already", (Object)key);
                continue;
            }
            method.setAccessible(true);
            ReflectionInfo reflectionInfo = new ReflectionInfo(receiver, method, annotation);
            if (key.isEmpty()) {
                this.defaultInvocationReceivers.add(reflectionInfo);
            } else {
                this.invocationReceivers.put(key, reflectionInfo);
            }
            annotationFound = true;
        }
        if (!annotationFound) {
            this.instanceLogger.warn("No callback function found in object {} of type {}", (Object)receiver, (Object)receiver.getClass().getName());
        }
    }

    private static class ReflectionInfo {
        private final OperationInvocationReceiver receiver;
        private final Method callbackMethod;
        private final IncomingSetServiceRequest annotation;

        public ReflectionInfo(OperationInvocationReceiver receiver, Method callbackMethod, IncomingSetServiceRequest annotation) {
            this.receiver = receiver;
            this.callbackMethod = callbackMethod;
            this.annotation = annotation;
        }

        public OperationInvocationReceiver getReceiver() {
            return this.receiver;
        }

        public Method getCallbackMethod() {
            return this.callbackMethod;
        }

        public IncomingSetServiceRequest getAnnotation() {
            return this.annotation;
        }
    }
}

