/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.provider.services;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.List;
import javax.annotation.Nullable;
import org.somda.sdc.biceps.model.message.GetLocalizedText;
import org.somda.sdc.biceps.model.message.GetLocalizedTextResponse;
import org.somda.sdc.biceps.model.message.GetSupportedLanguagesResponse;
import org.somda.sdc.biceps.model.message.ObjectFactory;
import org.somda.sdc.biceps.model.participant.LocalizedText;
import org.somda.sdc.biceps.model.participant.MdibVersion;
import org.somda.sdc.biceps.provider.access.LocalMdibAccess;
import org.somda.sdc.dpws.device.WebService;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.factory.SoapFaultFactory;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.glue.common.ActionConstants;
import org.somda.sdc.glue.common.MdibVersionUtil;
import org.somda.sdc.glue.provider.localization.LocalizationService;
import org.somda.sdc.glue.provider.localization.LocalizationStorage;
import org.somda.sdc.glue.provider.localization.factory.LocalizationServiceFactory;

public class LowPriorityServices
extends WebService {
    private final LocalMdibAccess mdibAccess;
    private final SoapUtil soapUtil;
    private final SoapFaultFactory faultFactory;
    private final ObjectFactory messageModelFactory;
    private final MdibVersionUtil mdibVersionUtil;
    private final WsAddressingUtil wsaUtil;
    private LocalizationService localizationService;

    @AssistedInject
    LowPriorityServices(@Assisted LocalMdibAccess mdibAccess, @Assisted @Nullable LocalizationStorage localizationStorage, SoapUtil soapUtil, SoapFaultFactory faultFactory, ObjectFactory messageModelFactory, MdibVersionUtil mdibVersionUtil, WsAddressingUtil wsaUtil, LocalizationServiceFactory localizationServiceFactory) {
        this.mdibAccess = mdibAccess;
        this.soapUtil = soapUtil;
        this.faultFactory = faultFactory;
        this.messageModelFactory = messageModelFactory;
        this.mdibVersionUtil = mdibVersionUtil;
        this.wsaUtil = wsaUtil;
        if (localizationStorage != null) {
            this.localizationService = localizationServiceFactory.createLocalizationService(localizationStorage);
            this.localizationService.startAsync().awaitRunning();
        }
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/LocalizationService/GetLocalizedText")
    void getLocalizedText(RequestResponseObject requestResponseObject) throws SoapFaultException {
        GetLocalizedText getLocalizedText = this.getRequest(requestResponseObject, GetLocalizedText.class);
        GetLocalizedTextResponse getLocalizedTextResponse = this.messageModelFactory.createGetLocalizedTextResponse();
        getLocalizedTextResponse.setText(this.fetchTexts(getLocalizedText));
        this.setResponse(requestResponseObject, getLocalizedTextResponse, this.mdibAccess.getMdibVersion(), ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/LocalizationService/GetLocalizedText"));
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/LocalizationService/GetSupportedLanguages")
    void getSupportedLanguages(RequestResponseObject requestResponseObject) throws SoapFaultException {
        GetSupportedLanguagesResponse getSupportedLanguagesResponse = this.messageModelFactory.createGetSupportedLanguagesResponse();
        getSupportedLanguagesResponse.setLang(this.localizationService.getSupportedLanguages());
        this.setResponse(requestResponseObject, getSupportedLanguagesResponse, this.mdibAccess.getMdibVersion(), ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/LocalizationService/GetSupportedLanguages"));
    }

    private <T> T getRequest(RequestResponseObject requestResponseObject, Class<T> bodyType) throws SoapFaultException {
        return this.soapUtil.getBody(requestResponseObject.getRequest(), bodyType).orElseThrow(() -> new SoapFaultException(this.faultFactory.createSenderFault(String.format("%s SOAP request body is malformed", bodyType.getSimpleName())), (AttributedURIType)requestResponseObject.getRequest().getWsAddressingHeader().getMessageId().orElse(null)));
    }

    private <T> void setResponse(RequestResponseObject requestResponseObject, T response, MdibVersion mdibVersion, String responseAction) throws SoapFaultException {
        try {
            this.mdibVersionUtil.setMdibVersion(mdibVersion, response);
        }
        catch (Exception e) {
            throw new SoapFaultException(this.faultFactory.createReceiverFault("Could not create MDIB version."), (AttributedURIType)requestResponseObject.getRequest().getWsAddressingHeader().getMessageId().orElse(null));
        }
        requestResponseObject.getResponse().getWsAddressingHeader().setAction(this.wsaUtil.createAttributedURIType(responseAction));
        this.soapUtil.setBody(response, requestResponseObject.getResponse());
    }

    private List<LocalizedText> fetchTexts(GetLocalizedText getLocalizedText) {
        return this.localizationService.getLocalizedText(getLocalizedText.getRef(), getLocalizedText.getVersion(), getLocalizedText.getLang(), getLocalizedText.getTextWidth(), getLocalizedText.getNumberOfLines());
    }
}

