/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.common;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jaxb.runtime.marshaller.NamespacePrefixMapper;
import org.somda.sdc.biceps.model.message.GetMdibResponse;
import org.somda.sdc.biceps.model.message.ObjectFactory;
import org.somda.sdc.biceps.model.participant.Mdib;
import org.somda.sdc.biceps.model.participant.MdibVersion;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.NamespacePrefixMapperConverter;
import org.somda.sdc.common.util.PrefixNamespaceMappingParser;
import org.somda.sdc.glue.common.MdibVersionUtil;

public class MdibXmlIo {
    private static final Logger LOG = LogManager.getLogger(MdibXmlIo.class);
    private final ObjectFactory messageModelFactory;
    private final MdibVersionUtil mdibVersionUtil;
    private final NamespacePrefixMapper namespacePrefixMapper;
    private final Logger instanceLogger;
    private JAXBContext jaxbContext;

    @Inject
    MdibXmlIo(ObjectFactory messageModelFactory, MdibVersionUtil mdibVersionUtil, PrefixNamespaceMappingParser prefixNamespaceMappingParser, NamespacePrefixMapperConverter namespacePrefixMapperConverter, @Named(value="SdcGlue.NamespaceMappings") String namespaceMappings, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.messageModelFactory = messageModelFactory;
        this.mdibVersionUtil = mdibVersionUtil;
        String namespaceMappingsExtended = namespaceMappings + "{ext:http://standards.ieee.org/downloads/11073/11073-10207-2017/extension}{pm:http://standards.ieee.org/downloads/11073/11073-10207-2017/participant}{msg:http://standards.ieee.org/downloads/11073/11073-10207-2017/message}{sdc:http://standards.ieee.org/downloads/11073/11073-20701-2018}{xsi:http://www.w3.org/2001/XMLSchema-instance}";
        this.namespacePrefixMapper = namespacePrefixMapperConverter.convert(prefixNamespaceMappingParser.parse(namespaceMappingsExtended));
        this.initJaxb();
    }

    public Mdib readMdib(InputStream getMdibResponseStream) throws JAXBException, ClassCastException {
        return ((GetMdibResponse)this.jaxbContext.createUnmarshaller().unmarshal(getMdibResponseStream)).getMdib();
    }

    public Mdib readMdib(File getMdibResponseFile) throws JAXBException, ClassCastException, IOException {
        try (FileInputStream fis = new FileInputStream(getMdibResponseFile);){
            Mdib mdib = this.readMdib(fis);
            return mdib;
        }
    }

    public void writeMdib(Mdib mdib, OutputStream outputStream) throws JAXBException {
        GetMdibResponse getMdibResponse = this.messageModelFactory.createGetMdibResponse();
        try {
            this.mdibVersionUtil.setMdibVersion(MdibVersion.create(), getMdibResponse);
        }
        catch (Exception e) {
            this.instanceLogger.warn("Unexpected error during setMdibVersion on a GetMdibResponseObject. Nothing was written to the output stream", (Throwable)e);
            return;
        }
        getMdibResponse.setMdib(mdib);
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("org.glassfish.jaxb.namespacePrefixMapper", (Object)this.namespacePrefixMapper);
        marshaller.marshal((Object)getMdibResponse, outputStream);
    }

    public void writeMdib(Mdib mdib, File outputFile) throws JAXBException, IOException {
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            this.writeMdib(mdib, fos);
        }
    }

    private void initJaxb() {
        this.instanceLogger.info("Setup an MDIB XML reader with JAXB contexts: {}", (Object)"org.somda.sdc.biceps.model.extension:org.somda.sdc.biceps.model.participant:org.somda.sdc.biceps.model.message");
        try {
            this.jaxbContext = JAXBContext.newInstance((String)"org.somda.sdc.biceps.model.extension:org.somda.sdc.biceps.model.participant:org.somda.sdc.biceps.model.message");
        }
        catch (JAXBException e) {
            throw new RuntimeException(String.format("JAXB context for '%s' could not be set up", "org.somda.sdc.biceps.model.extension:org.somda.sdc.biceps.model.participant:org.somda.sdc.biceps.model.message"), e);
        }
    }
}

