/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.common.uri;

import jregex.Matcher;
import jregex.Pattern;
import org.somda.sdc.biceps.model.participant.AbstractContextState;
import org.somda.sdc.biceps.model.participant.EnsembleContextState;
import org.somda.sdc.biceps.model.participant.InstanceIdentifier;
import org.somda.sdc.biceps.model.participant.LocationContextState;
import org.somda.sdc.biceps.model.participant.MeansContextState;
import org.somda.sdc.biceps.model.participant.OperatorContextState;
import org.somda.sdc.biceps.model.participant.PatientContextState;
import org.somda.sdc.biceps.model.participant.WorkflowContextState;
import org.somda.sdc.glue.GlueConstants;
import org.somda.sdc.glue.common.helper.UrlUtf8;
import org.somda.sdc.glue.common.uri.UriMapperGenerationArgumentException;
import org.somda.sdc.glue.common.uri.UriMapperParsingException;

public class ContextIdentificationMapper {
    private static final String NULL_FLAVOR_ROOT = "biceps.uri.unk";
    private static final String SCHEME_PREFIX = "sdc.ctxt.";
    private static final Pattern URI_PATTERN = new Pattern(GlueConstants.URI_REGEX);
    private static final Pattern INSTANCE_IDENTIFIER_PATTERN = new Pattern("/({root}(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$&'()*+,;=:@])+)+)/({extension}(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$&'()*+,;=:@])+)*)$");
    private static final Pattern SCHEME_VALIDATOR = new Pattern("^(?i:[a-z][a-z0-9+-.]*)$");

    public static String fromInstanceIdentifier(InstanceIdentifier instanceIdentifier, ContextSource contextSource) throws UriMapperGenerationArgumentException {
        String root = instanceIdentifier.getRootName() == null ? NULL_FLAVOR_ROOT : UrlUtf8.encodePChars(instanceIdentifier.getRootName());
        String extension = UrlUtf8.encodePChars(instanceIdentifier.getExtensionName());
        String resultingUri = contextSource.getSourceString() + ":/" + root + "/" + extension;
        try {
            ContextIdentificationMapper.fromUri(resultingUri, contextSource);
        }
        catch (UriMapperParsingException e) {
            throw new UriMapperGenerationArgumentException("No valid URI could be generated from the given instance identifier: " + instanceIdentifier + " and context source: " + contextSource);
        }
        return resultingUri;
    }

    public static InstanceIdentifier fromUri(String contextIdentificationUri, ContextSource expectedContextSource) throws UriMapperParsingException {
        Matcher expectedSourceMatcher = SCHEME_VALIDATOR.matcher(expectedContextSource.getSourceString());
        if (!expectedSourceMatcher.matches()) {
            throw new UriMapperParsingException("The expected context source: '" + expectedContextSource.getSourceString() + " is not valid");
        }
        Matcher uriMatcher = URI_PATTERN.matcher(contextIdentificationUri);
        if (uriMatcher.matches()) {
            String contextSource = uriMatcher.group("scheme");
            if (!expectedContextSource.getSourceString().equals(contextSource)) {
                throw new UriMapperParsingException("The expected context source: '" + expectedContextSource.getSourceString() + "' does not match with the actual context source: '" + contextSource + "'" + ContextIdentificationMapper.class);
            }
            Matcher instanceIdentifierMatcher = INSTANCE_IDENTIFIER_PATTERN.matcher(uriMatcher.group("path"));
            if (instanceIdentifierMatcher.matches()) {
                String root = instanceIdentifierMatcher.group("root");
                String extension = instanceIdentifierMatcher.group("extension");
                InstanceIdentifier instanceIdentifier = new InstanceIdentifier();
                String decodedRoot = UrlUtf8.decodePChars(root);
                instanceIdentifier.setRootName(decodedRoot.equals(NULL_FLAVOR_ROOT) ? null : decodedRoot);
                String decodedExtension = UrlUtf8.decodePChars(extension);
                instanceIdentifier.setExtensionName(decodedExtension.isEmpty() ? null : decodedExtension);
                return instanceIdentifier;
            }
            throw new UriMapperParsingException("Invalid encoding of InstanceIdentifier in the URI for the mapper " + ContextIdentificationMapper.class);
        }
        throw new UriMapperParsingException("Invalid URI for the mapper " + ContextIdentificationMapper.class);
    }

    public static enum ContextSource {
        Location("sdc.ctxt.loc", LocationContextState.class),
        Patient("sdc.ctxt.pat", PatientContextState.class),
        Ensemble("sdc.ctxt.ens", EnsembleContextState.class),
        Workflow("sdc.ctxt.wfl", WorkflowContextState.class),
        Operator("sdc.ctxt.opr", OperatorContextState.class),
        Means("sdc.ctxt.mns", MeansContextState.class);

        private final String sourceString;
        private final Class<? extends AbstractContextState> sourceClass;

        private ContextSource(String sourceString, Class<? extends AbstractContextState> sourceClass) {
            this.sourceString = sourceString;
            this.sourceClass = sourceClass;
        }

        public String getSourceString() {
            return this.sourceString;
        }

        public Class<? extends AbstractContextState> getSourceClass() {
            return this.sourceClass;
        }
    }
}

