/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer.sco;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jspecify.annotations.Nullable;
import org.jvnet.jaxb.lang.CopyTo;
import org.somda.sdc.biceps.model.message.AbstractSetResponse;
import org.somda.sdc.biceps.model.message.OperationInvokedReport;
import org.somda.sdc.biceps.model.participant.MdibVersion;
import org.somda.sdc.common.util.AutoLock;
import org.somda.sdc.common.util.JaxbCopyingKt;
import org.somda.sdc.glue.consumer.sco.ScoTransaction;
import org.somda.sdc.glue.consumer.sco.ScoUtil;

public class ScoTransactionImpl<T extends AbstractSetResponse>
implements ScoTransaction<T> {
    private final T response;
    private final Consumer<Pair<OperationInvokedReport.ReportPart, MdibVersion>> reportListener;
    private final ArrayList<Pair<OperationInvokedReport.ReportPart, MdibVersion>> collectedReports;
    private final ReentrantLock reportsLock;
    private final Condition reportsCondition;
    private final ScoUtil scoUtil;

    public ScoTransactionImpl(T response, @Nullable Consumer<Pair<// Could not load outer class - annotation placement on inner may be incorrect
    OperationInvokedReport.ReportPart, MdibVersion>> reportListener, ScoUtil scoUtil) {
        this.response = response;
        this.reportListener = reportListener;
        this.reportsLock = new ReentrantLock();
        this.reportsCondition = this.reportsLock.newCondition();
        this.scoUtil = scoUtil;
        this.collectedReports = new ArrayList(3);
    }

    @Override
    public long getTransactionId() {
        return this.response.getInvocationInfo().getTransactionId();
    }

    @Override
    public List<Pair<OperationInvokedReport.ReportPart, MdibVersion>> getReports() {
        try (AutoLock ignored = AutoLock.lock((Lock)this.reportsLock);){
            List<Pair<OperationInvokedReport.ReportPart, MdibVersion>> list = this.deepCopyCollectedReports();
            return list;
        }
    }

    @Override
    public T getResponse() {
        return (T)((AbstractSetResponse)JaxbCopyingKt.copyTyped(this.response));
    }

    @Override
    public List<Pair<OperationInvokedReport.ReportPart, MdibVersion>> waitForFinalReport(Duration waitTime) {
        Duration copyWaitTime = waitTime;
        try (AutoLock ignored = AutoLock.lock((Lock)this.reportsLock);){
            Instant finish;
            Instant start;
            if (this.scoUtil.hasFinalReport(this.collectedReports)) {
                List<Pair<OperationInvokedReport.ReportPart, MdibVersion>> list = this.deepCopyCollectedReports();
                return list;
            }
            do {
                List<Pair<OperationInvokedReport.ReportPart, MdibVersion>> list;
                block17: {
                    start = Instant.now();
                    try {
                        if (!this.reportsCondition.await(waitTime.toMillis(), TimeUnit.MILLISECONDS)) break block17;
                        if (this.scoUtil.hasFinalReport(this.collectedReports)) {
                            list = this.deepCopyCollectedReports();
                            return list;
                        }
                        continue;
                    }
                    catch (InterruptedException e) {
                        if (this.scoUtil.hasFinalReport(this.collectedReports)) {
                            List<Pair<OperationInvokedReport.ReportPart, MdibVersion>> list2 = this.deepCopyCollectedReports();
                            return list2;
                        }
                        List<Pair<OperationInvokedReport.ReportPart, MdibVersion>> list3 = Collections.emptyList();
                        return list3;
                    }
                }
                list = Collections.emptyList();
                return list;
            } while ((copyWaitTime = copyWaitTime.minus(Duration.between(start, finish = Instant.now()))).toMillis() > 0L);
        }
        return Collections.emptyList();
    }

    public void receiveIncomingReport(Pair<OperationInvokedReport.ReportPart, MdibVersion> report) {
        try (AutoLock ignored = AutoLock.lock((Lock)this.reportsLock);){
            this.collectedReports.add(report);
            this.reportsCondition.signalAll();
        }
        if (this.reportListener != null) {
            this.reportListener.accept(report);
        }
    }

    private List<Pair<OperationInvokedReport.ReportPart, MdibVersion>> deepCopyCollectedReports() {
        return this.collectedReports.stream().map(it -> new ImmutablePair((Object)((OperationInvokedReport.ReportPart)JaxbCopyingKt.copyTyped((CopyTo)((OperationInvokedReport.ReportPart)it.getLeft()))), (Object)((MdibVersion)it.getRight()))).collect(Collectors.toList());
    }
}

