/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.provider.localization.helper;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.biceps.model.participant.LocalizedText;
import org.somda.sdc.glue.common.LocalizationServiceFilterUtil;
import org.somda.sdc.glue.provider.localization.LocalizationException;
import org.somda.sdc.glue.provider.localization.LocalizationStorage;

public class HeapBasedLocalizationStorage
implements LocalizationStorage {
    private final List<String> supportedLanguages = new ArrayList<String>();
    private final Map<BigInteger, Table<String, String, LocalizedText>> localizationStorage = new HashMap<BigInteger, Table<String, String, LocalizedText>>();

    @Override
    public synchronized List<String> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    @Override
    public synchronized List<LocalizedText> getLocalizedText(List<String> references, @Nullable BigInteger version, List<String> languages) {
        if (version == null) {
            version = this.getLatestVersion();
        }
        Multimap<String, LocalizedText> refToValueMap = LocalizationServiceFilterUtil.filterByLanguage(this.localizationStorage.get(version), languages);
        return references.isEmpty() ? new ArrayList(refToValueMap.values()) : LocalizationServiceFilterUtil.filterByReferences(refToValueMap, references);
    }

    public synchronized void addLocalizedText(LocalizedText text) {
        this.checkRequiredAttributesNonEmpty(text);
        this.addToSupportedLanguages(text);
        this.addToStorage(text);
    }

    public synchronized void addAllLocalizedTexts(Collection<LocalizedText> texts) {
        texts.forEach(this::checkRequiredAttributesNonEmpty);
        texts.forEach(this::addLocalizedText);
    }

    private void checkRequiredAttributesNonEmpty(LocalizedText text) {
        if (text.getVersion() == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{text.getLang(), text.getRef()})) {
            throw new LocalizationException("Localized text invalid, mandatory fields 'version', 'lang' or 'ref' are missing. Localized text: " + text);
        }
    }

    private void addToStorage(LocalizedText text) {
        Table<String, String, LocalizedText> table = this.localizationStorage.getOrDefault(text.getVersion(), (Table<String, String, LocalizedText>)HashBasedTable.create());
        table.put((Object)text.getRef(), (Object)text.getLang(), (Object)text);
        this.localizationStorage.put(text.getVersion(), table);
    }

    private void addToSupportedLanguages(LocalizedText text) {
        if (!this.supportedLanguages.contains(text.getLang())) {
            this.supportedLanguages.add(text.getLang());
        }
    }

    private BigInteger getLatestVersion() {
        return this.localizationStorage.entrySet().stream().max(Map.Entry.comparingByKey()).map(Map.Entry::getKey).orElseThrow(() -> new LocalizationException("Failed to determine latest translations version"));
    }
}

