/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.common.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.glue.common.DefaultStateValues;

public class DefaultStateValuesDispatcher {
    private final Map<Class<?>, Method> methods;
    private final DefaultStateValues defaultStateValues;

    public DefaultStateValuesDispatcher(DefaultStateValues defaultStateValues) {
        this.methods = new HashMap(defaultStateValues.getClass().getDeclaredMethods().length);
        this.defaultStateValues = defaultStateValues;
        for (Method method : defaultStateValues.getClass().getDeclaredMethods()) {
            Class<?> paramType;
            if (method.getParameterCount() != 1 || !AbstractState.class.isAssignableFrom(paramType = method.getParameterTypes()[0])) continue;
            method.setAccessible(true);
            this.methods.put(paramType, method);
        }
    }

    public void dispatchDefaultStateValues(AbstractState state) throws InvocationTargetException, IllegalAccessException {
        Class<?> stateClass = state.getClass();
        do {
            Method method;
            if ((method = this.methods.get(stateClass)) == null) continue;
            method.invoke((Object)this.defaultStateValues, state);
            return;
        } while (!(stateClass = stateClass.getSuperclass()).equals(Object.class));
    }
}

