/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer;

import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.biceps.model.participant.AbstractComplexDeviceComponentDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractContextState;
import org.somda.sdc.biceps.model.participant.ContextAssociation;
import org.somda.sdc.biceps.model.participant.InstanceIdentifier;
import org.somda.sdc.dpws.client.DiscoveryFilter;
import org.somda.sdc.dpws.client.DiscoveryFilterBuilder;
import org.somda.sdc.dpws.soap.wsdiscovery.MatchBy;
import org.somda.sdc.glue.GlueConstants;
import org.somda.sdc.glue.common.CommonConstants;
import org.somda.sdc.glue.common.uri.ComplexDeviceComponentMapper;
import org.somda.sdc.glue.common.uri.ContextIdentificationMapper;
import org.somda.sdc.glue.common.uri.UriMapperGenerationArgumentException;

public class SdcDiscoveryFilterBuilder {
    private static final Logger LOG = LogManager.getLogger(SdcDiscoveryFilterBuilder.class);
    private final DiscoveryFilterBuilder discoveryFilterBuilder = new DiscoveryFilterBuilder();

    private SdcDiscoveryFilterBuilder() {
        this.discoveryFilterBuilder.addType(CommonConstants.MEDICAL_DEVICE_TYPE);
        this.discoveryFilterBuilder.addScope(GlueConstants.SCOPE_SDC_PROVIDER);
    }

    public static SdcDiscoveryFilterBuilder create() {
        return new SdcDiscoveryFilterBuilder();
    }

    public SdcDiscoveryFilterBuilder addType(QName type) {
        this.discoveryFilterBuilder.addType(type);
        return this;
    }

    public SdcDiscoveryFilterBuilder addScope(String scope) {
        this.discoveryFilterBuilder.addScope(scope);
        return this;
    }

    public <T extends AbstractContextState> SdcDiscoveryFilterBuilder addContext(T state) {
        try {
            SdcDiscoveryFilterBuilder.createScopeFromContext(state).ifPresent(this::addScope);
        }
        catch (UriMapperGenerationArgumentException e) {
            LOG.warn("Context state could not be encoded as an URI", (Throwable)e);
        }
        return this;
    }

    public <T extends AbstractComplexDeviceComponentDescriptor> SdcDiscoveryFilterBuilder addDeviceComponent(T component) {
        try {
            this.addScope(ComplexDeviceComponentMapper.fromComplexDeviceComponent(component));
        }
        catch (UriMapperGenerationArgumentException e) {
            LOG.warn("The URI generation based on the given component failed", (Throwable)e);
        }
        return this;
    }

    public SdcDiscoveryFilterBuilder setMatchBy(@Nullable MatchBy matchBy) {
        this.discoveryFilterBuilder.setMatchBy(matchBy);
        return this;
    }

    public DiscoveryFilter get() {
        return this.discoveryFilterBuilder.get();
    }

    private static Optional<String> createScopeFromContext(AbstractContextState contextState) throws UriMapperGenerationArgumentException {
        if (!contextState.getContextAssociation().equals((Object)ContextAssociation.ASSOC)) {
            return Optional.empty();
        }
        if (contextState.getIdentification().isEmpty()) {
            return Optional.empty();
        }
        ContextIdentificationMapper.ContextSource contextSource = SdcDiscoveryFilterBuilder.mapToContextSource(contextState);
        return Optional.of(ContextIdentificationMapper.fromInstanceIdentifier((InstanceIdentifier)contextState.getIdentification().get(0), contextSource));
    }

    private static ContextIdentificationMapper.ContextSource mapToContextSource(AbstractContextState contextState) {
        for (ContextIdentificationMapper.ContextSource value : ContextIdentificationMapper.ContextSource.values()) {
            if (!value.getSourceClass().isAssignableFrom(contextState.getClass())) continue;
            return value;
        }
        throw new RuntimeException(String.format("Reached unknown context: %s", contextState.getClass().toString()));
    }
}

