/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.provider.sco;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.somda.sdc.biceps.model.message.Activate;
import org.somda.sdc.biceps.model.message.InvocationError;
import org.somda.sdc.biceps.model.message.InvocationState;
import org.somda.sdc.biceps.model.message.SetAlertState;
import org.somda.sdc.biceps.model.message.SetComponentState;
import org.somda.sdc.biceps.model.message.SetContextState;
import org.somda.sdc.biceps.model.message.SetMetricState;
import org.somda.sdc.biceps.model.message.SetString;
import org.somda.sdc.biceps.model.message.SetValue;
import org.somda.sdc.biceps.model.participant.InstanceIdentifier;
import org.somda.sdc.biceps.model.participant.MdibVersion;
import org.somda.sdc.biceps.provider.access.LocalMdibAccess;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.device.EventSourceAccess;
import org.somda.sdc.glue.provider.sco.Context;
import org.somda.sdc.glue.provider.sco.InvocationResponse;
import org.somda.sdc.glue.provider.sco.OperationInvocationReceiver;
import org.somda.sdc.glue.provider.sco.factory.ContextFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB>\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\u000f\b\u0001\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\u0010\rJ3\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u0002H\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/somda/sdc/glue/provider/sco/ScoController;", "", "eventSourceAccess", "Lorg/somda/sdc/dpws/device/EventSourceAccess;", "mdibAccess", "Lorg/somda/sdc/biceps/provider/access/LocalMdibAccess;", "contextFactory", "Lorg/somda/sdc/glue/provider/sco/factory/ContextFactory;", "frameworkIdentifier", "", "operationInvocationReceiver", "Lorg/somda/sdc/glue/provider/sco/OperationInvocationReceiver;", "Lorg/jspecify/annotations/Nullable;", "(Lorg/somda/sdc/dpws/device/EventSourceAccess;Lorg/somda/sdc/biceps/provider/access/LocalMdibAccess;Lorg/somda/sdc/glue/provider/sco/factory/ContextFactory;Ljava/lang/String;Lorg/somda/sdc/glue/provider/sco/OperationInvocationReceiver;)V", "instanceLogger", "Lorg/apache/logging/log4j/Logger;", "transactionCounter", "", "processIncomingSetOperation", "Lorg/somda/sdc/glue/provider/sco/InvocationResponse;", "T", "handle", "source", "Lorg/somda/sdc/biceps/model/participant/InstanceIdentifier;", "request", "callerId", "(Ljava/lang/String;Lorg/somda/sdc/biceps/model/participant/InstanceIdentifier;Ljava/lang/Object;Ljava/lang/String;)Lorg/somda/sdc/glue/provider/sco/InvocationResponse;", "Companion", "glue"})
public final class ScoController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventSourceAccess eventSourceAccess;
    @NotNull
    private final LocalMdibAccess mdibAccess;
    @NotNull
    private final ContextFactory contextFactory;
    @NotNull
    private final String frameworkIdentifier;
    @Nullable
    private final @org.jspecify.annotations.Nullable OperationInvocationReceiver operationInvocationReceiver;
    private long transactionCounter;
    @NotNull
    private final Logger instanceLogger;
    @NotNull
    private static final Logger LOG;

    @AssistedInject
    public ScoController(@Assisted @NotNull EventSourceAccess eventSourceAccess, @Assisted @NotNull LocalMdibAccess mdibAccess, @NotNull ContextFactory contextFactory, @Named(value="Common.InstanceIdentifier") @NotNull String frameworkIdentifier, @Assisted @Nullable @org.jspecify.annotations.Nullable OperationInvocationReceiver operationInvocationReceiver) {
        Intrinsics.checkNotNullParameter((Object)eventSourceAccess, (String)"eventSourceAccess");
        Intrinsics.checkNotNullParameter((Object)mdibAccess, (String)"mdibAccess");
        Intrinsics.checkNotNullParameter((Object)contextFactory, (String)"contextFactory");
        Intrinsics.checkNotNullParameter((Object)frameworkIdentifier, (String)"frameworkIdentifier");
        this.eventSourceAccess = eventSourceAccess;
        this.mdibAccess = mdibAccess;
        this.contextFactory = contextFactory;
        this.frameworkIdentifier = frameworkIdentifier;
        this.operationInvocationReceiver = operationInvocationReceiver;
        Logger logger = InstanceLogger.wrapLogger((Logger)LOG, (String)this.frameworkIdentifier);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"wrapLogger(...)");
        this.instanceLogger = logger;
    }

    @NotNull
    public final <T> InvocationResponse processIncomingSetOperation(@NotNull String handle, @NotNull InstanceIdentifier source, T request, @Nullable String callerId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        long l = this.transactionCounter;
        this.transactionCounter = l + 1L;
        Context context = this.contextFactory.createContext(l, handle, source, this.eventSourceAccess, this.mdibAccess, callerId);
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"createContext(...)");
        Context context2 = context;
        try {
            InvocationResponse response;
            object = request;
            if (object instanceof SetValue) {
                OperationInvocationReceiver operationInvocationReceiver = this.operationInvocationReceiver;
                if (operationInvocationReceiver != null) {
                    Intrinsics.checkNotNull(request, (String)"null cannot be cast to non-null type org.somda.sdc.biceps.model.message.SetValue");
                    v2 = operationInvocationReceiver.handleSetValue(context2, handle, (SetValue)request);
                } else {
                    v2 = null;
                }
            } else if (object instanceof SetString) {
                OperationInvocationReceiver operationInvocationReceiver = this.operationInvocationReceiver;
                if (operationInvocationReceiver != null) {
                    Intrinsics.checkNotNull(request, (String)"null cannot be cast to non-null type org.somda.sdc.biceps.model.message.SetString");
                    v2 = operationInvocationReceiver.handleSetString(context2, handle, (SetString)request);
                } else {
                    v2 = null;
                }
            } else if (object instanceof Activate) {
                OperationInvocationReceiver operationInvocationReceiver = this.operationInvocationReceiver;
                if (operationInvocationReceiver != null) {
                    Intrinsics.checkNotNull(request, (String)"null cannot be cast to non-null type org.somda.sdc.biceps.model.message.Activate");
                    v2 = operationInvocationReceiver.handleActivate(context2, handle, (Activate)request);
                } else {
                    v2 = null;
                }
            } else if (object instanceof SetAlertState) {
                OperationInvocationReceiver operationInvocationReceiver = this.operationInvocationReceiver;
                if (operationInvocationReceiver != null) {
                    Intrinsics.checkNotNull(request, (String)"null cannot be cast to non-null type org.somda.sdc.biceps.model.message.SetAlertState");
                    v2 = operationInvocationReceiver.handleSetAlertState(context2, handle, (SetAlertState)request);
                } else {
                    v2 = null;
                }
            } else if (object instanceof SetComponentState) {
                OperationInvocationReceiver operationInvocationReceiver = this.operationInvocationReceiver;
                if (operationInvocationReceiver != null) {
                    Intrinsics.checkNotNull(request, (String)"null cannot be cast to non-null type org.somda.sdc.biceps.model.message.SetComponentState");
                    v2 = operationInvocationReceiver.handleSetComponentState(context2, handle, (SetComponentState)request);
                } else {
                    v2 = null;
                }
            } else if (object instanceof SetContextState) {
                OperationInvocationReceiver operationInvocationReceiver = this.operationInvocationReceiver;
                if (operationInvocationReceiver != null) {
                    Intrinsics.checkNotNull(request, (String)"null cannot be cast to non-null type org.somda.sdc.biceps.model.message.SetContextState");
                    v2 = operationInvocationReceiver.handleSetContextState(context2, handle, (SetContextState)request);
                } else {
                    v2 = null;
                }
            } else if (object instanceof SetMetricState) {
                OperationInvocationReceiver operationInvocationReceiver = this.operationInvocationReceiver;
                if (operationInvocationReceiver != null) {
                    Intrinsics.checkNotNull(request, (String)"null cannot be cast to non-null type org.somda.sdc.biceps.model.message.SetMetricState");
                    v2 = operationInvocationReceiver.handleSetMetricState(context2, handle, (SetMetricState)request);
                } else {
                    v2 = null;
                }
            } else {
                v2 = response = null;
            }
            if (response != null) {
                InvocationResponse it = response;
                boolean bl = false;
                return it;
            }
        }
        catch (Exception e) {
            String errorMessage = "Invocation of operation with handle '" + handle + "' failed: " + e.getMessage();
            this.instanceLogger.warn(errorMessage);
            this.instanceLogger.trace(errorMessage, (Throwable)e);
            InvocationResponse invocationResponse = context2.createUnsuccessfulResponse(this.mdibAccess.getMdibVersion(), InvocationState.FAIL, InvocationError.OTH, CollectionsKt.listOf((Object)OperationInvocationReceiver.Companion.createLocalizedText$glue(errorMessage)));
            Intrinsics.checkNotNullExpressionValue((Object)invocationResponse, (String)"createUnsuccessfulResponse(...)");
            return OperationInvocationReceiver.Companion.additionallySendResponseAsReport$glue(context2, invocationResponse);
        }
        MdibVersion mdibVersion = this.mdibAccess.getMdibVersion();
        object = "A handler for the operation with handle '%s' could not be found";
        Object[] objectArray = new Object[]{handle};
        String string = String.format(object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        InvocationResponse invocationResponse = context2.createUnsuccessfulResponse(mdibVersion, InvocationState.FAIL, InvocationError.OTH, CollectionsKt.listOf((Object)OperationInvocationReceiver.Companion.createLocalizedText$glue(string)));
        Intrinsics.checkNotNullExpressionValue((Object)invocationResponse, (String)"createUnsuccessfulResponse(...)");
        return OperationInvocationReceiver.Companion.additionallySendResponseAsReport$glue(context2, invocationResponse);
    }

    static {
        Logger logger = LogManager.getLogger((Object)Reflection.getOrCreateKotlinClass(ScoController.class));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/somda/sdc/glue/provider/sco/ScoController$Companion;", "", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "getLOG", "()Lorg/apache/logging/log4j/Logger;", "glue"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

