/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.provider.services;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import jakarta.xml.bind.annotation.XmlType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.access.MdibAccess;
import org.somda.sdc.biceps.common.access.MdibAccessObserver;
import org.somda.sdc.biceps.common.access.ReadTransaction;
import org.somda.sdc.biceps.model.message.AbstractSet;
import org.somda.sdc.biceps.model.message.AbstractSetResponse;
import org.somda.sdc.biceps.model.message.Activate;
import org.somda.sdc.biceps.model.message.ActivateResponse;
import org.somda.sdc.biceps.model.message.GetContainmentTree;
import org.somda.sdc.biceps.model.message.GetContainmentTreeResponse;
import org.somda.sdc.biceps.model.message.GetContextStates;
import org.somda.sdc.biceps.model.message.GetContextStatesResponse;
import org.somda.sdc.biceps.model.message.GetDescriptor;
import org.somda.sdc.biceps.model.message.GetDescriptorResponse;
import org.somda.sdc.biceps.model.message.GetMdDescription;
import org.somda.sdc.biceps.model.message.GetMdDescriptionResponse;
import org.somda.sdc.biceps.model.message.GetMdState;
import org.somda.sdc.biceps.model.message.GetMdStateResponse;
import org.somda.sdc.biceps.model.message.GetMdib;
import org.somda.sdc.biceps.model.message.GetMdibResponse;
import org.somda.sdc.biceps.model.message.InvocationInfo;
import org.somda.sdc.biceps.model.message.ObjectFactory;
import org.somda.sdc.biceps.model.message.SetAlertState;
import org.somda.sdc.biceps.model.message.SetAlertStateResponse;
import org.somda.sdc.biceps.model.message.SetComponentState;
import org.somda.sdc.biceps.model.message.SetComponentStateResponse;
import org.somda.sdc.biceps.model.message.SetContextState;
import org.somda.sdc.biceps.model.message.SetContextStateResponse;
import org.somda.sdc.biceps.model.message.SetMetricState;
import org.somda.sdc.biceps.model.message.SetMetricStateResponse;
import org.somda.sdc.biceps.model.message.SetString;
import org.somda.sdc.biceps.model.message.SetStringResponse;
import org.somda.sdc.biceps.model.message.SetValue;
import org.somda.sdc.biceps.model.message.SetValueResponse;
import org.somda.sdc.biceps.model.participant.AbstractContextState;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.ContainmentTree;
import org.somda.sdc.biceps.model.participant.ContainmentTreeEntry;
import org.somda.sdc.biceps.model.participant.InstanceIdentifier;
import org.somda.sdc.biceps.model.participant.MdibVersion;
import org.somda.sdc.biceps.provider.access.LocalMdibAccess;
import org.somda.sdc.dpws.device.EventSourceAccess;
import org.somda.sdc.dpws.device.WebService;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.factory.SoapFaultFactory;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wseventing.ActionBasedEventSource;
import org.somda.sdc.dpws.soap.wseventing.EventSourceDialectHandler;
import org.somda.sdc.dpws.soap.wseventing.model.WsEventingStatus;
import org.somda.sdc.glue.common.ActionConstants;
import org.somda.sdc.glue.common.MdibMapper;
import org.somda.sdc.glue.common.MdibVersionUtil;
import org.somda.sdc.glue.common.factory.MdibMapperFactory;
import org.somda.sdc.glue.provider.sco.InvocationResponse;
import org.somda.sdc.glue.provider.sco.OperationInvocationReceiver;
import org.somda.sdc.glue.provider.sco.ScoController;
import org.somda.sdc.glue.provider.sco.factory.ScoControllerFactory;
import org.somda.sdc.glue.provider.services.helper.ReportGenerator;
import org.somda.sdc.glue.provider.services.helper.factory.ReportGeneratorFactory;

public class HighPriorityServices
extends WebService
implements EventSourceAccess {
    private final Logger LOG = LogManager.getLogger();
    private final LocalMdibAccess mdibAccess;
    private final SoapUtil soapUtil;
    private final SoapFaultFactory faultFactory;
    private final ObjectFactory messageModelFactory;
    private final org.somda.sdc.biceps.model.participant.ObjectFactory participantModelFactory;
    private final MdibMapperFactory mdibMapperFactory;
    private final MdibVersionUtil mdibVersionUtil;
    private final WsAddressingUtil wsaUtil;
    private final ScoController scoController;
    private final InstanceIdentifier anonymousSource;
    private final ReportGenerator reportGenerator;
    private final ActionBasedEventSource actionBasedEventSource;

    @AssistedInject
    HighPriorityServices(@Assisted LocalMdibAccess mdibAccess, ReportGeneratorFactory reportGeneratorFactory, SoapUtil soapUtil, SoapFaultFactory faultFactory, ObjectFactory messageModelFactory, org.somda.sdc.biceps.model.participant.ObjectFactory participantModelFactory, MdibMapperFactory mdibMapperFactory, ScoControllerFactory scoControllerFactory, MdibVersionUtil mdibVersionUtil, WsAddressingUtil wsaUtil, ActionBasedEventSource actionBasedEventSource, @Assisted @Nullable OperationInvocationReceiver operationInvocationReceiver) {
        this.mdibAccess = mdibAccess;
        this.soapUtil = soapUtil;
        this.faultFactory = faultFactory;
        this.messageModelFactory = messageModelFactory;
        this.participantModelFactory = participantModelFactory;
        this.mdibMapperFactory = mdibMapperFactory;
        this.mdibVersionUtil = mdibVersionUtil;
        this.wsaUtil = wsaUtil;
        this.scoController = scoControllerFactory.createScoController(this, mdibAccess, operationInvocationReceiver);
        this.reportGenerator = reportGeneratorFactory.createReportGenerator(this);
        this.actionBasedEventSource = actionBasedEventSource;
        this.registerEventSource((EventSourceDialectHandler)actionBasedEventSource);
        this.anonymousSource = new InstanceIdentifier();
        this.anonymousSource.setRootName("http://standards.ieee.org/downloads/11073/11073-20701-2018");
        this.anonymousSource.setExtensionName("AnonymousSdcParticipant");
        mdibAccess.registerObserver((MdibAccessObserver)this.reportGenerator);
    }

    public <T extends AbstractState> void sendPeriodicStateReport(Map<String, List<T>> states, MdibVersion mdibVersion) {
        this.reportGenerator.sendPeriodicStateReport(states, mdibVersion);
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/GetService/GetMdib")
    void getMdib(RequestResponseObject requestResponseObject) throws SoapFaultException {
        this.getRequest(requestResponseObject, GetMdib.class);
        GetMdibResponse getMdibResponse = this.messageModelFactory.createGetMdibResponse();
        try (ReadTransaction transaction = this.mdibAccess.startTransaction();){
            MdibMapper mdibMapper = this.mdibMapperFactory.createMdibMapper((MdibAccess)transaction);
            getMdibResponse.setMdib(mdibMapper.mapMdib());
            this.setResponse(requestResponseObject, getMdibResponse, transaction.getMdibVersion(), ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/GetService/GetMdib"));
        }
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/GetService/GetMdDescription")
    void getMdDescription(RequestResponseObject requestResponseObject) throws SoapFaultException {
        GetMdDescription getMdDescription = this.getRequest(requestResponseObject, GetMdDescription.class);
        GetMdDescriptionResponse getMdDescriptionResponse = this.messageModelFactory.createGetMdDescriptionResponse();
        try (ReadTransaction transaction = this.mdibAccess.startTransaction();){
            MdibMapper mdibMapper = this.mdibMapperFactory.createMdibMapper((MdibAccess)transaction);
            getMdDescriptionResponse.setMdDescription(mdibMapper.mapMdDescription(getMdDescription.getHandleRef()));
            this.setResponse(requestResponseObject, getMdDescriptionResponse, transaction.getMdibVersion(), ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/GetService/GetMdDescription"));
        }
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/GetService/GetMdState")
    void getMdState(RequestResponseObject requestResponseObject) throws SoapFaultException {
        GetMdState getMdState = this.getRequest(requestResponseObject, GetMdState.class);
        GetMdStateResponse getMdStateResponse = this.messageModelFactory.createGetMdStateResponse();
        try (ReadTransaction transaction = this.mdibAccess.startTransaction();){
            MdibMapper mdibMapper = this.mdibMapperFactory.createMdibMapper((MdibAccess)transaction);
            getMdStateResponse.setMdState(mdibMapper.mapMdState(getMdState.getHandleRef()));
            this.setResponse(requestResponseObject, getMdStateResponse, transaction.getMdibVersion(), ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/GetService/GetMdState"));
        }
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/GetContextStates")
    void getContextStates(RequestResponseObject requestResponseObject) throws SoapFaultException {
        GetContextStates getContextStates = this.getRequest(requestResponseObject, GetContextStates.class);
        GetContextStatesResponse getContextStatesResponse = this.messageModelFactory.createGetContextStatesResponse();
        try (ReadTransaction transaction = this.mdibAccess.startTransaction();){
            List contextStates = transaction.getContextStates();
            List<AbstractContextState> filteredContextStates = new ArrayList();
            if (getContextStates.getHandleRef().isEmpty()) {
                filteredContextStates = contextStates;
            } else {
                HashSet filterSet = new HashSet(getContextStates.getHandleRef());
                for (AbstractContextState contextState : contextStates) {
                    MdibEntity entity = (MdibEntity)transaction.getEntity(contextState.getDescriptorHandle()).orElseThrow(() -> new SoapFaultException(this.faultFactory.createReceiverFault(String.format("Unexpected MDIB inconsistency: context descriptor with handle %s not found for context state with handle %s", contextState.getDescriptorHandle(), contextState.getHandle()))));
                    boolean containsStateHandle = filterSet.contains(contextState.getHandle());
                    boolean containsDescrHandle = filterSet.contains(contextState.getDescriptorHandle());
                    boolean containsMdsHandle = filterSet.contains(entity.getParentMds());
                    if (!containsStateHandle && !containsDescrHandle && !containsMdsHandle) continue;
                    filteredContextStates.add(contextState);
                }
            }
            getContextStatesResponse.setContextState(filteredContextStates);
            this.setResponse(requestResponseObject, getContextStatesResponse, transaction.getMdibVersion(), ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/GetContextStates"));
        }
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/GetContextStatesByFilter")
    void getContextStatesByFilter(RequestResponseObject requestResponseObject) throws SoapFaultException {
        throw new SoapFaultException(this.faultFactory.createReceiverFault("GetContextStatesByFilter is not available on this device"), (AttributedURIType)requestResponseObject.getRequest().getWsAddressingHeader().getMessageId().orElse(null));
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/GetContextStatesByIdentification")
    void getContextStatesByIdentification(RequestResponseObject requestResponseObject) throws SoapFaultException {
        throw new SoapFaultException(this.faultFactory.createReceiverFault("GetContextStatesByIdentification is not available on this device"), (AttributedURIType)requestResponseObject.getRequest().getWsAddressingHeader().getMessageId().orElse(null));
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/SetValue")
    void setValue(RequestResponseObject requestResponseObject) throws SoapFaultException {
        this.processSetServiceRequest(requestResponseObject, SetValue.class, SetValueResponse.class, ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/SetValue"));
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/SetString")
    void setString(RequestResponseObject requestResponseObject) throws SoapFaultException {
        this.processSetServiceRequest(requestResponseObject, SetString.class, SetStringResponse.class, ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/SetString"));
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/Activate")
    void activate(RequestResponseObject requestResponseObject) throws SoapFaultException {
        this.processSetServiceRequest(requestResponseObject, Activate.class, ActivateResponse.class, ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/Activate"));
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/SetComponentState")
    void setComponentState(RequestResponseObject requestResponseObject) throws SoapFaultException {
        this.processSetServiceRequest(requestResponseObject, SetComponentState.class, SetComponentStateResponse.class, ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/SetComponentState"));
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/SetContextState")
    void setContextState(RequestResponseObject requestResponseObject) throws SoapFaultException {
        this.processSetServiceRequest(requestResponseObject, SetContextState.class, SetContextStateResponse.class, ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/SetContextState"));
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/SetAlertState")
    void setAlertState(RequestResponseObject requestResponseObject) throws SoapFaultException {
        this.processSetServiceRequest(requestResponseObject, SetAlertState.class, SetAlertStateResponse.class, ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/SetAlertState"));
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/SetMetricState")
    void setMetricState(RequestResponseObject requestResponseObject) throws SoapFaultException {
        this.processSetServiceRequest(requestResponseObject, SetMetricState.class, SetMetricStateResponse.class, ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/SetMetricState"));
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/ContainmentTreeService/GetDescriptor")
    void getDescriptor(RequestResponseObject requestResponseObject) throws SoapFaultException {
        GetDescriptor getDescriptor = this.getRequest(requestResponseObject, GetDescriptor.class);
        GetDescriptorResponse getDescriptorResponse = this.messageModelFactory.createGetDescriptorResponse();
        try (ReadTransaction transaction = this.mdibAccess.startTransaction();){
            for (String handle : getDescriptor.getHandleRef()) {
                transaction.getDescriptor(handle).ifPresent(descriptor -> getDescriptorResponse.getDescriptor().add(descriptor));
            }
            this.setResponse(requestResponseObject, getDescriptorResponse, transaction.getMdibVersion(), ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/ContainmentTreeService/GetDescriptor"));
        }
    }

    @MessageInterceptor(value="http://standards.ieee.org/downloads/11073/11073-20701-2018/ContainmentTreeService/GetContainmentTree")
    void getContainmentTree(RequestResponseObject requestResponseObject) throws SoapFaultException {
        GetContainmentTree getContainmentTree = this.getRequest(requestResponseObject, GetContainmentTree.class);
        GetContainmentTreeResponse getContainmentTreeResponse = this.messageModelFactory.createGetContainmentTreeResponse();
        List handleReferences = getContainmentTree.getHandleRef();
        ContainmentTree containmentTree = this.participantModelFactory.createContainmentTree();
        try (ReadTransaction transaction = this.mdibAccess.startTransaction();){
            ArrayList filteredEntities;
            if (handleReferences.isEmpty()) {
                filteredEntities = transaction.getRootEntities();
            } else {
                filteredEntities = new ArrayList();
                Optional parentEntity = transaction.getEntity((String)handleReferences.get(0));
                if (parentEntity.isPresent()) {
                    MdibEntity entity = (MdibEntity)parentEntity.get();
                    containmentTree.setChildrenCount(Integer.valueOf(entity.getChildren().size()));
                    containmentTree.setHandleRef(entity.getHandle());
                    entity.getParent().ifPresent(arg_0 -> ((ContainmentTree)containmentTree).setParentHandleRef(arg_0));
                    containmentTree.setEntryType(this.getContainmentTreeEntryType(entity));
                    entity.getChildren().forEach(childHandle -> transaction.getEntity(childHandle).ifPresent(filteredEntities::add));
                }
            }
            for (MdibEntity entity : filteredEntities) {
                ContainmentTreeEntry entry = this.participantModelFactory.createContainmentTreeEntry();
                entry.setChildrenCount(Integer.valueOf(entity.getChildren().size()));
                entry.setHandleRef(entity.getHandle());
                entity.getParent().ifPresent(arg_0 -> ((ContainmentTreeEntry)entry).setParentHandleRef(arg_0));
                entry.setType(entity.getDescriptor().getType());
                entry.setEntryType(this.getContainmentTreeEntryType(entity));
                containmentTree.getEntry().add(entry);
            }
            getContainmentTreeResponse.setContainmentTree(containmentTree);
            this.setResponse(requestResponseObject, getContainmentTreeResponse, transaction.getMdibVersion(), ActionConstants.getResponseAction("http://standards.ieee.org/downloads/11073/11073-20701-2018/ContainmentTreeService/GetContainmentTree"));
        }
    }

    private <T> T getRequest(RequestResponseObject requestResponseObject, Class<T> bodyType) throws SoapFaultException {
        return this.soapUtil.getBody(requestResponseObject.getRequest(), bodyType).orElseThrow(() -> new SoapFaultException(this.faultFactory.createSenderFault(String.format("%s SOAP request body is malformed", bodyType.getSimpleName())), (AttributedURIType)requestResponseObject.getRequest().getWsAddressingHeader().getMessageId().orElse(null)));
    }

    private <T> void setResponse(RequestResponseObject requestResponseObject, T response, MdibVersion mdibVersion, String responseAction) throws SoapFaultException {
        try {
            this.mdibVersionUtil.setMdibVersion(mdibVersion, response);
        }
        catch (Exception e) {
            throw new SoapFaultException(this.faultFactory.createReceiverFault("Could not create MDIB version."), (AttributedURIType)requestResponseObject.getRequest().getWsAddressingHeader().getMessageId().orElse(null));
        }
        requestResponseObject.getResponse().getWsAddressingHeader().setAction(this.wsaUtil.createAttributedURIType(responseAction));
        this.soapUtil.setBody(response, requestResponseObject.getResponse());
    }

    private <T extends AbstractSetResponse> T getResponseObjectAsTypeOrThrow(InvocationResponse responseData, Class<T> type) throws SoapFaultException {
        try {
            AbstractSetResponse response = (AbstractSetResponse)type.getConstructor(new Class[0]).newInstance(new Object[0]);
            response.setSequenceId(responseData.getMdibVersion().getSequenceId());
            response.setInstanceId(responseData.getMdibVersion().getInstanceId());
            response.setMdibVersion(responseData.getMdibVersion().getVersion());
            InvocationInfo invocationInfo = new InvocationInfo();
            invocationInfo.setTransactionId(responseData.getTransactionId());
            invocationInfo.setInvocationState(responseData.getInvocationState());
            invocationInfo.setInvocationError(responseData.getInvocationError());
            invocationInfo.setInvocationErrorMessage(responseData.getInvocationErrorMessage());
            response.setInvocationInfo(invocationInfo);
            return (T)response;
        }
        catch (Exception e) {
            throw new SoapFaultException(this.faultFactory.createReceiverFault(String.format("Response message could not be generated. Reason: %s", e.getMessage())));
        }
    }

    private InstanceIdentifier determineSource(RequestResponseObject requestResponseObject) {
        TransportInfo transportInfo = requestResponseObject.getCommunicationContext().getTransportInfo();
        if (!transportInfo.getX509Certificates().isEmpty()) {
            X509Certificate peerCert = (X509Certificate)transportInfo.getX509Certificates().get(0);
            StringWriter stringWriter = new StringWriter();
            try (JcaPEMWriter writer = new JcaPEMWriter((Writer)stringWriter);){
                writer.writeObject((Object)peerCert);
            }
            catch (IOException e) {
                this.LOG.warn("Could not determine caller source, falling back to anonymous caller", (Throwable)e);
                return this.anonymousSource;
            }
            InstanceIdentifier knownInstanceIdentifier = new InstanceIdentifier();
            knownInstanceIdentifier.setRootName("http://standards.ieee.org/downloads/11073/11073-20701-2018/X509Certificate/PEM");
            knownInstanceIdentifier.setExtensionName(stringWriter.toString());
            return knownInstanceIdentifier;
        }
        return this.anonymousSource;
    }

    private <T extends AbstractSet, V extends AbstractSetResponse> void processSetServiceRequest(RequestResponseObject requestResponseObject, Class<T> requestClass, Class<V> responseClass, String responseAction) throws SoapFaultException {
        InvocationResponse invocationResponse;
        AbstractSet request = (AbstractSet)this.getRequest(requestResponseObject, requestClass);
        try {
            invocationResponse = this.scoController.processIncomingSetOperation(request.getOperationHandleRef(), this.determineSource(requestResponseObject), request, this.soapUtil.determineRequestDistinguishedName(requestResponseObject));
        }
        catch (Exception e) {
            throw new SoapFaultException(this.faultFactory.createReceiverFault(String.format("Error while processing set service request: %s", e.getMessage())), (AttributedURIType)requestResponseObject.getRequest().getWsAddressingHeader().getMessageId().orElse(null));
        }
        this.setResponse(requestResponseObject, this.getResponseObjectAsTypeOrThrow(invocationResponse, responseClass), invocationResponse.getMdibVersion(), responseAction);
    }

    private QName getContainmentTreeEntryType(MdibEntity entity) throws SoapFaultException {
        for (Annotation annotation : entity.getDescriptorClass().getAnnotations()) {
            if (annotation.annotationType() != XmlType.class) continue;
            return new QName(((XmlType)annotation).namespace(), ((XmlType)annotation).name());
        }
        throw new SoapFaultException(this.faultFactory.createReceiverFault(String.format("Could not resolve entry type the requested descriptor %s. Operation aborted.", entity.getHandle())));
    }

    public void sendNotification(String action, Object payload) throws MarshallingException, TransportException {
        this.actionBasedEventSource.sendNotification(action, payload);
    }

    public void subscriptionEndToAll(WsEventingStatus status) throws TransportException {
        this.actionBasedEventSource.subscriptionEndToAll(status);
    }
}

