/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.common;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.somda.sdc.glue.provider.localization.LocalizationException;
import org.somda.sdc.glue.provider.localization.helper.LocalizedData;

public class LocalizationServiceFilterUtil {
    public static <R, V> Multimap<R, V> filterByLanguage(Table<R, String, V> localizedTextTable, List<String> languages) {
        ArrayListMultimap referencesToTextMap = ArrayListMultimap.create();
        if (!languages.isEmpty()) {
            languages.forEach(arg_0 -> LocalizationServiceFilterUtil.lambda$filterByLanguage$0(localizedTextTable, (Multimap)referencesToTextMap, arg_0));
        } else {
            localizedTextTable.columnKeySet().forEach(arg_0 -> LocalizationServiceFilterUtil.lambda$filterByLanguage$1(localizedTextTable, (Multimap)referencesToTextMap, arg_0));
        }
        return referencesToTextMap;
    }

    public static <T> List<T> filterByReferences(Multimap<String, T> referencesToTextMap, List<String> references) {
        return references.stream().filter(arg_0 -> referencesToTextMap.containsKey(arg_0)).map(arg_0 -> referencesToTextMap.get(arg_0)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public static List<LocalizedData> filterByNumberOfLines(List<LocalizedData> data, List<BigInteger> numberOfLines) {
        if (numberOfLines.isEmpty()) {
            return data;
        }
        BigInteger largestNumberOfLines = (BigInteger)numberOfLines.stream().max(BigInteger::compareTo).orElseThrow(() -> new LocalizationException("Failed to process number of lines."));
        return data.stream().filter(datum -> datum.getLines().compareTo(largestNumberOfLines) < 1).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$filterByLanguage$1(Table localizedTextTable, Multimap referencesToTextMap, String key) {
        localizedTextTable.column((Object)key).forEach((arg_0, arg_1) -> ((Multimap)referencesToTextMap).put(arg_0, arg_1));
    }

    private static /* synthetic */ void lambda$filterByLanguage$0(Table localizedTextTable, Multimap referencesToTextMap, String language) {
        localizedTextTable.column((Object)language).forEach((arg_0, arg_1) -> ((Multimap)referencesToTextMap).put(arg_0, arg_1));
    }
}

