/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.common.uri;

import jregex.Matcher;
import jregex.Pattern;
import org.somda.sdc.biceps.model.participant.AbstractComplexDeviceComponentDescriptor;
import org.somda.sdc.biceps.model.participant.CodedValue;
import org.somda.sdc.glue.GlueConstants;
import org.somda.sdc.glue.common.helper.UrlUtf8;
import org.somda.sdc.glue.common.uri.UriMapperGenerationArgumentException;
import org.somda.sdc.glue.common.uri.UriMapperParsingException;

public class ComplexDeviceComponentMapper {
    private static final String SCHEME = "sdc.cdc.type";
    private static final Pattern PATTERN = new Pattern("^((?i:sdc\\.cdc\\.type):/(({codingSystem}(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$&'()*+,;=:@])+)+)|)/({codingSystemVersion}(?(codingSystem)(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$&'()*+,;=:@])+)*|" + GlueConstants.AUTHORITY + "))/({code}(?:(?:%[a-fA-F0-9]{2})+|(?:[a-zA-Z0-9\\-._~!$&'()*+,;=:@])+)+))$");

    public static String fromComplexDeviceComponent(AbstractComplexDeviceComponentDescriptor descriptor) throws UriMapperGenerationArgumentException {
        CodedValue codedValue = descriptor.getType();
        if (codedValue == null) {
            throw new UriMapperGenerationArgumentException("No CodedValue was provided");
        }
        return ComplexDeviceComponentMapper.fromCodedValue(codedValue);
    }

    public static String fromCodedValue(CodedValue codedValue) throws UriMapperGenerationArgumentException {
        String codingSystem = codedValue.getCodingSystem();
        if ("urn:oid:1.2.840.10004.1.1.1.0.0.1".equals(codingSystem)) {
            codingSystem = null;
        }
        String uri = "sdc.cdc.type:/" + UrlUtf8.encodePChars(codingSystem) + "/" + UrlUtf8.encodePChars(codedValue.getCodingSystemVersion()) + "/" + UrlUtf8.encodePChars(codedValue.getCode());
        try {
            ComplexDeviceComponentMapper.fromUri(uri);
        }
        catch (UriMapperParsingException e) {
            throw new UriMapperGenerationArgumentException("No valid URI could be generated from the given CodedValue with Code:" + codedValue.getCode() + ", CodingSystem:" + codedValue.getCodingSystem() + ", CodingSystemVersion:" + codedValue.getCodingSystemVersion());
        }
        return uri;
    }

    public static CodedValue fromUri(String complexDeviceComponentTypeUri) throws UriMapperParsingException {
        Matcher matcher = PATTERN.matcher(complexDeviceComponentTypeUri);
        if (matcher.matches()) {
            String codingSystem = UrlUtf8.decodePChars(matcher.group("codingSystem"));
            String codingSystemVersion = UrlUtf8.decodePChars(matcher.group("codingSystemVersion"));
            String code = UrlUtf8.decodePChars(matcher.group("code"));
            CodedValue codedValue = new CodedValue();
            codedValue.setCodingSystem(codingSystem.isEmpty() ? null : codingSystem);
            codedValue.setCodingSystemVersion(codingSystemVersion.isEmpty() ? null : codingSystemVersion);
            codedValue.setCode(code.isEmpty() ? null : code);
            return codedValue;
        }
        throw new UriMapperParsingException("Invalid URI for the mapper " + String.valueOf(ComplexDeviceComponentMapper.class));
    }
}

