/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.common.uri;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.somda.sdc.glue.common.uri.UriMapperGenerationArgumentException;
import org.somda.sdc.glue.common.uri.UriMapperParsingException;

public class ParticipantKeyPurposeMapper {
    private static final String SCHEME = "sdc.mds.pkp";
    private static final String SCHEME_PATTERN = "sdc.mds.pkp".replace(".", "\\.");
    private static final String NO_LEADING_ZERO_EXCEPT_FOR_SINGLE_DIGIT = "(0|([1-9][0-9]*))";
    private static final String OID_SEGMENT = "((((0|([1-9][0-9]*))\\.)*((0|([1-9][0-9]*))\\.(0|([1-9][0-9]*)))(\\.(0|([1-9][0-9]*)))*)|(0|([1-9][0-9]*)))";
    private static final Pattern PATTERN = Pattern.compile("^((?i:" + SCHEME_PATTERN + "):(?<oid>((((0|([1-9][0-9]*))\\.)*((0|([1-9][0-9]*))\\.(0|([1-9][0-9]*)))(\\.(0|([1-9][0-9]*)))*)|(0|([1-9][0-9]*)))))$");

    public static String fromOid(Oid oid) throws UriMapperGenerationArgumentException {
        String uri = "sdc.mds.pkp:" + String.valueOf(oid);
        try {
            ParticipantKeyPurposeMapper.fromUri(uri);
        }
        catch (UriMapperParsingException e) {
            throw new UriMapperGenerationArgumentException("No valid URI could be generated from the given OID: " + String.valueOf(oid));
        }
        return uri;
    }

    public static Oid fromUri(String uri) throws UriMapperParsingException {
        Matcher matcher = PATTERN.matcher(uri);
        if (matcher.matches()) {
            try {
                return new Oid(matcher.group("oid"));
            }
            catch (GSSException e) {
                throw new UriMapperParsingException("Invalid URI for the mapper " + String.valueOf(ParticipantKeyPurposeMapper.class) + " due to GSSException " + String.valueOf(e));
            }
        }
        throw new UriMapperParsingException("Invalid URI for the mapper " + String.valueOf(ParticipantKeyPurposeMapper.class));
    }
}

