/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.somda.sdc.glue.common.SubscribableActionsMapping;
import org.somda.sdc.glue.common.WsdlConstants;

public class ConnectConfiguration {
    public static final Collection<QName> PORT_TYPES = List.of(WsdlConstants.PORT_TYPE_GET_QNAME, WsdlConstants.PORT_TYPE_SET_QNAME, WsdlConstants.PORT_TYPE_DESCRIPTION_EVENT_QNAME, WsdlConstants.PORT_TYPE_STATE_EVENT_QNAME, WsdlConstants.PORT_TYPE_CONTEXT_QNAME, WsdlConstants.PORT_TYPE_WAVEFORM_QNAME, WsdlConstants.PORT_TYPE_CONTAINMENT_TREE_QNAME, WsdlConstants.PORT_TYPE_ARCHIVE_QNAME, WsdlConstants.PORT_TYPE_LOCALIZATION_QNAME);
    public static final Collection<String> EPISODIC_REPORTS = List.of("http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/EpisodicAlertReport", "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/EpisodicComponentReport", "http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/EpisodicContextReport", "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/EpisodicMetricReport", "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/EpisodicOperationalStateReport", "http://standards.ieee.org/downloads/11073/11073-20701-2018/DescriptionEventService/DescriptionModificationReport", "http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/OperationInvokedReport", "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/SystemErrorReport");
    public static final Collection<String> PERIODIC_REPORTS = List.of("http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicAlertReport", "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicComponentReport", "http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/PeriodicContextReport", "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicMetricReport", "http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicOperationalStateReport");
    public static final Collection<String> STREAMING_REPORTS = List.of("http://standards.ieee.org/downloads/11073/11073-20701-2018/WaveformService/ObservedValueStream", "http://standards.ieee.org/downloads/11073/11073-20701-2018/WaveformService/WaveformStream");
    public static final Collection<String> ALL_EPISODIC_AND_WAVEFORM_REPORTS;
    public static final Collection<String> DESCRIPTION_AND_CONTEXTS;
    public static final Collection<String> ALL_PERIODIC_AND_WAVEFORM_REPORTS;
    private static final Logger LOG;
    private final Collection<String> actions;
    private final Collection<QName> requiredPortTypes;

    private ConnectConfiguration(Collection<String> actions, Collection<QName> requiredPortTypes) {
        this.actions = new ArrayList<String>(actions);
        this.requiredPortTypes = new ArrayList<QName>(requiredPortTypes);
        this.requiredPortTypes.add(WsdlConstants.PORT_TYPE_GET_QNAME);
        this.requiredPortTypes.addAll(ConnectConfiguration.findRequiredQNamesBasedOnActions(this.actions));
    }

    public static ConnectConfiguration create() {
        return new ConnectConfiguration(Collections.emptyList(), Collections.emptyList());
    }

    public static ConnectConfiguration create(Collection<String> actions) {
        return new ConnectConfiguration(actions, Collections.emptyList());
    }

    public static ConnectConfiguration create(Collection<String> actions, Collection<QName> requiredPortTypes) {
        return new ConnectConfiguration(actions, requiredPortTypes);
    }

    public Collection<String> getActions() {
        return this.actions;
    }

    public Collection<QName> getRequiredPortTypes() {
        return this.requiredPortTypes;
    }

    private static Collection<QName> findRequiredQNamesBasedOnActions(Collection<String> actions) {
        HashSet<QName> qNames = new HashSet<QName>();
        actions.forEach(action -> {
            QName qName = SubscribableActionsMapping.TARGET_QNAMES.get(action);
            if (qName != null) {
                qNames.add(qName);
            }
        });
        if (qNames.isEmpty()) {
            LOG.warn("No matching QNames found for actions {}", new Supplier[]{() -> Arrays.toString(actions.toArray())});
        }
        return qNames;
    }

    static {
        DESCRIPTION_AND_CONTEXTS = Collections.unmodifiableCollection(Arrays.asList("http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/EpisodicContextReport", "http://standards.ieee.org/downloads/11073/11073-20701-2018/DescriptionEventService/DescriptionModificationReport", "http://standards.ieee.org/downloads/11073/11073-20701-2018/SetService/OperationInvokedReport"));
        LOG = LogManager.getLogger(ConnectConfiguration.class);
        ArrayList<String> allEpisodicAndWaveformReports = new ArrayList<String>(EPISODIC_REPORTS);
        allEpisodicAndWaveformReports.add("http://standards.ieee.org/downloads/11073/11073-20701-2018/WaveformService/WaveformStream");
        ALL_EPISODIC_AND_WAVEFORM_REPORTS = Collections.unmodifiableCollection(allEpisodicAndWaveformReports);
        ArrayList<String> allPeriodicAndWaveformReports = new ArrayList<String>(PERIODIC_REPORTS);
        allPeriodicAndWaveformReports.add("http://standards.ieee.org/downloads/11073/11073-20701-2018/WaveformService/WaveformStream");
        ALL_PERIODIC_AND_WAVEFORM_REPORTS = Collections.unmodifiableCollection(allPeriodicAndWaveformReports);
    }
}

