/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.somda.sdc.biceps.common.access.MdibAccessObservable;
import org.somda.sdc.biceps.consumer.access.RemoteMdibAccess;
import org.somda.sdc.biceps.model.message.AbstractGet;
import org.somda.sdc.biceps.model.message.AbstractSet;
import org.somda.sdc.biceps.model.message.AbstractSetResponse;
import org.somda.sdc.biceps.model.message.GetLocalizedText;
import org.somda.sdc.biceps.model.message.GetLocalizedTextResponse;
import org.somda.sdc.biceps.model.message.GetSupportedLanguages;
import org.somda.sdc.biceps.model.message.GetSupportedLanguagesResponse;
import org.somda.sdc.biceps.model.message.OperationInvokedReport;
import org.somda.sdc.biceps.model.participant.MdibVersion;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.glue.consumer.SdcRemoteDevice;
import org.somda.sdc.glue.consumer.SdcRemoteDeviceImpl;
import org.somda.sdc.glue.consumer.SdcRemoteDeviceWatchdog;
import org.somda.sdc.glue.consumer.SetServiceAccess;
import org.somda.sdc.glue.consumer.WatchdogObserver;
import org.somda.sdc.glue.consumer.helper.HostingServiceLogger;
import org.somda.sdc.glue.consumer.localization.LocalizationServiceAccess;
import org.somda.sdc.glue.consumer.localization.LocalizationServiceProxy;
import org.somda.sdc.glue.consumer.report.ReportProcessor;
import org.somda.sdc.glue.consumer.sco.ScoController;
import org.somda.sdc.glue.consumer.sco.ScoTransaction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B[\b\u0001\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0001\u0010\r\u001a\u00020\u000e\u0012\b\b\u0001\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0001\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0018H\u0014J\b\u0010%\u001a\u00020\u0018H\u0014J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/somda/sdc/glue/consumer/SdcRemoteDeviceImpl;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "Lorg/somda/sdc/glue/consumer/SdcRemoteDevice;", "hostingServiceProxy", "Lorg/somda/sdc/dpws/service/HostingServiceProxy;", "remoteMdibAccess", "Lorg/somda/sdc/biceps/consumer/access/RemoteMdibAccess;", "reportProcessor", "Lorg/somda/sdc/glue/consumer/report/ReportProcessor;", "scoController", "Lorg/somda/sdc/glue/consumer/sco/ScoController;", "localizationServiceProxy", "Lorg/somda/sdc/glue/consumer/localization/LocalizationServiceProxy;", "watchdog", "Lorg/somda/sdc/glue/consumer/SdcRemoteDeviceWatchdog;", "maxWait", "Ljava/time/Duration;", "frameworkIdentifier", "", "(Lorg/somda/sdc/dpws/service/HostingServiceProxy;Lorg/somda/sdc/biceps/consumer/access/RemoteMdibAccess;Lorg/somda/sdc/glue/consumer/report/ReportProcessor;Lorg/somda/sdc/glue/consumer/sco/ScoController;Lorg/somda/sdc/glue/consumer/localization/LocalizationServiceProxy;Lorg/somda/sdc/glue/consumer/SdcRemoteDeviceWatchdog;Ljava/time/Duration;Ljava/lang/String;)V", "instanceLogger", "Lorg/apache/logging/log4j/kotlin/KotlinLogger;", "kotlin.jvm.PlatformType", "checkRunning", "", "getHostingServiceProxy", "getLocalizationServiceAccess", "Lorg/somda/sdc/glue/consumer/localization/LocalizationServiceAccess;", "getMdibAccess", "getMdibAccessObservable", "Lorg/somda/sdc/biceps/common/access/MdibAccessObservable;", "getSetServiceAccess", "Lorg/somda/sdc/glue/consumer/SetServiceAccess;", "registerWatchdogObserver", "watchdogObserver", "Lorg/somda/sdc/glue/consumer/WatchdogObserver;", "shutDown", "startUp", "unregisterWatchdogObserver", "Companion", "glue"})
public final class SdcRemoteDeviceImpl
extends AbstractIdleService
implements SdcRemoteDevice {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HostingServiceProxy hostingServiceProxy;
    @NotNull
    private final RemoteMdibAccess remoteMdibAccess;
    @NotNull
    private final ReportProcessor reportProcessor;
    @Nullable
    private final ScoController scoController;
    @Nullable
    private final LocalizationServiceProxy localizationServiceProxy;
    @NotNull
    private final SdcRemoteDeviceWatchdog watchdog;
    @NotNull
    private final Duration maxWait;
    private final KotlinLogger instanceLogger;

    @AssistedInject
    public SdcRemoteDeviceImpl(@Assisted @NotNull HostingServiceProxy hostingServiceProxy, @Assisted @NotNull RemoteMdibAccess remoteMdibAccess, @Assisted @NotNull ReportProcessor reportProcessor, @Assisted @Nullable ScoController scoController, @Assisted @Nullable LocalizationServiceProxy localizationServiceProxy, @Assisted @NotNull SdcRemoteDeviceWatchdog watchdog, @Named(value="Dpws.MaxWaitForFutures") @NotNull Duration maxWait, @Named(value="Common.InstanceIdentifier") @NotNull String frameworkIdentifier) {
        Intrinsics.checkNotNullParameter((Object)hostingServiceProxy, (String)"hostingServiceProxy");
        Intrinsics.checkNotNullParameter((Object)remoteMdibAccess, (String)"remoteMdibAccess");
        Intrinsics.checkNotNullParameter((Object)((Object)reportProcessor), (String)"reportProcessor");
        Intrinsics.checkNotNullParameter((Object)((Object)watchdog), (String)"watchdog");
        Intrinsics.checkNotNullParameter((Object)maxWait, (String)"maxWait");
        Intrinsics.checkNotNullParameter((Object)frameworkIdentifier, (String)"frameworkIdentifier");
        this.hostingServiceProxy = hostingServiceProxy;
        this.remoteMdibAccess = remoteMdibAccess;
        this.reportProcessor = reportProcessor;
        this.scoController = scoController;
        this.localizationServiceProxy = localizationServiceProxy;
        this.watchdog = watchdog;
        this.maxWait = maxWait;
        this.instanceLogger = HostingServiceLogger.getLogger(Companion.getLogger(), this.hostingServiceProxy, frameworkIdentifier);
    }

    @Override
    @NotNull
    public HostingServiceProxy getHostingServiceProxy() {
        this.checkRunning();
        return this.hostingServiceProxy;
    }

    @NotNull
    public RemoteMdibAccess getMdibAccess() {
        this.checkRunning();
        return this.remoteMdibAccess;
    }

    @Override
    @NotNull
    public MdibAccessObservable getMdibAccessObservable() {
        this.checkRunning();
        return (MdibAccessObservable)this.remoteMdibAccess;
    }

    @Override
    @NotNull
    public SetServiceAccess getSetServiceAccess() {
        this.checkRunning();
        if (this.scoController == null) {
            return new SetServiceAccess(this){
                final /* synthetic */ SdcRemoteDeviceImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public <T extends AbstractSet, V extends AbstractSetResponse> ListenableFuture<ScoTransaction<V>> invoke(@NotNull T setRequest, @NotNull Class<V> responseClass) {
                    Intrinsics.checkNotNullParameter(setRequest, (String)"setRequest");
                    Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
                    return this.invoke(setRequest, null, responseClass);
                }

                @NotNull
                public <T extends AbstractSet, V extends AbstractSetResponse> ListenableFuture<ScoTransaction<V>> invoke(@NotNull T setRequest, @Nullable Consumer<Pair<OperationInvokedReport.ReportPart, MdibVersion>> reportListener, @NotNull Class<V> responseClass) {
                    Intrinsics.checkNotNullParameter(setRequest, (String)"setRequest");
                    Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
                    SdcRemoteDeviceImpl.access$getInstanceLogger$p(this.this$0).warn((Function0)new Function0<Object>(setRequest){
                        final /* synthetic */ T $setRequest;
                        {
                            this.$setRequest = $setRequest;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Remote device does not provide a set service. " + this.$setRequest.getClass().getSimpleName() + " refused.";
                        }
                    });
                    ListenableFuture listenableFuture = Futures.immediateCancelledFuture();
                    Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateCancelledFuture(...)");
                    return listenableFuture;
                }
            };
        }
        return this.scoController;
    }

    @Override
    public void registerWatchdogObserver(@NotNull WatchdogObserver watchdogObserver) {
        Intrinsics.checkNotNullParameter((Object)watchdogObserver, (String)"watchdogObserver");
        this.checkRunning();
        this.watchdog.registerObserver(watchdogObserver);
    }

    @Override
    public void unregisterWatchdogObserver(@NotNull WatchdogObserver watchdogObserver) {
        Intrinsics.checkNotNullParameter((Object)watchdogObserver, (String)"watchdogObserver");
        this.checkRunning();
        this.watchdog.unregisterObserver(watchdogObserver);
    }

    @Override
    @NotNull
    public LocalizationServiceAccess getLocalizationServiceAccess() {
        this.checkRunning();
        if (this.localizationServiceProxy == null) {
            return new LocalizationServiceAccess(this){
                final /* synthetic */ SdcRemoteDeviceImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public ListenableFuture<GetLocalizedTextResponse> getLocalizedText(@NotNull GetLocalizedText getLocalizedTextRequest) {
                    Intrinsics.checkNotNullParameter((Object)getLocalizedTextRequest, (String)"getLocalizedTextRequest");
                    SdcRemoteDeviceImpl.access$getInstanceLogger$p(this.this$0).warn((Function0)new Function0<Object>(getLocalizedTextRequest){
                        final /* synthetic */ GetLocalizedText $getLocalizedTextRequest;
                        {
                            this.$getLocalizedTextRequest = $getLocalizedTextRequest;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return SdcRemoteDeviceImpl.access$getLocalizationServiceAccess$message((AbstractGet)this.$getLocalizedTextRequest);
                        }
                    });
                    ListenableFuture listenableFuture = Futures.immediateCancelledFuture();
                    Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateCancelledFuture(...)");
                    return listenableFuture;
                }

                @NotNull
                public ListenableFuture<GetSupportedLanguagesResponse> getSupportedLanguages(@NotNull GetSupportedLanguages getSupportedLanguagesRequest) {
                    Intrinsics.checkNotNullParameter((Object)getSupportedLanguagesRequest, (String)"getSupportedLanguagesRequest");
                    SdcRemoteDeviceImpl.access$getInstanceLogger$p(this.this$0).warn((Function0)new Function0<Object>(getSupportedLanguagesRequest){
                        final /* synthetic */ GetSupportedLanguages $getSupportedLanguagesRequest;
                        {
                            this.$getSupportedLanguagesRequest = $getSupportedLanguagesRequest;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return SdcRemoteDeviceImpl.access$getLocalizationServiceAccess$message((AbstractGet)this.$getSupportedLanguagesRequest);
                        }
                    });
                    ListenableFuture listenableFuture = Futures.immediateCancelledFuture();
                    Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateCancelledFuture(...)");
                    return listenableFuture;
                }
            };
        }
        return this.localizationServiceProxy;
    }

    protected void startUp() throws TimeoutException {
        this.watchdog.startAsync().awaitRunning(this.maxWait.getSeconds(), TimeUnit.SECONDS);
    }

    protected void shutDown() {
        try {
            this.watchdog.stopAsync().awaitTerminated(this.maxWait.getSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.instanceLogger.error((Throwable)e, (Function0)shutDown.1.INSTANCE);
        }
        try {
            this.reportProcessor.stopAsync().awaitTerminated(this.maxWait.getSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.instanceLogger.error((Throwable)e, (Function0)shutDown.2.INSTANCE);
        }
        List hostedServices = CollectionsKt.toList((Iterable)this.hostingServiceProxy.getHostedServices().values());
        for (HostedServiceProxy hostedService : hostedServices) {
            hostedService.getEventSinkAccess().unsubscribeAll();
        }
        this.remoteMdibAccess.unregisterAllObservers();
    }

    private final void checkRunning() {
        if (!this.isRunning()) {
            boolean bl = false;
            String string = "Tried to access a disconnected SDC remote device instance with EPR address " + this.hostingServiceProxy.getEndpointReferenceAddress();
            throw new IllegalStateException(string.toString());
        }
    }

    private static final String getLocalizationServiceAccess$message(AbstractGet request) {
        return "Remote device does not provide a localization service. " + request.getClass().getSimpleName() + " refused.";
    }

    public static final /* synthetic */ KotlinLogger access$getInstanceLogger$p(SdcRemoteDeviceImpl $this) {
        return $this.instanceLogger;
    }

    public static final /* synthetic */ String access$getLocalizationServiceAccess$message(AbstractGet request) {
        return SdcRemoteDeviceImpl.getLocalizationServiceAccess$message(request);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/somda/sdc/glue/consumer/SdcRemoteDeviceImpl$Companion;", "Lorg/apache/logging/log4j/kotlin/Logging;", "()V", "glue"})
    public static final class Companion
    implements Logging {
        private Companion() {
        }

        @NotNull
        public KotlinLogger getLogger() {
            return Logging.DefaultImpls.getLogger((Logging)this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

