/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer.localization;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.biceps.model.message.AbstractGetResponse;
import org.somda.sdc.biceps.model.message.GetLocalizedText;
import org.somda.sdc.biceps.model.message.GetLocalizedTextResponse;
import org.somda.sdc.biceps.model.message.GetSupportedLanguages;
import org.somda.sdc.biceps.model.message.GetSupportedLanguagesResponse;
import org.somda.sdc.biceps.model.participant.LocalizedText;
import org.somda.sdc.biceps.model.participant.LocalizedTextWidth;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.glue.common.LocalizationServiceFilterUtil;
import org.somda.sdc.glue.consumer.helper.HostingServiceLogger;
import org.somda.sdc.glue.consumer.localization.LocalizationServiceAccess;
import org.somda.sdc.glue.consumer.sco.InvocationException;
import org.somda.sdc.glue.guice.Consumer;

public class LocalizationServiceProxy
implements LocalizationServiceAccess {
    private static final Logger LOG = LogManager.getLogger(LocalizationServiceProxy.class);
    private final HostedServiceProxy hostedServiceProxy;
    private final ExecutorWrapperService<ListeningExecutorService> executorService;
    private final SoapUtil soapUtil;
    private final Logger instanceLogger;
    private final Map<BigInteger, Table<String, String, Map<LocalizedTextWidth, LocalizedText>>> localizationCache = new HashMap<BigInteger, Table<String, String, Map<LocalizedTextWidth, LocalizedText>>>();
    private final Set<BigInteger> fullyCachedVersions = new HashSet<BigInteger>();
    private final Map<BigInteger, Set<String>> cachedVersionsToLanguageMap = new HashMap<BigInteger, Set<String>>();

    @AssistedInject
    LocalizationServiceProxy(@Assisted HostingServiceProxy hostingServiceProxy, @Assisted(value="localizationServiceProxy") @Nullable HostedServiceProxy hostedServiceProxy, @Consumer ExecutorWrapperService<ListeningExecutorService> executorService, SoapUtil soapUtil, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = HostingServiceLogger.getLogger(LOG, hostingServiceProxy, frameworkIdentifier);
        this.hostedServiceProxy = hostedServiceProxy;
        this.executorService = executorService;
        this.soapUtil = soapUtil;
    }

    @Override
    public ListenableFuture<GetLocalizedTextResponse> getLocalizedText(GetLocalizedText getLocalizedText2) {
        return ((ListeningExecutorService)this.executorService.get()).submit(() -> {
            this.instanceLogger.debug("Invoke GetLocalizedText with payload: {}", (Object)getLocalizedText2.toString());
            List<LocalizedText> texts = this.getLocalizedTextFromCache(getLocalizedText2);
            if (texts != null && !texts.isEmpty()) {
                GetLocalizedTextResponse response = new GetLocalizedTextResponse();
                response.setText(texts);
                return response;
            }
            SoapMessage request = this.soapUtil.createMessage("http://standards.ieee.org/downloads/11073/11073-20701-2018/LocalizationService/GetLocalizedText", (Object)getLocalizedText2);
            return this.sendMessage(request, GetLocalizedTextResponse.class);
        });
    }

    @Override
    public ListenableFuture<GetSupportedLanguagesResponse> getSupportedLanguages(GetSupportedLanguages getSupportedLanguages2) {
        return ((ListeningExecutorService)this.executorService.get()).submit(() -> {
            this.instanceLogger.debug("Invoke GetSupportedLanguages");
            SoapMessage request = this.soapUtil.createMessage("http://standards.ieee.org/downloads/11073/11073-20701-2018/LocalizationService/GetSupportedLanguages", (Object)getSupportedLanguages2);
            return this.sendMessage(request, GetSupportedLanguagesResponse.class);
        });
    }

    @Override
    public void cachePrefetch(BigInteger version) throws InvocationException {
        this.fullyCachedVersions.add(version);
        this.cachePrefetch(version, Collections.emptyList());
    }

    @Override
    public void cachePrefetch(BigInteger version, List<String> lang) throws InvocationException {
        Table<String, String, Map<LocalizedTextWidth, LocalizedText>> localizedTextTable = this.fetchLocalizedTextCache(version, lang);
        this.updateCache(version, localizedTextTable);
    }

    private void updateCache(BigInteger version, Table<String, String, Map<LocalizedTextWidth, LocalizedText>> localizedTextTable) {
        if (!this.localizationCache.containsKey(version)) {
            this.localizationCache.put(version, localizedTextTable);
        } else {
            this.localizationCache.get(version).putAll(localizedTextTable);
        }
        this.updateCachedVersionMap(version, localizedTextTable);
    }

    private void updateCachedVersionMap(BigInteger version, Table<String, String, Map<LocalizedTextWidth, LocalizedText>> localizedTextTable) {
        if (!this.cachedVersionsToLanguageMap.containsKey(version)) {
            this.cachedVersionsToLanguageMap.put(version, new HashSet());
        }
        this.cachedVersionsToLanguageMap.get(version).addAll(localizedTextTable.columnKeySet());
    }

    private Table<String, String, Map<LocalizedTextWidth, LocalizedText>> fetchLocalizedTextCache(BigInteger version, List<String> lang) throws InvocationException {
        GetLocalizedText request = new GetLocalizedText();
        request.setVersion(version);
        request.setLang(lang);
        SoapMessage requestMsg = this.soapUtil.createMessage("http://standards.ieee.org/downloads/11073/11073-20701-2018/LocalizationService/GetLocalizedText", (Object)request);
        GetLocalizedTextResponse response = this.sendMessage(requestMsg, GetLocalizedTextResponse.class);
        HashBasedTable localizedTextTable = HashBasedTable.create();
        if (response != null && response.getText() != null && !response.getText().isEmpty()) {
            response.getText().forEach(arg_0 -> LocalizationServiceProxy.lambda$fetchLocalizedTextCache$2((Table)localizedTextTable, arg_0));
        }
        return localizedTextTable;
    }

    private List<LocalizedText> getLocalizedTextFromCache(GetLocalizedText getLocalizedText2) throws InvocationException {
        if (!getLocalizedText2.getNumberOfLines().isEmpty()) {
            return Collections.emptyList();
        }
        List<LocalizedText> texts = this.queryLocalizedTextFromCache(getLocalizedText2);
        if (texts == null || texts.isEmpty()) {
            List requestedLanguages;
            List list = requestedLanguages = getLocalizedText2.getLang() != null ? getLocalizedText2.getLang() : Collections.emptyList();
            if (requestedLanguages.size() == 1) {
                this.cachePrefetch(getLocalizedText2.getVersion(), requestedLanguages);
                return this.queryLocalizedTextFromCache(getLocalizedText2);
            }
        }
        return texts;
    }

    private List<LocalizedText> queryLocalizedTextFromCache(GetLocalizedText getLocalizedText2) {
        if (!this.cacheExist(getLocalizedText2.getVersion(), getLocalizedText2.getLang())) {
            return Collections.emptyList();
        }
        Multimap<String, Map<LocalizedTextWidth, LocalizedText>> refToValueMap = LocalizationServiceFilterUtil.filterByLanguage(this.localizationCache.get(getLocalizedText2.getVersion()), getLocalizedText2.getLang());
        List references = getLocalizedText2.getRef();
        List<Object> filteredByReference = references.isEmpty() ? new ArrayList(refToValueMap.values()) : LocalizationServiceFilterUtil.filterByReferences(refToValueMap, references);
        List textWidth = getLocalizedText2.getTextWidth();
        Optional maxTextWidth = textWidth.stream().max(Enum::compareTo);
        return filteredByReference.stream().flatMap(textWidthMap -> {
            if (maxTextWidth.isEmpty()) {
                return textWidthMap.values().stream();
            }
            return textWidthMap.entrySet().stream().filter(e -> ((LocalizedTextWidth)e.getKey()).compareTo((Enum)((LocalizedTextWidth)maxTextWidth.orElseThrow())) <= 0).map(Map.Entry::getValue);
        }).collect(Collectors.toList());
    }

    private boolean cacheExist(@Nullable BigInteger version, List<String> languages) {
        if (version == null) {
            return false;
        }
        if (CollectionUtils.isEmpty(languages) && !this.fullyCachedVersions.contains(version)) {
            return false;
        }
        return this.localizationCache.containsKey(version) && this.cachedVersionsToLanguageMap.containsKey(version) && this.cachedVersionsToLanguageMap.get(version).containsAll(languages);
    }

    private <T extends AbstractGetResponse> T sendMessage(SoapMessage request, Class<T> expectedResponseClass) throws InvocationException {
        try {
            if (this.hostedServiceProxy == null) {
                throw new InvocationException("Request could not be sent: no localization service available");
            }
            SoapMessage response = this.hostedServiceProxy.getRequestResponseClient().sendRequestResponse(request);
            return (T)((AbstractGetResponse)this.soapUtil.getBody(response, expectedResponseClass).orElseThrow(() -> new InvocationException("Received unexpected response")));
        }
        catch (MarshallingException | SoapFaultException | TransportException | InterceptorException e) {
            throw new InvocationException(String.format("Request to %s failed: %s", this.hostedServiceProxy.getActiveEprAddress(), e.getMessage()), e);
        }
    }

    private static /* synthetic */ void lambda$fetchLocalizedTextCache$2(Table localizedTextTable, LocalizedText localizedText) {
        HashMap<LocalizedTextWidth, LocalizedText> widthMap = (HashMap<LocalizedTextWidth, LocalizedText>)localizedTextTable.get((Object)localizedText.getRef(), (Object)localizedText.getLang());
        if (widthMap == null) {
            widthMap = new HashMap<LocalizedTextWidth, LocalizedText>();
        }
        widthMap.put(localizedText.getTextWidth(), localizedText);
        localizedTextTable.put((Object)localizedText.getRef(), (Object)localizedText.getLang(), widthMap);
    }
}

